/*
 * generated by Xtext 2.15.0
 */
package org.xtext.example.crr.langb.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.crr.langb.langB.LangBPackage;
import org.xtext.example.crr.langb.langB.Model;
import org.xtext.example.crr.langb.langB.Use1;
import org.xtext.example.crr.langb.langB.Use2;
import org.xtext.example.crr.langb.langB.UseRef;
import org.xtext.example.crr.langb.services.LangBGrammarAccess;

@SuppressWarnings("all")
public class LangBSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private LangBGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == LangBPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case LangBPackage.MODEL:
				sequence_Model(context, (Model) semanticObject); 
				return; 
			case LangBPackage.USE1:
				sequence_Use1(context, (Use1) semanticObject); 
				return; 
			case LangBPackage.USE2:
				sequence_Use2(context, (Use2) semanticObject); 
				return; 
			case LangBPackage.USE_REF:
				sequence_UseRef(context, (UseRef) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Model returns Model
	 *
	 * Constraint:
	 *     ((uses1+=Use1+ uses2+=Use2+) | uses2+=Use2+)?
	 */
	protected void sequence_Model(ISerializationContext context, Model semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Use1 returns Use1
	 *
	 * Constraint:
	 *     name=[Definition|ID]
	 */
	protected void sequence_Use1(ISerializationContext context, Use1 semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, LangBPackage.Literals.USE1__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, LangBPackage.Literals.USE1__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUse1Access().getNameDefinitionIDTerminalRuleCall_1_0_1(), semanticObject.eGet(LangBPackage.Literals.USE1__NAME, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Use2 returns Use2
	 *
	 * Constraint:
	 *     name=UseRef
	 */
	protected void sequence_Use2(ISerializationContext context, Use2 semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, LangBPackage.Literals.USE2__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, LangBPackage.Literals.USE2__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUse2Access().getNameUseRefParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     UseRef returns UseRef
	 *
	 * Constraint:
	 *     name=[Definition|ID]
	 */
	protected void sequence_UseRef(ISerializationContext context, UseRef semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, LangBPackage.Literals.USE_REF__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, LangBPackage.Literals.USE_REF__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUseRefAccess().getNameDefinitionIDTerminalRuleCall_0_1(), semanticObject.eGet(LangBPackage.Literals.USE_REF__NAME, false));
		feeder.finish();
	}
	
	
}
