package org.eclipse.californium.examples;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;

import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP.Code;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;


public class CoAPClient {
	
	public static CoapClient client;
	public static Random r = new Random();
	
	/**
	 * Helper method for wrapping other operations.
	 * @param r
	 * @param operationUri
	 * @throws URISyntaxException
	 */
	public static void performOperation(Request r, String operationUri) throws URISyntaxException{
		CoapClient c = new CoapClient(new URI(operationUri));
		CoapResponse cr = c.advanced(r);
	}
	
	/**
	 * Returns the string used when creating 
	 * a new Application Entity (AE) on the platform.
	 * @param AEname
	 * @return
	 */
	public static Request returnCreateAEString(String AEname){
		
		String createApplicationBody = "<om2m:ae xmlns:om2m=\"http://www.onem2m.org/xml/protocols\" rn=\""+AEname+"\">" + 
		    	"<api>app-sensor</api>" +
				"<lbl>Type/sensor Category/temperature Location/home</lbl>" + 
		    	"<rr>true</rr>" + 
		    "</om2m:ae>";
		
		Request createApplication = new Request(Code.POST);
		byte[] b1 = new byte[8];
		new Random().nextBytes(b1);
		createApplication.setToken(b1);
		createApplication.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, 2));  		  // RESOURCE TYPE OPTION
		   //.addOption(new Option(268, AEname));  	  // NAME OPTION (DEPRECATED)
		createApplication.setPayload(createApplicationBody);
		return createApplication;
	}
	
	/**
	 * Returns the string for creating the DESCRIPTOR container.
	 * @return
	 */
	public static Request returnCreateDESCRIPTORContainerString(){
		
		// Create a DESCRIPTOR container
		String createDESCRIPTORBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\" rn=\"DESCRIPTOR\">" +
										"</om2m:cnt>";
		
		Request createDESCRIPTOR = new Request(Code.POST);
		byte[] b3 = new byte[8];
		new Random().nextBytes(b3);
		createDESCRIPTOR.setToken(b3); 
		createDESCRIPTOR.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, 3));  		  // RESOURCE TYPE OPTION
		   //.addOption(new Option(268, "DESCRIPTOR"));  // NAME OPTION (DEPRECATED)
		createDESCRIPTOR.setPayload(createDESCRIPTORBody);
		
		return createDESCRIPTOR;
	}
	
	/**
	 * Returns the string used for creating the DESCRIPTOR content instance.
	 * @param AEName
	 * @return
	 */
	public static Request returnCreateDESCRIPTORInstanceString(String AEName){
		
		// Create a description contentInstance
		String createDESCRIPTORcontentInstanceBody = 
				"<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + "\n" +
						"<cnf>message</cnf>" + "\n" +
						"<con>" +  "\n" +
							"&lt;obj&gt;" +  "\n" +
							"&lt;str name=&quot;type&quot; val=&quot;Temperature_Sensor&quot;/&gt;" + "\n" +
							"&lt;str name=&quot;location&quot; val=&quot;Home&quot;/&gt;" +  "\n" +
							"&lt;str name=&quot;appId&quot; val=&quot;"+AEName+"&quot;/&gt;" + "\n" +
							"&lt;op name=&quot;getValue&quot; href=&quot;/in-cse/"+AEName+"/DATA/la&quot;" +  "\n" +
							"in=&quot;obix:Nil&quot; out=&quot;obix:Nil&quot; is=&quot;retrieve&quot;/&gt;" +  "\n" +
							"&lt;/obj&gt;" + "\n" +
					   "</con>" +  "\n" +
			    "</om2m:cin>";

		Request createDESCRIPTORcontentInstance = new Request(Code.POST);
		byte[] b4 = new byte[8];
		new Random().nextBytes(b4);
		createDESCRIPTORcontentInstance.setToken(b4); 
		createDESCRIPTORcontentInstance.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) // FROM OPTION
		.addOption(new Option(267, 4));  		   // RESOURCE TYPE OPTION
		createDESCRIPTORcontentInstance.setPayload(createDESCRIPTORcontentInstanceBody);
		return createDESCRIPTORcontentInstance;
	}
	
	/**
	 * Returns the string for creating the DATA container.
	 * @return
	 */
	public static Request returnCreateDATAContainerString(){
		// Create a DATA container
		String createDATAcontainerBody = 
				"<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\" rn=\"DATA\">" +
						"</om2m:cnt>";

		Request createDATAcontainer = new Request(Code.POST);
		byte[] b5 = new byte[8];
		new Random().nextBytes(b5);
		createDATAcontainer.setToken(b5);
		createDATAcontainer.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) // FROM OPTION
		.addOption(new Option(267, 3));  		  // RESOURCE TYPE OPTION
		//.addOption(new Option(268, "DATA"));  // NAME OPTION (DEPRECATED)
		createDATAcontainer.setPayload(createDATAcontainerBody);
		return createDATAcontainer;
	}
	
	/**
	 * Returns the string for creating the DATA container instance.
	 * @param AEName
	 * @return
	 */
	public static Request returnCreateDATAInstanceString(String AEName){
		
		//Create a data contentInstance
		String createDATAcontentInstanceBody = 
				"<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + 
				    "<cnf>message</cnf>" +
				    "<con>" +
				      "&lt;obj&gt;" +
				        "&lt;str name=&quot;appId&quot; val=&quot;"+AEName+"&quot;/&gt;" +
				        "&lt;str name=&quot;category&quot; val=&quot;temperature &quot;/&gt;" +
				        "&lt;int name=&quot;data&quot; val=&quot;27&quot;/&gt;" +
				        "&lt;int name=&quot;unit&quot; val=&quot;celsius&quot;/&gt;" +
				      "&lt;/obj&gt;" +
				    "</con>" +
				"</om2m:cin>";

		Request createDATAcontentInstance = new Request(Code.POST);
		byte[] b6 = new byte[8];
		new Random().nextBytes(b6);
		createDATAcontentInstance.setToken(b6); 
		createDATAcontentInstance.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) 	// FROM OPTION
		.addOption(new Option(267, 4));  		  	// RESOURCE TYPE OPTION
		createDATAcontentInstance.setPayload(createDATAcontentInstanceBody);
		return createDATAcontentInstance;
	}
	
	/**
	 * Returns the string for retrieving a resource on the platform.
	 * @return
	 */
	public static Request returnRetrieveAResourceString(){
		// Retrieve a resource
		Request retrieveSrc = new Request(Code.GET);
		byte[] b = new byte[8];
		new Random().nextBytes(b);
		retrieveSrc.setToken(b); 
		retrieveSrc.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin"));
		return retrieveSrc;
	}
	
	/**
	 * Returns the string for searching resources on the platform.
	 * @return
	 */
	public static Request returnDiscoverResourceString(){
		// Discover resources based on their search strings
		Request discoverRSrc = new Request(Code.GET);
		byte[] b2 = new byte[8];
		new Random().nextBytes(b2);
		discoverRSrc.setToken(b2); 
		discoverRSrc.getOptions()
		   .addOption(new Option(256, "admin:admin"));
		return discoverRSrc;
	}
	
	/**
	 * Returns the string for subscribing to an AE's messages
	 * in the form of notifications.
	 * @param notificationUrl
	 * @return
	 */
	public static Request returnSubscribeToDeviceMessagesString(String notificationUrl){
		// Subscribe to AE data -- The Monitor application must be running before executing this method!!!!
		String subscribeBody = 
				"<m2m:sub xmlns:m2m=\"http://www.onem2m.org/xml/protocols\" rn=\"COAP_SUB\">"+
				    "<nu>coap://"+notificationUrl+"</nu>" + 
				    "<nct>2</nct>" + 
				"</m2m:sub>";

		Request subscribe = new Request(Code.POST);
		byte[] b7 = new byte[8];
		r.nextBytes(b7);
		subscribe.setToken(b7); 
		subscribe.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) 		// FROM OPTION
		.addOption(new Option(267, 23)); 		  		// RESOURCE TYPE OPTION
		//.addOption(new Option(268, "COAP_SUB"));  	// NAME OPTION (DEPRECATED)
		subscribe.setPayload(subscribeBody);
		return subscribe;
	}
	
	public static void main(String args[]) throws URISyntaxException, InterruptedException {
		
		String tempName = "MY_SENSOR";
		
		// Create a "MY_SENSOR" application
		performOperation(returnCreateAEString(tempName), "coap://127.0.0.1:5683/~/in-cse");
		
		// Create a DESCRIPTOR container
		performOperation(returnCreateDESCRIPTORContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/" + tempName);
		
		// Create a descriptor contentInstance
		performOperation(returnCreateDESCRIPTORInstanceString(tempName),"coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName+"/DESCRIPTOR");
		
		// Create a DATA container
		performOperation(returnCreateDATAContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName);
		
		//Create a data contentInstance
		performOperation(returnCreateDATAInstanceString(tempName), "coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName+"/DATA");
		
		// Retrieve a resource
		performOperation(returnRetrieveAResourceString(), "coap://127.0.0.1:5683/~/in-cse");
		
		// Discover resources based on their search strings
		performOperation(returnDiscoverResourceString(), "coap://127.0.0.1:5683/~/in-cse?fu=1&lbl=Type/sensor");
		
		// Before executing this line, make sure the "coapmonitor.jar" application, which listens for notifications,
		// is started, otherwise exceptions will be thrown
		performOperation(returnSubscribeToDeviceMessagesString("127.0.0.1:5685/monitor"), "coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName+"/DATA");
	}
}
