/*******************************************************************************
 * Copyright (c) 2015 Institute for Pervasive Computing, ETH Zurich and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 * 
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *    http://www.eclipse.org/org/documents/edl-v10.html.
 * 
 * Contributors:
 *    Matthias Kovatsch - creator and main architect
 ******************************************************************************/
package org.eclipse.californium.examples;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;

import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP.Code;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;


public class GETClient {
	
	public static CoapClient client;
	public static Random r = new Random();
	
	public static Request returnCreateAEString(String name){
		
		String createApplicationBody = "<om2m:ae xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + 
		    	"<api>app-sensor</api>" + 
		    	"<lbl>Type/sensor Category/temperature Location/home</lbl>" + 
		    	"<rr>false</rr>" + 
		    "</om2m:ae>";
		
		Request createApplication = new Request(Code.POST);
		byte[] b1 = new byte[8];
		new Random().nextBytes(b1);
		createApplication.setToken(b1);
		createApplication.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, "2"))  		  // RESOURCE TYPE OPTION
		   .addOption(new Option(268, name));  // NAME OPTION
		createApplication.setPayload(createApplicationBody);
		return createApplication;
	}
	
	public static Request returnCreateDESCRIPTORContainerString(){
		
		// Create a DESCRIPTOR container
		String createDESCRIPTORBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" +
										"</om2m:cnt>";
		
		Request createDESCRIPTOR = new Request(Code.POST);
		byte[] b3 = new byte[8];
		new Random().nextBytes(b3);
		createDESCRIPTOR.setToken(b3); 
		createDESCRIPTOR.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, "3"))  		  // RESOURCE TYPE OPTION
		   .addOption(new Option(268, "DESCRIPTOR"));  // NAME OPTION
		createDESCRIPTOR.setPayload(createDESCRIPTORBody);
		
		return createDESCRIPTOR;
	}
	
	public static Request returnCreateDESCRIPTORInstanceString(){
		
		// Create a description contentInstance
		String createDESCRIPTORcontentInstanceBody = 
				"<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + "\n" +
						"<cnf>message</cnf>" + "\n" +
						"<con>" +  "\n" +
							"&lt;obj&gt;" +  "\n" +
							"&lt;str name=&quot;type&quot; val=&quot;Temperature_Sensor&quot;/&gt;" + "\n" +
							"&lt;str name=&quot;location&quot; val=&quot;Home&quot;/&gt;" +  "\n" +
							"&lt;str name=&quot;appId&quot; val=&quot;MY_SENSOR&quot;/&gt;" + "\n" +
							"&lt;op name=&quot;getValue&quot; href=&quot;/in-cse/MY_SENSOR/DATA/la&quot;" +  "\n" +
							"in=&quot;obix:Nil&quot; out=&quot;obix:Nil&quot; is=&quot;retrieve&quot;/&gt;" +  "\n" +
							"&lt;/obj&gt;" + "\n" +
					   "</con>" +  "\n" +
			    "</om2m:cin>";

		Request createDESCRIPTORcontentInstance = new Request(Code.POST);
		byte[] b4 = new byte[8];
		new Random().nextBytes(b4);
		createDESCRIPTORcontentInstance.setToken(b4); 
		createDESCRIPTORcontentInstance.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) // FROM OPTION
		.addOption(new Option(267, "4"));  		   // RESOURCE TYPE OPTION
		createDESCRIPTORcontentInstance.setPayload(createDESCRIPTORcontentInstanceBody);
		return createDESCRIPTORcontentInstance;
	}
	
	public static Request returnCreateDATAContainerString(){
		// Create a DATA container
		String createDATAcontainerBody = 
				"<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" +
						"</om2m:cnt>";

		Request createDATAcontainer = new Request(Code.POST);
		//byte[] b5 = new byte[8];
		byte[] b5 = new byte[8];
		new Random().nextBytes(b5);
		createDATAcontainer.setToken(b5);
		createDATAcontainer.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) // FROM OPTION
		.addOption(new Option(267, "3"))  		  // RESOURCE TYPE OPTION
		.addOption(new Option(268, "DATA"));  // NAME OPTION
		createDATAcontainer.setPayload(createDATAcontainerBody);
		return createDATAcontainer;
	}
	
	
	
	public static void main(String args[]) throws URISyntaxException, InterruptedException {
		
		// Retrieve a resource
		Request retrieveSrc = new Request(Code.GET);
		byte[] b = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		
		//byte[] b = new byte[8];
		r.nextBytes(b);
		retrieveSrc.setToken(b); 
		retrieveSrc.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin"));
		
		
		// Create a "MY_SENSOR" application
		String createApplicationBody = "<om2m:ae xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + 
		    	"<api>app-sensor</api>" + 
		    	"<lbl>Type/sensor Category/temperature Location/home</lbl>" + 
		    	"<rr>false</rr>" + 
		    "</om2m:ae>";
		
		Request createApplication = new Request(Code.POST);
		//byte[] b1 = new byte[8];
		byte[] b1 = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		
		r.nextBytes(b1);
		createApplication.setToken(b1);
		createApplication.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, "2"))  		  // RESOURCE TYPE OPTION
		   .addOption(new Option(268, "MY_SENSOR"));  // NAME OPTION
		createApplication.setPayload(createApplicationBody);
		
		// Discover resources based on their search strings
		Request discoverRSrc = new Request(Code.GET);
		//byte[] b2 = new byte[8];
		byte[] b2 = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		
		r.nextBytes(b2);
		discoverRSrc.setToken(b2); 
		discoverRSrc.getOptions()
		   .addOption(new Option(256, "admin:admin"));
		
		// Create a DESCRIPTOR container
		String createDESCRIPTORBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" +
										"</om2m:cnt>";
		
		Request createDESCRIPTOR = new Request(Code.POST);
		//byte[] b3 = new byte[8];
		byte[] b3 = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		
		r.nextBytes(b3);
		createDESCRIPTOR.setToken(b3); 
		createDESCRIPTOR.getOptions()
		   .setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		   .setAccept(MediaTypeRegistry.APPLICATION_XML)
		   .addOption(new Option(256, "admin:admin")) // FROM OPTION
		   .addOption(new Option(267, "3"))  		  // RESOURCE TYPE OPTION
		   .addOption(new Option(268, "DESCRIPTOR"));  // NAME OPTION
		createDESCRIPTOR.setPayload(createDESCRIPTORBody);
		
		// Create a DATA container
		String createDATAcontainerBody = 
				"<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" +
						"</om2m:cnt>";

		Request createDATAcontainer = new Request(Code.POST);
		//byte[] b5 = new byte[8];
		byte[] b5 = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		r.nextBytes(b5);
		createDATAcontainer.setToken(b5);
		createDATAcontainer.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) // FROM OPTION
		.addOption(new Option(267, "3"))  		  // RESOURCE TYPE OPTION
		.addOption(new Option(268, "DATA"));  // NAME OPTION
		createDATAcontainer.setPayload(createDATAcontainerBody);
		
		
		//Create a data contentInstance
		String createDATAcontentInstanceBody = 
				"<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">" + 
				    "<cnf>message</cnf>" +
				    "<con>" +
				      "&lt;obj&gt;" +
				        "&lt;str name=&quot;appId&quot; val=&quot;MY_SENSOR&quot;/&gt;" +
				        "&lt;str name=&quot;category&quot; val=&quot;temperature &quot;/&gt;" +
				        "&lt;int name=&quot;data&quot; val=&quot;27&quot;/&gt;" +
				        "&lt;int name=&quot;unit&quot; val=&quot;celsius&quot;/&gt;" +
				      "&lt;/obj&gt;" +
				    "</con>" +
				"</om2m:cin>";

		Request createDATAcontentInstance = new Request(Code.POST);
		//byte[] b6 = new byte[8];
		byte[] b6 = new byte[] {  (byte)0xff,  (byte)0xff,  (byte)0xff, (byte)0xff, (byte)0xff,  (byte)0xff,  (byte)0xff,  (byte)0xff};
		r.nextBytes(b6);
		createDATAcontentInstance.setToken(b6); 
		createDATAcontentInstance.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) 	// FROM OPTION
		.addOption(new Option(267, "4"));  		  	// RESOURCE TYPE OPTION
		createDATAcontentInstance.setPayload(createDATAcontentInstanceBody);
		
		// Subscribe to MY_SENSOR data -- MORES IMET IMPLEMENTIRAN COAP CLIENTA!!!!
		String subscribeBody = 
				"<m2m:sub xmlns:m2m=\"http://www.onem2m.org/xml/protocols\">"+
				    "<nu>coap://127.0.0.1:5684/monitor</nu>" + 
				    "<nct>2</nct>" + 
				"</m2m:sub>";

		Request subscribe = new Request(Code.POST);
		byte[] b7 = new byte[8];
		r.nextBytes(b7);
		subscribe.setToken(b7); 
		subscribe.getOptions()
		.setContentFormat(MediaTypeRegistry.APPLICATION_XML)
		.setAccept(MediaTypeRegistry.APPLICATION_XML)
		.addOption(new Option(256, "admin:admin")) 		// FROM OPTION
		.addOption(new Option(267, "23"))  		  	// RESOURCE TYPE OPTION
		.addOption(new Option(268, "COAP_SUB"));  // NAME OPTION
		subscribe.setPayload(subscribeBody);
		
		// Retrieve a resource
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse"));
		//c.advanced(retrieveSrc);
		
		// Create a "MY_SENSOR" application
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse"));
		//c.advanced(createApplication);
		
		// Discover resources based on their search strings
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse?fu=1&lbl=Type/sensor"));
		//c.advanced(discoverRSrc);
		
		// Create a DESCRIPTOR container
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR"));
		//c.advanced(createDESCRIPTOR);
				
		// Create a description contentInstance
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DESCRIPTOR"));
		//c.advanced(createDESCRIPTORcontentInstance);
		
		// Create a DATA container
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR"));
		//c.advanced(createDATAcontainer);
		
		//Create a data contentInstance
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA"));
		//c.advanced(createDATAcontentInstance);
		
		// Subscribe to MY_SENSOR data -- MORES IMET IMPLEMENTIRAN COAP CLIENTA!!!!
		//CoapClient c = new CoapClient(new URI("coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA"));
		//c.advanced(subscribe);
		
		for(int i=0;i<10;i++){ 
			String tempName = "MONITOR_"+ i;
			performOperation(returnCreateAEString(tempName), "coap://127.0.0.1:5683/~/in-cse");
			performOperation(returnCreateDESCRIPTORContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/" + tempName);
			performOperation(returnCreateDESCRIPTORInstanceString(),"coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName+"/DESCRIPTOR");
			performOperation(returnCreateDATAContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/"+tempName);
		}
		/*
		performOperation(createApplication, "coap://127.0.0.1:5683/~/in-cse");
		Thread.sleep(20000);
		
		performOperation(createDESCRIPTOR, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR");
		Thread.sleep(20000);
		
		performOperation(createDESCRIPTORcontentInstance,"coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DESCRIPTOR");
		Thread.sleep(20000);
		
		performOperation(createDATAcontainer, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR");
		Thread.sleep(20000);
		*/
		//performOperation(createDATAcontentInstance, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA");
		//performOperation(createDATAcontentInstance, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA");
		//Thread.sleep(20000);
		
		// Before executing this line, maker sure the monitor application (listens for notifications) is started, 
		// otherwise exceptions will be thrown!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		//performOperation(subscribe, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA");
		/*
		while(true){
			Thread.sleep(3000);
			System.out.println("Sending a measurement!");
			performOperation(createDATAcontentInstance, "coap://127.0.0.1:5683/~/in-cse/in-name/MY_SENSOR/DATA");
			Thread.sleep(3000);
		}*/
	}
	
	public static void performOperation(Request r, String operationUri) throws URISyntaxException{
		CoapClient c = new CoapClient(new URI(operationUri));
		CoapResponse cr = c.advanced(r);
	}

}
