/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;

public class GETClient {
    public static CoapClient client;
    public static Random r;

    static {
        r = new Random();
    }

    public static Request returnCreateAEString(String name) {
        String createApplicationBody = "<om2m:ae xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"><api>app-sensor</api><lbl>Type/sensor Category/temperature Location/home</lbl><rr>false</rr></om2m:ae>";
        Request createApplication = new Request(CoAP.Code.POST);
        byte[] b1 = new byte[8];
        new Random().nextBytes(b1);
        createApplication.setToken(b1);
        createApplication.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "2")).addOption(new Option(268, name));
        createApplication.setPayload(createApplicationBody);
        return createApplication;
    }

    public static Request returnCreateDESCRIPTORContainerString() {
        String createDESCRIPTORBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"></om2m:cnt>";
        Request createDESCRIPTOR = new Request(CoAP.Code.POST);
        byte[] b3 = new byte[8];
        new Random().nextBytes(b3);
        createDESCRIPTOR.setToken(b3);
        createDESCRIPTOR.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "3")).addOption(new Option(268, "DESCRIPTOR"));
        createDESCRIPTOR.setPayload(createDESCRIPTORBody);
        return createDESCRIPTOR;
    }

    public static Request returnCreateDESCRIPTORInstanceString() {
        String createDESCRIPTORcontentInstanceBody = "<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\">\n<cnf>message</cnf>\n<con>\n&lt;obj&gt;\n&lt;str name=&quot;type&quot; val=&quot;Temperature_Sensor&quot;/&gt;\n&lt;str name=&quot;location&quot; val=&quot;Home&quot;/&gt;\n&lt;str name=&quot;appId&quot; val=&quot;MY_SENSOR&quot;/&gt;\n&lt;op name=&quot;getValue&quot; href=&quot;/in-cse/MY_SENSOR/DATA/la&quot;\nin=&quot;obix:Nil&quot; out=&quot;obix:Nil&quot; is=&quot;retrieve&quot;/&gt;\n&lt;/obj&gt;\n</con>\n</om2m:cin>";
        Request createDESCRIPTORcontentInstance = new Request(CoAP.Code.POST);
        byte[] b4 = new byte[8];
        new Random().nextBytes(b4);
        createDESCRIPTORcontentInstance.setToken(b4);
        createDESCRIPTORcontentInstance.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "4"));
        createDESCRIPTORcontentInstance.setPayload(createDESCRIPTORcontentInstanceBody);
        return createDESCRIPTORcontentInstance;
    }

    public static Request returnCreateDATAContainerString() {
        String createDATAcontainerBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"></om2m:cnt>";
        Request createDATAcontainer = new Request(CoAP.Code.POST);
        byte[] b5 = new byte[8];
        new Random().nextBytes(b5);
        createDATAcontainer.setToken(b5);
        createDATAcontainer.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "3")).addOption(new Option(268, "DATA"));
        createDATAcontainer.setPayload(createDATAcontainerBody);
        return createDATAcontainer;
    }

    public static void main(String[] args) throws URISyntaxException, InterruptedException {
        Request retrieveSrc = new Request(CoAP.Code.GET);
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b);
        retrieveSrc.setToken(b);
        retrieveSrc.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin"));
        String createApplicationBody = "<om2m:ae xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"><api>app-sensor</api><lbl>Type/sensor Category/temperature Location/home</lbl><rr>false</rr></om2m:ae>";
        Request createApplication = new Request(CoAP.Code.POST);
        byte[] b1 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b1);
        createApplication.setToken(b1);
        createApplication.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "2")).addOption(new Option(268, "MY_SENSOR"));
        createApplication.setPayload(createApplicationBody);
        Request discoverRSrc = new Request(CoAP.Code.GET);
        byte[] b2 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b2);
        discoverRSrc.setToken(b2);
        discoverRSrc.getOptions().addOption(new Option(256, "admin:admin"));
        String createDESCRIPTORBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"></om2m:cnt>";
        Request createDESCRIPTOR = new Request(CoAP.Code.POST);
        byte[] b3 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b3);
        createDESCRIPTOR.setToken(b3);
        createDESCRIPTOR.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "3")).addOption(new Option(268, "DESCRIPTOR"));
        createDESCRIPTOR.setPayload(createDESCRIPTORBody);
        String createDATAcontainerBody = "<om2m:cnt xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"></om2m:cnt>";
        Request createDATAcontainer = new Request(CoAP.Code.POST);
        byte[] b5 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b5);
        createDATAcontainer.setToken(b5);
        createDATAcontainer.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "3")).addOption(new Option(268, "DATA"));
        createDATAcontainer.setPayload(createDATAcontainerBody);
        String createDATAcontentInstanceBody = "<om2m:cin xmlns:om2m=\"http://www.onem2m.org/xml/protocols\"><cnf>message</cnf><con>&lt;obj&gt;&lt;str name=&quot;appId&quot; val=&quot;MY_SENSOR&quot;/&gt;&lt;str name=&quot;category&quot; val=&quot;temperature &quot;/&gt;&lt;int name=&quot;data&quot; val=&quot;27&quot;/&gt;&lt;int name=&quot;unit&quot; val=&quot;celsius&quot;/&gt;&lt;/obj&gt;</con></om2m:cin>";
        Request createDATAcontentInstance = new Request(CoAP.Code.POST);
        byte[] b6 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        r.nextBytes(b6);
        createDATAcontentInstance.setToken(b6);
        createDATAcontentInstance.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "4"));
        createDATAcontentInstance.setPayload(createDATAcontentInstanceBody);
        String subscribeBody = "<m2m:sub xmlns:m2m=\"http://www.onem2m.org/xml/protocols\"><nu>coap://127.0.0.1:5684/monitor</nu><nct>2</nct></m2m:sub>";
        Request subscribe = new Request(CoAP.Code.POST);
        byte[] b7 = new byte[8];
        r.nextBytes(b7);
        subscribe.setToken(b7);
        subscribe.getOptions().setContentFormat(41).setAccept(41).addOption(new Option(256, "admin:admin")).addOption(new Option(267, "23")).addOption(new Option(268, "COAP_SUB"));
        subscribe.setPayload(subscribeBody);
        int i = 0;
        while (i < 10) {
            String tempName = "MONITOR_" + i;
            GETClient.performOperation(GETClient.returnCreateAEString(tempName), "coap://127.0.0.1:5683/~/in-cse");
            GETClient.performOperation(GETClient.returnCreateDESCRIPTORContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/" + tempName);
            GETClient.performOperation(GETClient.returnCreateDESCRIPTORInstanceString(), "coap://127.0.0.1:5683/~/in-cse/in-name/" + tempName + "/DESCRIPTOR");
            GETClient.performOperation(GETClient.returnCreateDATAContainerString(), "coap://127.0.0.1:5683/~/in-cse/in-name/" + tempName);
            ++i;
        }
    }

    public static void performOperation(Request r, String operationUri) throws URISyntaxException {
        CoapClient c = new CoapClient(new URI(operationUri));
        CoapResponse cr = c.advanced(r);
    }
}

