/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;

public class UDPConnector
implements Connector {
    public static final Logger LOGGER = Logger.getLogger(UDPConnector.class.getName());
    public static final int UNDEFINED = 0;
    private boolean running;
    private DatagramSocket socket;
    private final InetSocketAddress localAddr;
    private List<Thread> receiverThreads;
    private List<Thread> senderThreads;
    private final BlockingQueue<RawData> outgoing;
    private RawDataChannel receiver;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private int senderCount = 1;
    private int receiverCount = 1;
    private int receiverPacketSize = 2048;
    private boolean logPackets = false;

    public UDPConnector() {
        this(null);
    }

    public UDPConnector(InetSocketAddress address) {
        this.localAddr = address == null ? new InetSocketAddress(0) : address;
        this.running = false;
        this.outgoing = new LinkedBlockingQueue<RawData>();
    }

    @Override
    public synchronized void start() throws IOException {
        int i;
        if (this.running) {
            return;
        }
        this.socket = new DatagramSocket(this.localAddr.getPort(), this.localAddr.getAddress());
        this.running = true;
        if (this.receiveBufferSize != 0) {
            this.socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        this.receiveBufferSize = this.socket.getReceiveBufferSize();
        if (this.sendBufferSize != 0) {
            this.socket.setSendBufferSize(this.sendBufferSize);
        }
        this.sendBufferSize = this.socket.getSendBufferSize();
        LOGGER.log(Level.CONFIG, "UDPConnector starts up {0} sender threads and {1} receiver threads", new Object[]{this.senderCount, this.receiverCount});
        this.receiverThreads = new LinkedList<Thread>();
        for (i = 0; i < this.receiverCount; ++i) {
            this.receiverThreads.add(new Receiver("UDP-Receiver-" + this.localAddr + "[" + i + "]"));
        }
        this.senderThreads = new LinkedList<Thread>();
        for (i = 0; i < this.senderCount; ++i) {
            this.senderThreads.add(new Sender("UDP-Sender-" + this.localAddr + "[" + i + "]"));
        }
        for (Thread t : this.receiverThreads) {
            t.start();
        }
        for (Thread t : this.senderThreads) {
            t.start();
        }
        String startupMsg = new StringBuffer("UDPConnector listening on ").append(this.socket.getLocalSocketAddress()).append(", recv buf = ").append(this.receiveBufferSize).append(", send buf = ").append(this.sendBufferSize).append(", recv packet size = ").append(this.receiverPacketSize).toString();
        LOGGER.log(Level.CONFIG, startupMsg);
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.senderThreads != null) {
            for (Thread t : this.senderThreads) {
                t.interrupt();
            }
        }
        if (this.receiverThreads != null) {
            for (Thread t : this.receiverThreads) {
                t.interrupt();
            }
        }
        this.outgoing.clear();
        String address = this.socket.getLocalSocketAddress().toString();
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        LOGGER.log(Level.CONFIG, "UDPConnector on [{0}] has stopped.", address);
    }

    @Override
    public synchronized void destroy() {
        this.stop();
    }

    @Override
    public void send(RawData msg) {
        if (msg == null) {
            throw new NullPointerException("Message must not be null");
        }
        this.outgoing.add(msg);
    }

    @Override
    public void setRawDataReceiver(RawDataChannel receiver) {
        this.receiver = receiver;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.socket == null) {
            return this.localAddr;
        }
        return new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setReceiverThreadCount(int count) {
        this.receiverCount = count;
    }

    public int getReceiverThreadCount() {
        return this.receiverCount;
    }

    public void setSenderThreadCount(int count) {
        this.senderCount = count;
    }

    public int getSenderThreadCount() {
        return this.senderCount;
    }

    public void setReceiverPacketSize(int size) {
        this.receiverPacketSize = size;
    }

    public int getReceiverPacketSize() {
        return this.receiverPacketSize;
    }

    private class Sender
    extends NetworkStageThread {
        private DatagramPacket datagram;

        private Sender(String name) {
            super(name);
            this.datagram = new DatagramPacket(new byte[0], 0);
        }

        @Override
        protected void work() throws InterruptedException, IOException {
            RawData raw = (RawData)UDPConnector.this.outgoing.take();
            this.datagram.setData(raw.getBytes());
            this.datagram.setAddress(raw.getAddress());
            this.datagram.setPort(raw.getPort());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "UDPConnector ({0}) sends {1} bytes to {2}:{3}", new Object[]{UDPConnector.this.socket.getLocalSocketAddress(), this.datagram.getLength(), this.datagram.getAddress(), this.datagram.getPort()});
            }
            UDPConnector.this.socket.send(this.datagram);
        }
    }

    private class Receiver
    extends NetworkStageThread {
        private DatagramPacket datagram;
        private int size;

        private Receiver(String name) {
            super(name);
            this.size = UDPConnector.this.receiverPacketSize;
            this.datagram = new DatagramPacket(new byte[this.size], this.size);
        }

        @Override
        protected void work() throws IOException {
            this.datagram.setLength(this.size);
            UDPConnector.this.socket.receive(this.datagram);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "UDPConnector ({0}) received {1} bytes from {2}:{3}", new Object[]{UDPConnector.this.socket.getLocalSocketAddress(), this.datagram.getLength(), this.datagram.getAddress(), this.datagram.getPort()});
            }
            byte[] bytes = Arrays.copyOfRange(this.datagram.getData(), this.datagram.getOffset(), this.datagram.getLength());
            RawData msg = new RawData(bytes, this.datagram.getAddress(), this.datagram.getPort());
            UDPConnector.this.receiver.receiveData(msg);
        }
    }

    private abstract class NetworkStageThread
    extends Thread {
        private NetworkStageThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LOGGER.log(Level.FINE, "Starting network stage thread [{0}]", this.getName());
            while (UDPConnector.this.running) {
                try {
                    this.work();
                }
                catch (Throwable t) {
                    if (UDPConnector.this.running) {
                        LOGGER.log(Level.SEVERE, "Exception in network stage thread [" + this.getName() + "]:", t);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Network stage thread [{0}] was stopped successfully", this.getName());
                }
            }
        }

        protected abstract void work() throws Exception;
    }
}

