/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.MessageDeliverer;

public class EndpointManager {
    private static final Logger LOGGER = Logger.getLogger(EndpointManager.class.getCanonicalName());
    private static EndpointManager manager = new EndpointManager();
    private Endpoint default_endpoint;
    private Endpoint default_secure_endpoint;

    public static EndpointManager getEndpointManager() {
        return manager;
    }

    public Endpoint getDefaultEndpoint() {
        if (this.default_endpoint == null) {
            this.createDefaultEndpoint();
        }
        return this.default_endpoint;
    }

    private synchronized void createDefaultEndpoint() {
        if (this.default_endpoint != null) {
            return;
        }
        this.default_endpoint = new CoapEndpoint();
        try {
            this.default_endpoint.start();
            LOGGER.log(Level.INFO, "Created implicit default endpoint {0}", this.default_endpoint.getAddress());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not create default endpoint", e);
        }
    }

    public void setDefaultEndpoint(Endpoint endpoint) {
        if (this.default_endpoint != null) {
            this.default_endpoint.destroy();
        }
        LOGGER.log(Level.CONFIG, "{0} becomes default endpoint", endpoint.getAddress());
        this.default_endpoint = endpoint;
        if (!this.default_endpoint.isStarted()) {
            try {
                this.default_endpoint.start();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not start new default endpoint", e);
            }
        }
    }

    public Endpoint getDefaultSecureEndpoint() {
        try {
            if (this.default_secure_endpoint == null) {
                this.createDefaultSecureEndpoint();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while getting the default secure endpoint", e);
        }
        return this.default_secure_endpoint;
    }

    private synchronized void createDefaultSecureEndpoint() {
        if (this.default_secure_endpoint != null) {
            return;
        }
        LOGGER.config("Secure endpoint must be injected via setDefaultSecureEndpoint()");
    }

    public void setDefaultSecureEndpoint(Endpoint endpoint) {
        if (this.default_secure_endpoint != null) {
            this.default_secure_endpoint.destroy();
        }
        this.default_secure_endpoint = endpoint;
        if (!this.default_secure_endpoint.isStarted()) {
            try {
                this.default_secure_endpoint.start();
                LOGGER.log(Level.INFO, "Started new default secure endpoint {0}", this.default_secure_endpoint.getAddress());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not start new default secure endpoint", e);
            }
        }
    }

    public Collection<InetAddress> getNetworkInterfaces() {
        LinkedList<InetAddress> interfaces = new LinkedList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                Enumeration<InetAddress> inetAddresses = nets.nextElement().getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    interfaces.add(inetAddresses.nextElement());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.log(Level.SEVERE, "Could not fetch all interface addresses", e);
        }
        return interfaces;
    }

    public static void clear() {
        EndpointManager it = EndpointManager.getEndpointManager();
        if (it.default_endpoint != null) {
            it.default_endpoint.clear();
        }
        if (it.default_secure_endpoint != null) {
            it.default_secure_endpoint.clear();
        }
    }

    public static class ClientMessageDeliverer
    implements MessageDeliverer {
        @Override
        public void deliverRequest(Exchange exchange) {
            LOGGER.severe("Default endpoint without CoapServer has received a request.");
            exchange.sendReject();
        }

        @Override
        public void deliverResponse(Exchange exchange, Response response) {
            if (exchange == null) {
                throw new NullPointerException();
            }
            if (exchange.getRequest() == null) {
                throw new NullPointerException();
            }
            if (response == null) {
                throw new NullPointerException();
            }
            exchange.getRequest().setResponse(response);
        }
    }
}

