/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class CoapClient {
    private static final Logger LOGGER = Logger.getLogger(CoapClient.class.getCanonicalName());
    private long timeout = NetworkConfig.getStandard().getLong("ACK_TIMEOUT");
    private String uri;
    private CoAP.Type type = CoAP.Type.CON;
    private int blockwise = 0;
    private ExecutorService executor;
    private Endpoint endpoint;

    public CoapClient() {
        this("");
    }

    public CoapClient(String uri) {
        this.uri = uri;
    }

    public CoapClient(URI uri) {
        this(uri.toString());
    }

    public CoapClient(String scheme, String host, int port, String ... path) {
        StringBuilder builder = new StringBuilder().append(scheme).append("://").append(host).append(":").append(port);
        for (String element : path) {
            builder.append("/").append(element);
        }
        this.uri = builder.toString();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CoapClient setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public CoapClient setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public CoapClient useExecutor() {
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LOGGER.config("Using a SingleThreadExecutor for the CoapClient");
            }
        });
        return this;
    }

    public CoapClient setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public CoapClient setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        if (!endpoint.isStarted()) {
            try {
                endpoint.start();
                LOGGER.log(Level.INFO, "Started set client endpoint {0}", endpoint.getAddress());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not set and start client endpoint", e);
            }
        }
        return this;
    }

    public CoapClient useCONs() {
        this.type = CoAP.Type.CON;
        return this;
    }

    public CoapClient useNONs() {
        this.type = CoAP.Type.NON;
        return this;
    }

    public CoapClient useEarlyNegotiation(int size) {
        this.blockwise = size;
        return this;
    }

    public CoapClient useLateNegotiation() {
        this.blockwise = 0;
        return this;
    }

    public boolean ping() {
        return this.ping(this.timeout);
    }

    public boolean ping(long timeout) {
        try {
            Request request = new Request(null, CoAP.Type.CON);
            request.setToken(new byte[0]);
            request.setURI(this.uri);
            request.send().waitForResponse(timeout);
            return request.isRejected();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public Set<WebLink> discover() {
        return this.discover(null);
    }

    public Set<WebLink> discover(String query) {
        CoapResponse links;
        Request discover = Request.newGet();
        discover.setURI(this.uri);
        discover.getOptions().clearUriPath().clearUriQuery().setUriPath("/.well-known/core");
        if (query != null) {
            discover.getOptions().setUriQuery(query);
        }
        if ((links = this.synchronous(discover)) == null) {
            return null;
        }
        if (links.getOptions().getContentFormat() != 40) {
            return Collections.emptySet();
        }
        return LinkFormat.parse(links.getResponseText());
    }

    public CoapResponse get() {
        return this.synchronous(Request.newGet().setURI(this.uri));
    }

    public CoapResponse get(int accept) {
        return this.synchronous(this.accept(Request.newGet().setURI(this.uri), accept));
    }

    public void get(CoapHandler handler) {
        this.asynchronous(Request.newGet().setURI(this.uri), handler);
    }

    public void get(CoapHandler handler, int accept) {
        this.asynchronous(this.accept(Request.newGet().setURI(this.uri), accept), handler);
    }

    public CoapResponse post(String payload, int format) {
        return this.synchronous(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format));
    }

    public CoapResponse post(byte[] payload, int format) {
        return this.synchronous(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format));
    }

    public CoapResponse post(String payload, int format, int accept) {
        return this.synchronous(this.accept(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), accept));
    }

    public CoapResponse post(byte[] payload, int format, int accept) {
        return this.synchronous(this.accept(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), accept));
    }

    public void post(CoapHandler handler, String payload, int format) {
        this.asynchronous(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), handler);
    }

    public void post(CoapHandler handler, byte[] payload, int format) {
        this.asynchronous(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), handler);
    }

    public void post(CoapHandler handler, String payload, int format, int accept) {
        this.asynchronous(this.accept(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), accept), handler);
    }

    public void post(CoapHandler handler, byte[] payload, int format, int accept) {
        this.asynchronous(this.accept(this.format(Request.newPost().setURI(this.uri).setPayload(payload), format), accept), handler);
    }

    public CoapResponse put(String payload, int format) {
        return this.synchronous(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format));
    }

    public CoapResponse put(byte[] payload, int format) {
        return this.synchronous(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format));
    }

    public CoapResponse putIfMatch(String payload, int format, byte[] ... etags) {
        return this.synchronous(this.ifMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), etags));
    }

    public CoapResponse putIfMatch(byte[] payload, int format, byte[] ... etags) {
        return this.synchronous(this.ifMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), etags));
    }

    public CoapResponse putIfNoneMatch(String payload, int format) {
        return this.synchronous(this.ifNoneMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format)));
    }

    public CoapResponse putIfNoneMatch(byte[] payload, int format) {
        return this.synchronous(this.ifNoneMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format)));
    }

    public void put(CoapHandler handler, String payload, int format) {
        this.asynchronous(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), handler);
    }

    public void put(CoapHandler handler, byte[] payload, int format) {
        this.asynchronous(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), handler);
    }

    public void putIfMatch(CoapHandler handler, String payload, int format, byte[] ... etags) {
        this.asynchronous(this.ifMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), etags), handler);
    }

    public void putIfMatch(CoapHandler handler, byte[] payload, int format, byte[] ... etags) {
        this.asynchronous(this.ifMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format), etags), handler);
    }

    public void putIfNoneMatch(CoapHandler handler, byte[] payload, int format) {
        this.asynchronous(this.ifNoneMatch(this.format(Request.newPut().setURI(this.uri).setPayload(payload), format)), handler);
    }

    public CoapResponse delete() {
        return this.synchronous(Request.newDelete().setURI(this.uri));
    }

    public void delete(CoapHandler handler) {
        this.asynchronous(Request.newDelete().setURI(this.uri), handler);
    }

    public CoapResponse validate(byte[] ... etags) {
        return this.synchronous(this.etags(Request.newGet().setURI(this.uri), etags));
    }

    public void validate(CoapHandler handler, byte[] ... etags) {
        this.asynchronous(this.etags(Request.newGet().setURI(this.uri), etags), handler);
    }

    public CoapResponse advanced(Request request) {
        request.setURI(this.uri);
        return this.synchronous(request);
    }

    public void advanced(CoapHandler handler, Request request) {
        request.setURI(this.uri);
        this.asynchronous(request, handler);
    }

    public CoapObserveRelation observeAndWait(CoapHandler handler) {
        Request request = Request.newGet().setURI(this.uri).setObserve();
        return this.observeAndWait(request, handler);
    }

    public CoapObserveRelation observeAndWait(CoapHandler handler, int accept) {
        Request request = Request.newGet().setURI(this.uri).setObserve();
        request.getOptions().setAccept(accept);
        return this.observeAndWait(request, handler);
    }

    public CoapObserveRelation observe(CoapHandler handler) {
        Request request = Request.newGet().setURI(this.uri).setObserve();
        return this.observe(request, handler);
    }

    public CoapObserveRelation observe(CoapHandler handler, int accept) {
        Request request = Request.newGet().setURI(this.uri).setObserve();
        return this.observe(this.accept(request, accept), handler);
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private void asynchronous(Request request, CoapHandler handler) {
        request.addMessageObserver(new MessageObserverImpl(handler));
        this.send(request);
    }

    private CoapResponse synchronous(Request request) {
        return this.synchronous(request, this.getEffectiveEndpoint(request));
    }

    private CoapResponse synchronous(Request request, Endpoint outEndpoint) {
        try {
            Response response = this.send(request, outEndpoint).waitForResponse(this.getTimeout());
            if (response == null) {
                return null;
            }
            return new CoapResponse(response);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Request format(Request request, int contentFormat) {
        request.getOptions().setContentFormat(contentFormat);
        return request;
    }

    private Request accept(Request request, int accept) {
        request.getOptions().setAccept(accept);
        return request;
    }

    private Request etags(Request request, byte[] ... etags) {
        for (byte[] etag : etags) {
            request.getOptions().addETag(etag);
        }
        return request;
    }

    private Request ifMatch(Request request, byte[] ... etags) {
        for (byte[] etag : etags) {
            request.getOptions().addIfMatch(etag);
        }
        return request;
    }

    private Request ifNoneMatch(Request request) {
        request.getOptions().setIfNoneMatch(true);
        return request;
    }

    private CoapObserveRelation observeAndWait(Request request, CoapHandler handler) {
        Endpoint outEndpoint = this.getEffectiveEndpoint(request);
        CoapObserveRelation relation = new CoapObserveRelation(request, outEndpoint);
        request.addMessageObserver(new ObserveMessageObserverImpl(handler, relation));
        CoapResponse response = this.synchronous(request, outEndpoint);
        if (response == null || !response.advanced().getOptions().hasObserve()) {
            relation.setCanceled(true);
        }
        relation.setCurrent(response);
        return relation;
    }

    private CoapObserveRelation observe(Request request, CoapHandler handler) {
        Endpoint outEndpoint = this.getEffectiveEndpoint(request);
        CoapObserveRelation relation = new CoapObserveRelation(request, outEndpoint);
        request.addMessageObserver(new ObserveMessageObserverImpl(handler, relation));
        this.send(request, outEndpoint);
        return relation;
    }

    protected Request send(Request request) {
        return this.send(request, this.getEffectiveEndpoint(request));
    }

    protected Request send(Request request, Endpoint outEndpoint) {
        request.setType(this.type);
        if (this.blockwise != 0) {
            request.getOptions().setBlock2(new BlockOption(BlockOption.size2Szx(this.blockwise), false, 0));
        }
        outEndpoint.sendRequest(request);
        return request;
    }

    protected Endpoint getEffectiveEndpoint(Request request) {
        Endpoint myEndpoint = this.getEndpoint();
        if (myEndpoint != null) {
            return myEndpoint;
        }
        if ("coaps".equals(request.getScheme())) {
            return EndpointManager.getEndpointManager().getDefaultSecureEndpoint();
        }
        return EndpointManager.getEndpointManager().getDefaultEndpoint();
    }

    public static class Builder {
        String scheme;
        String host;
        String port;
        String[] path;
        String[] query;

        public Builder(String host, int port) {
            this.host = host;
            this.port = Integer.toString(port);
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder port(int port) {
            this.port = Integer.toString(port);
            return this;
        }

        public Builder path(String ... path) {
            this.path = path;
            return this;
        }

        public Builder query(String ... query) {
            this.query = query;
            return this;
        }

        public CoapClient create() {
            StringBuilder builder = new StringBuilder();
            if (this.scheme != null) {
                builder.append(this.scheme).append("://");
            }
            builder.append(this.host).append(":").append(this.port);
            for (String element : this.path) {
                builder.append("/").append(element);
            }
            if (this.query.length > 0) {
                builder.append("?");
            }
            for (int i = 0; i < this.query.length; ++i) {
                builder.append(this.query[i]);
                if (i >= this.query.length - 1) continue;
                builder.append("&");
            }
            return new CoapClient(builder.toString());
        }
    }

    private class ObserveMessageObserverImpl
    extends MessageObserverImpl {
        private final CoapObserveRelation relation;

        public ObserveMessageObserverImpl(CoapHandler handler, CoapObserveRelation relation) {
            super(handler);
            this.relation = relation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void deliver(CoapResponse response) {
            CoapObserveRelation coapObserveRelation = this.relation;
            synchronized (coapObserveRelation) {
                if (!this.relation.getOrderer().isNew(response.advanced())) {
                    LOGGER.log(Level.FINER, "Dropping old notification: {0}", response.advanced());
                    return;
                }
                this.relation.setCurrent(response);
                this.relation.prepareReregistration(response, 2000L);
                this.handler.onLoad(response);
            }
        }

        @Override
        protected void failed() {
            this.relation.setCanceled(true);
            super.failed();
        }
    }

    private class MessageObserverImpl
    extends MessageObserverAdapter {
        protected CoapHandler handler;

        private MessageObserverImpl(CoapHandler handler) {
            this.handler = handler;
        }

        @Override
        public void onResponse(Response response) {
            this.succeeded(response != null ? new CoapResponse(response) : null);
        }

        @Override
        public void onReject() {
            this.failed();
        }

        @Override
        public void onTimeout() {
            this.failed();
        }

        protected void succeeded(final CoapResponse response) {
            if (CoapClient.this.executor == null) {
                this.deliver(response);
            } else {
                CoapClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageObserverImpl.this.deliver(response);
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, "Exception while handling response", t);
                        }
                    }
                });
            }
        }

        protected void deliver(CoapResponse response) {
            this.handler.onLoad(response);
        }

        protected void failed() {
            if (CoapClient.this.executor == null) {
                this.handler.onError();
            } else {
                CoapClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageObserverImpl.this.handler.onError();
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, "Exception while handling failure", t);
                        }
                    }
                });
            }
        }
    }
}

