package snippet.ise.handler;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Constants;

public class InstallBundleHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		InputStream stream = null;
		try{
			stream=Platform.getBundle("snippet.ise").getEntry("/bundle/snippet.ise.hello_1.0.0.201106091559.jar").openStream() ;
		
			Platform.getBundle(Constants.SYSTEM_BUNDLE_SYMBOLICNAME).getBundleContext().installBundle("inputStream:/bundle/snippet.ise.hello_1.0.0.201106091559.jar", stream).start();
			
			return null;
		} catch(Exception e){
			throw new ExecutionException(e.toString());
		} finally{
			if(stream!=null){
				try {
					stream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}

}
