/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: TimeCollector.h,v 1.6 2005/06/30 19:44:42 akaylor Exp $
 *
 *******************************************************************************/ 

#ifndef  TimeCollector_H
#define  TimeCollector_H


#include "tptp/agents/BaseCollectorImpl.h"
#include <iostream>

using namespace std;

class TimeCollector : public BaseCollectorImpl
{

	private:
		long startTime;
		long endTime;
		bool running;
		int  clientID;

		struct tm* getSystemTime(time_t* systemTime);
		

	public:

		TimeCollector(char* agentName);
		~TimeCollector();

		int run(CmdBlock* cmdBlock);
		int stop(CmdBlock* cmdBlock);
		int sendRunResponse(CmdBlock* cmdBlock);
		int sendStopResponse(CmdBlock* cmdBlock);
		char* getCurrentTime();
		bool isRunning();
		int sendCurrentTime();

		virtual int processCommand(CmdBlock* cmdBlock);

		int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader);

};

#endif

