/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: TimeCollector.cpp,v 1.8 2005/08/15 22:45:34 vnaikawadi Exp $
 *
 *******************************************************************************/ 


#include "TimeCollector.h"
#include <time.h>




TimeCollector::TimeCollector(char* name) : BaseCollectorImpl(name), BaseAgentImpl(name)
{	
	running = false;
}


TimeCollector::~TimeCollector()
{

}

bool TimeCollector::isRunning()
{
	if (running)
	{
		return true;
	}

	return false;
}


char* TimeCollector::getCurrentTime()
{
	time_t currTime;
	struct tm* time = getSystemTime(&currTime);

	char* currentTime = asctime(time);

	cout<<"Current time is - "<<currentTime<<endl;

	return currentTime;
}




int TimeCollector::run(CmdBlock* cmdBlock)
{

	cout<<"TimeCollector::run() called"<<endl;
	time_t start;

	startTime = time(&start);   // Get time in seconds
	struct tm* currTime = localtime(&start);

	/* This needs to be revisited.  We should have an API that allows
	   us to know who wants to receive our data.  For now, we're assuming
	   that it is whoever sent us the run command. */
	clientID = cmdBlock->getSourceID();

	running = true;

	sendRunResponse(cmdBlock);

	return 0;
}

int TimeCollector::sendRunResponse(CmdBlock* cmdBlock)
{
	int ret = -1;

	int destID = cmdBlock->getDestID();
	int sourceID = cmdBlock->getSourceID();
	int contextID = cmdBlock->getContextID();

	char   commandFormat[] = "<Cmd src=\"%ld\" dest=\"%ld\" ctxt=\"%ld\"> <agentRunning iid=\"org.eclipse.tptp.Collector\"></agentRunning></Cmd>";
	char   command[1024];
	sprintf( command, commandFormat, destID, sourceID, contextID);

	ret = BaseAgentImpl::sendCommand(command);

	return ret;
}

int TimeCollector::stop(CmdBlock* cmdBlock)
{
	cout<<"TimeCollector::stop() called"<<endl;
	time_t end;

	endTime = time(&end);   // Get time in seconds
	struct tm* currTime = localtime(&end);

	cout<<"End Time is - "<<asctime(currTime)<<endl;

	cout<<"Start Time in seconds -"<<startTime<<endl;
	cout<<"End Time in seconds-"<<endTime<<endl;

	/* This will stop the run thread */
	running = false;

	this->sendStopResponse(cmdBlock);

	return 0;
}

int TimeCollector::sendStopResponse(CmdBlock* cmdBlock)
{
	int ret = -1;

	int destID = cmdBlock->getDestID();
	int sourceID = cmdBlock->getSourceID();
	int contextID = cmdBlock->getContextID();

	char   commandFormat[] = "<Cmd src=\"%ld\" dest=\"%ld\" ctxt=\"%ld\"> <agentStopped iid=\"org.eclipse.tptp.Collector\"></agentStopped></Cmd>";
	char   command[1024];
	sprintf( command, commandFormat, destID, sourceID, contextID );

	cout<<"Sending STOP response"<<endl;

	ret = BaseAgentImpl::sendCommand(command);

	return ret;
}




int TimeCollector::sendCurrentTime()
{
	int ret = -1;

	CmdBlock* cmd = new CmdBlock();

	//Initialize paramList for key value pairs
	tptp_list_t* paramList = (tptp_list_t*)tptp_malloc( sizeof(tptp_list_t));
	tptp_list_init(paramList);
	tptp_list_setNodeDestructor(paramList, destroyParamNode);
	tptp_list_setNodeCopier(paramList, copyParamNode);
	tptp_param_t* newParam;

	newParam = initParamT("time", getCurrentTime());
	tptp_list_add(paramList, (void*)newParam);
									
	cmd->setIID("org.eclipse.tptp.TimeCollectorEvents");					
	cmd->setCommandName("currentTime");					
	cmd->setParamList(paramList);

	cout<<"Sending currentTime command"<<endl;
	
	// Send the Event Notification to all the listener objects registered to listen for this event interface
	sendEventNotifications(cmd);

	return ret;
}


int TimeCollector::processCommand(CmdBlock* cmdBlock)
{

	int ret = 0;

	ret = BaseCollectorImpl::processCommand(cmdBlock);

	return ret;
}



struct tm* TimeCollector::getSystemTime(time_t* aclock)
{
	struct tm* newtime;
	time(aclock);   // Get time in seconds
	newtime = localtime(aclock);   // Convert time to struct tm form 

	return newtime;
}


int TimeCollector::receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader)
{

	cout<<"The data received from the client is - "<<buffer+dimeHeader->id_length+dimeHeader->options_length+dimeHeader->type_length<<endl;
	return 0;
}

int main(int argc, char* argv[])
{

	char* collectorName = "org.eclipse.tptp.TimeCollector";

	TimeCollector* TimeCollectorAgent = new TimeCollector(collectorName);
		
	TimeCollectorAgent->processCommandLine(argc, argv);

	TimeCollectorAgent->registerAgent();

	while(!TimeCollectorAgent->isRunning())
	{
		Sleep(1000);
	}
	TimeCollectorAgent->sendCurrentTime();
	
	TimeCollectorAgent->waitForTermination();

	return 0;
}
