/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: TimeDataProcessor.cpp,v 1.5 2005/07/07 19:48:14 akaylor Exp $
 *
 *******************************************************************************/ 


#include <iostream>


#include "TimeCollectorEventHandler.h"



using namespace std;

TimeCollectorCommandHandler::TimeCollectorCommandHandler()
{

}

TimeCollectorCommandHandler::~TimeCollectorCommandHandler()
{

}				
				
void TimeCollectorCommandHandler::incomingCommand(INode* node, CommandElement* command)
{
	cout<<"TimeCollectorCommandHandler: Incoming command from Time Collector agent : "<<command->getCommand()<<endl;

	int            ret = -1;
	int            sourceID;
	int            contextID;
	char*          interfaceName;
	char*          cmdName;
	tptp_list_t* parmList;

	ret = parseCommand(command->getCommand(), &sourceID, &contextID, &interfaceName, &cmdName, &parmList );

	if (isEqualString(cmdName, "currentTime"))
	{
		displayCurrentTime(parmList);
	}
}


void TimeCollectorCommandHandler::displayCurrentTime(tptp_list_t* parmList)
{
	char* time = 0;

	if (0 != getStringParam( "time", parmList, &time ) )
	{
		return;
	}

	cout<<"The Current Time is : "<<time<<endl;
}
