/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and Implementation
 *
 * $Id: SampleClient.cpp,v 1.13 2005/08/19 17:26:34 vnaikawadi Exp $
 *
 *******************************************************************************/ 



#include <iostream>
#include <stdlib.h>
#include <stdio.h>
using namespace std;

#include "tptp/client/INode.h"
#include "tptp/client/NodeFactory.h"
#include "tptp/client/Agent.h"
#include "tptp/client/Collector.h"
#include "TimeCollectorEventHandler.h"
#include "tptp/TPTPSupportTypes.h"
#include "tptp/client/Constants.h"
#include "tptp/client/IProcess.h"



using namespace TPTP::Client;



/**
 *********************************************************
 *                                                       
 * @brief                                                
 *    Sample Client
 *
 *********************************************************/
int main(int argc, char* argv[])
{
	int rc = 0 ;
	char* hostName = "localhost";
	int portNum = 10006;
	INode* SampleNode = 0;
	AgentController* ACProxy = 0;
	char* timeCollectorAgentIID = "org.eclipse.tptp.TimeCollector";
	char* timeCollectorEventsIID = "org.eclipse.tptp.TimeCollectorEvents";
	

	//Create a Node that represents the Target Machine
	SampleNode = NodeFactory::createNode(hostName);

	//Connect to the Node
	cout<<endl<<"Connecting to the Node..."<<endl<<endl;
	//Get the Agent Controller Proxy on the Node
	ACProxy = SampleNode->connect(portNum);

	if (ACProxy != 0)
	{
		//Get an Agent - TimeCollector Agent in this case
		Collector* timeCollector = new Collector(timeCollectorAgentIID);
		ACProxy->getAgent(timeCollector, TPTP_CONTROLLER_ACCESS);
		cout<<endl<<"The Time Collector Agent ID: "<<timeCollector->getAgentID()<<endl<<endl;
		
		TimeCollectorCommandHandler* eventHandler = new TimeCollectorCommandHandler();

		//Add the Event Listener - to receive events from TimeCollector
		long listenerid = timeCollector->addEventListener(timeCollectorEventsIID, eventHandler);

		//Send RUN command - Starts the TimeCollector
		cout<<"Start the TimeCollector..."<<endl;
		timeCollector->run();

		cout<<"Wait for few seconds before stopping the TimeCollector..."<<endl;
		Sleep(10000);


		// Remove the Event Listener 
		timeCollector->removeEventListener(timeCollectorEventsIID, listenerid);

		//Send STOP command - Stops the TimeCollector
		cout<<"Stop the TimeCollector..."<<endl;
		timeCollector->stop();

		Sleep(20000);

		// Release the time collector 
		timeCollector->releaseAgent();
		
		delete timeCollector;

		ACProxy->destroy();

		NodeFactory::deleteNode(SampleNode);
		
		cout<<"All finished"<<endl;
	}
	else
	{
		cout<<"ERROR: Unable to connect to the Agent Controller running on "<<hostName<<" at port number "<<portNum<<endl;
	}

	while(1){Sleep(5000);};

	return 0;
}


