%This is a script to calculate a deterministic solution of the EVD model presented in Manuscript ID rsif-2016-0847
%Also shown here will be the value for R0 so that it can be determined if the R0 presented is appropriate and
%correct for the model shown.
clear


mu=0.00005;
Bi=0.5;
Bd=0.6;
Bh=0.00016;
%N=1 gives scaling as in equations (B2) in manuscript.
N=1;
sigma=0.10;
gir=0.07;
mue=0.12;
tau=0.20;
delta=0.33;
ghr=0.10;
k=0;

P=[mu Bi Bd Bh N sigma gir mue tau delta ghr k];

%Build Initial Conditions
      Er=((((sigma/(gir+tau+mue+mu))*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/(mu+sigma))-1-k/mu)+((((sigma/(gir+tau+mue+mu))*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/(mu+sigma))-1-k/mu)^2+4*((sigma/(gir+tau+mue+mu))*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/(mu+sigma))*k/mu)^(.5))*mu*N/(2*((sigma/(gir+tau+mue+mu))*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/(mu+sigma))*(mu+sigma));
      S=N-(1+sigma/mu)*Er;
      I=(sigma/(gir+tau+mue+mu))*Er;
      D=mue*(sigma/(gir+tau+mue+mu))*Er/(delta+mu);
      H=tau*(sigma/(gir+tau+mue+mu))*Er/(ghr+mue+mu);
      R=((gir*(sigma/(gir+tau+mue+mu))+ghr*(tau*sigma/((gir+tau+mue+mu)*(ghr+mue+mu))))/mu)*Er;
%This is the same as above ("Build Initial Conditions") but using substitutions and R0=Rz
%  %        Ot=(sigma/(gir+tau+mue+mu));
%  %        Of=tau*sigma/((gir+tau+mue+mu)*(ghr+mue+mu));
%  %        Os=(gir*Ot+ghr*Of)/mu;
%  %        Rz=Ot*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/(mu+sigma);
%  %        Eu=(Rz-1-k/mu);
%  %        Er=(Eu+(Eu^2+4*Rz*k/mu)^(.5))*mu*N/(2*Rz*(mu+sigma));
%  %  %      E=(Eu+(Eu^2+4*Rz*k/mu)^(.5))*mu*N/(2*Rz*(mu+sigma));
%  %        S=N-(1+sigma/mu)*Er;
%  %        I=Ot*Er;
%  %        D=mue*Ot*Er/(delta+mu);
%  %        H=tau*Ot*Er/(ghr+mue+mu);
%  %        R=Os*Er;


%Call IC variable X
X=[S Er I D H R];
options = odeset('AbsTol',1e-8,'RelTol',1e-8);
%Use ode45 to find a numerical solution given IC=X and function EVDmfe (Ebola virus disease mean field equations)
[T U]=ode45(@EVDmfe,[0,30000],X,options,P);

%This is R0 from the manuscript      
Rzero = sigma*(Bi+Bd*mue/(delta+mu)+Bh*tau/(ghr+mue+mu))/((gir+mue+tau+mu)*(mu+sigma));

format long
disp('R0=')
Rzero
disp('Stable Endemic Equilibrium:')
U(1,:)
disp('State Vector after 30,000 days:')
U(end,:)
disp('The difference between the two')
U(end,:)-U(1,:)
disp('Note that the difference is below tolerance of the solver.')


%These are two plots that show graphically what the
%above display comments show numerically.
figure(10)
set(gca,'FontSize',20)
plot(T,U(:,3))
hold on
plot([T(1) T(end)],[U(1,3) U(1,3)],'r','LineWidth',4)
legend('Numerical Solution','Predicted Endemic State')
title 'Zoomed Way In'
ylabel 'Infectious'
xlabel 'Time'
print -f10 -dpdf EndemicStateZoom.pdf

figure(20)
set(gca,'FontSize',20)
plot(T,U(:,3),'LineWidth',3)
hold on
plot([T(1) T(end)],[U(1,3) U(1,3)],'r','LineWidth',2)
legend('Numerical Solution','Predicted Endemic State')
axis([0 30000 5.8e-5 5.9e-5])
title 'Wide Angle View'
ylabel 'Infectious'
xlabel 'Time'
print -f20 -dpdf EndemicStateWide.pdf   
      
      
