function xdot = EVDmfe(t,X,P);
%Function xdot is the system of equations found in 
%JRSI Manuscript ID rsif-2016-0847 equations (B2).
%The primary difference is that those equations are
%scaled so that each state variable is a population 
%proportion. In order to reconcile the two you I have 
%set the population size parameter N equal to 1.
%This is done in the script Stability_Verification.m


%Define the parameters

mu=P(1);
%these are Beta_{idh} respectively
Bi=P(2);
Bd=P(3);
Bh=P(4);
%Note that this parameter is the mean population size, and is set to N=1 (see Stability_Verification.m)
%which accounts for the scaling in equations B2.
N=P(5);
sigma=P(6);
%gir is gamma_{ir}
gir=P(7);
%mue is mu_{e}
mue=P(8);
tau=P(9);
delta=P(10);
%ghr is gamma_{hr}
ghr=P(11);
%Note also that in this case k=kappa=0.
k=P(12);


%Note X=[S E I D H R B] which means that in equations below,
%X(1)=S
%X(2)=E
%X(3)=I
%X(4)=D
%X(5)=H
%X(6)=R

xdot=[];

xdot(1,1)=mu*N-mu*X(1)-Bi*X(3)*X(1)/N-Bd*X(4)*X(1)/N-Bh*X(5)*X(1)/N;
xdot(2,1)=Bi*X(3)*X(1)/N+Bd*X(4)*X(1)/N+Bh*X(5)*X(1)/N-(sigma+mu)*X(2);
xdot(3,1)=sigma*X(2)-(gir+mue+tau)*X(3)-mu*X(3);
xdot(4,1)=mue*X(3)-delta*X(4)-mu*X(4);
xdot(5,1)=tau*X(3)-(ghr+mue)*X(5)-mu*X(5);
xdot(6,1)=ghr*X(5)+gir*X(3)-mu*X(6);

end   %function


