 
package de.emsw.gosa.product.logtest.part;



import java.util.logging.Level;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.log.LogService;
import org.slf4j.LoggerFactory;

public class LogTestPart {
	@Inject private org.eclipse.e4.core.services.log.Logger e4Logger;
	@Inject private org.osgi.service.log.LogService logService;
	private java.util.logging.Logger julLogger;
	private org.slf4j.Logger slf4jLogger;
	
	@Inject
	void initLoggers() {
		julLogger = java.util.logging.Logger.getLogger(getClass().getName());
		julLogger.setLevel(Level.ALL); // Default is Level.INFO
		slf4jLogger = LoggerFactory.getLogger(getClass());
	}
	
	// Common Log Levels
	private enum LEVEL {
		DEBUG, INFO, WARNING, ERROR;
		
		public static String[] getTexts() {
			String[] ret = new String[4];
			int i = 0;
			for (LEVEL lvl : LEVEL.values()) {
				ret[i++] = lvl.toString();
			}
			return ret;
		}

		public static LEVEL getLevel(int index) {
			return LEVEL.values()[index];
		}
	};
	
	private LEVEL currentLevel = LEVEL.INFO;
	
	@PostConstruct
	public void postConstruct(Composite parent) {
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 10;
		parent.setLayout(layout);
		
		final Text txtInput = new Text(parent, SWT.MULTI | SWT.BORDER | SWT.WRAP);
		txtInput.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		txtInput.setText("Some Log Message");
		
		final Combo cmbLevel = new Combo(parent, SWT.BORDER | SWT.READ_ONLY);
		cmbLevel.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		cmbLevel.setItems(LEVEL.getTexts());
		cmbLevel.select(1);
		cmbLevel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int sel = cmbLevel.getSelectionIndex();
				currentLevel = LEVEL.getLevel(sel);
			}
		});
		
		final Button btnE4Log = new Button(parent, SWT.PUSH);
		btnE4Log.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		btnE4Log.setText("org.eclipse.e4.core.services.log.Logger");
		btnE4Log.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String txt = txtInput.getText();
				switch (currentLevel) {
				case DEBUG:
					e4Logger.debug(txt);
					break;
				case INFO:
					e4Logger.info(txt);
					break;
				case WARNING:
					e4Logger.warn(txt);
					break;
				case ERROR:
					e4Logger.error(txt);
					break;
				}
			}
		});
		
		final Button btnEquinoxLog = new Button(parent, SWT.PUSH);
		btnEquinoxLog.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		btnEquinoxLog.setText("org.osgi.service.log.LogService");
		btnEquinoxLog.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				switch (currentLevel) {
				case DEBUG:
					logService.log(LogService.LOG_DEBUG, txtInput.getText());
					break;
				case INFO:
					logService.log(LogService.LOG_INFO, txtInput.getText());
					break;
				case WARNING:
					logService.log(LogService.LOG_WARNING, txtInput.getText());
					break;
				case ERROR:
					logService.log(LogService.LOG_ERROR, txtInput.getText());
					break;
				}
			}
		});
		
		final Button btnJulLog = new Button(parent, SWT.PUSH);
		btnJulLog.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		btnJulLog.setText("java.util.logging.Logger");
		btnJulLog.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				switch (currentLevel) {
				case DEBUG:
					julLogger.log(Level.FINE, txtInput.getText());
					break;
				case INFO:
					julLogger.log(Level.INFO, txtInput.getText());
					break;
				case WARNING:
					julLogger.log(Level.WARNING, txtInput.getText());
					break;
				case ERROR:
					julLogger.log(Level.SEVERE, txtInput.getText());
					break;
				}
			}
		});
		
		final Button btnSlf4jLog = new Button(parent, SWT.PUSH);
		btnSlf4jLog.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		btnSlf4jLog.setText("org.slf4j.Logger");
		btnSlf4jLog.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				switch (currentLevel) {
				case DEBUG:
					slf4jLogger.debug(txtInput.getText());
					break;
				case INFO:
					slf4jLogger.info(txtInput.getText());
					break;
				case WARNING:
					slf4jLogger.warn(txtInput.getText());
					break;
				case ERROR:
					slf4jLogger.error(txtInput.getText());
					break;
				}
			}
		});
	}
	
}