package de.emsw.gosa.product.logtest;

import java.util.logging.Handler;

import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogTestPlugin implements BundleActivator {

	private static BundleContext context;
	
	private Logger logger;

	static BundleContext getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		LogTestPlugin.context = bundleContext;
		logger = LoggerFactory.getLogger(getClass());
	    logger.info("GOSA Logging Test started ...");
	    
	    // Use SLF4J as LoggerProvider for e4
	    ILoggerProvider service = new ILoggerProvider() {
	    	@Override
	    	public org.eclipse.e4.core.services.log.Logger getClassLogger(Class<?> clazz) {
	    		return new Slf4jLoggerWrapper(LoggerFactory.getLogger(clazz));
	    	}
	    };
		bundleContext.registerService(ILoggerProvider.class.getName(), service, null);
	    
	    // Remove all JUL Handlers
	    removeJulHandlers(java.util.logging.Logger.getLogger(java.util.logging.Logger.GLOBAL_LOGGER_NAME));
	    
	    // ACTIVATE java.util.logging ==> sl4j Handler
	    // this will transfer the Logging-Event to logback
	 	SLF4JBridgeHandler.install();
	}
	
	private void removeJulHandlers(java.util.logging.Logger julLogger) {
		for (Handler handler : julLogger.getHandlers()) {
			julLogger.removeHandler(handler);
		}
		if (julLogger.getParent() != null)
			removeJulHandlers(julLogger.getParent());
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		LogTestPlugin.context = null;
		logger.info("GOSA Logging Test ended.");
	}

}
