package resteasy.example;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestActivator implements BundleActivator {

	private static final Logger LOG = LoggerFactory.getLogger(RestActivator.class);

	@Override
	public void start(BundleContext arg0) throws Exception {
		LOG.info("Launching test...");
		restTest();
	}

	@Override
	public void stop(BundleContext arg0) throws Exception {
		LOG.info("Test stopped");
	}
	
	private void restTest() {
		ResteasyClient client = new ResteasyClientBuilder().build();
		ResteasyWebTarget target = client.target("http://jsonplaceholder.typicode.com/posts/1");
		Builder builder = target.request();
		Invocation invocation = builder.buildGet();
		Response response = invocation.invoke();
		LOG.info("Status result:" + response.getStatus());
		response.close();
		client.close();
	}

}
