package com.justeat.mickeydb;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class MickeyDatabaseModel {
  @Accessors
  private String packageName;
  
  @Accessors
  private String databaseName;
  
  @Accessors
  private /* SqliteDatabaseSnapshot */Object snapshot;
  
  public /* ArrayList<MigrationBlock> */Object migrations /* Skipped initializer because of errors */;
  
  public /* Hashtable<String, MigrationBlock> */Object migrationsByName /* Skipped initializer because of errors */;
  
  public /* Hashtable<String, MigrationBlock> */Object migrationsByFromName /* Skipped initializer because of errors */;
  
  public /* ArrayList<CreateTableStatement> */Object initTables /* Skipped initializer because of errors */;
  
  public /* ArrayList<CreateViewStatement> */Object initViews /* Skipped initializer because of errors */;
  
  public /* ArrayList<MickeyFunction> */Object functions /* Skipped initializer because of errors */;
  
  public /* ArrayList<ActionStatement> */Object actions /* Skipped initializer because of errors */;
  
  public MickeyDatabaseModel(final String databaseFqn) {
    boolean _contains = databaseFqn.contains(".");
    if (_contains) {
      int s = databaseFqn.lastIndexOf(".");
      String _substring = databaseFqn.substring(0, s);
      this.packageName = _substring;
      String _substring_1 = databaseFqn.substring((s + 1));
      this.databaseName = _substring_1;
    } else {
      this.packageName = databaseFqn;
      this.databaseName = databaseFqn;
    }
  }
  
  @Pure
  public String getPackageName() {
    return this.packageName;
  }
  
  public void setPackageName(final String packageName) {
    this.packageName = packageName;
  }
  
  @Pure
  public String getDatabaseName() {
    return this.databaseName;
  }
  
  public void setDatabaseName(final String databaseName) {
    this.databaseName = databaseName;
  }
  
  @Pure
  public SqliteDatabaseSnapshot getSnapshot() {
    return this.snapshot;
  }
  
  public void setSnapshot(final SqliteDatabaseSnapshot snapshot) {
    this.snapshot = snapshot;
  }
}
