package com.justeat.mickeydb.generator

import com.google.inject.Inject
import com.justeat.mickeydb.generator.SqliteDatabaseStatementGenerator
import com.justeat.mickeydb.mickeyLang.MigrationBlock
import com.justeat.mickeydb.mickeyLang.MickeyFile

import static extension com.justeat.mickeydb.Strings.*
import java.math.BigDecimal

class SqliteMigrationGenerator {
	
		@Inject extension SqliteDatabaseStatementGenerator
		
		def CharSequence generate(MickeyFile model, String packageName, String databaseName, MigrationBlock migration) '''
			/*
			 * Generated by Mickey DB
			 */
			package «packageName».migrations;
			
			import android.database.sqlite.SQLiteDatabase;
			import com.justeat.mickeydb.Migration;
			
			public class Default«databaseName.pascalize»Migration«migration.name.pascalize» extends Migration {
				@Override
				public void onBeforeUp(SQLiteDatabase db) {}
				
				@Override
				public void up(SQLiteDatabase db) {
					«migration.statements.generateStatements»
				}
				
				@Override
				public void onAfterUp(SQLiteDatabase db) {}
			}
			'''
}