/*
 * generated by Xtext 2.9.2
 */
package com.justeat.mickeydb.generator

import com.google.inject.Inject
import com.google.inject.Provider
import com.justeat.mickeydb.ContentUris
import com.justeat.mickeydb.MickeyAssembler
import com.justeat.mickeydb.MickeyDatabaseModel
import com.justeat.mickeydb.mickeyLang.CreateTableStatement
import com.justeat.mickeydb.mickeyLang.CreateViewStatement
import com.justeat.mickeydb.mickeyLang.MickeyFile
import com.justeat.mickeydb.mickeyLang.MigrationBlock
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext

import static extension com.justeat.mickeydb.ModelUtil.*
import static extension com.justeat.mickeydb.Strings.*

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class MickeyLangGenerator extends AbstractGenerator {



	@Inject SqliteOpenHelperGenerator mOpenHelperGenerator
	@Inject ContentProviderContractGenerator mContentProviderContractGenerator
	@Inject ContentProviderGenerator mContentProviderGenerator
	@Inject Provider<SqliteMigrationGenerator> mMigrationGenerator
	@Inject ActiveRecordGenerator mActiveRecordGenerator
	@Inject CustomActionsGenerator mCustomActionsGenerator
	@Inject MickeyAssembler assembler;


	override void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {

		if(!resource.URI.toString.contains("init.mickey")) {
			return;
		}

		var mickeyModel = assembler.assemble(resource)

		val stubOutput = MickeyOutputConfigurationProvider.DEFAULT_STUB_OUTPUT

		mickeyModel.databases.values.forEach[

			var content = new ContentUris
			content.init(it)
			fsa.generateFile(
					packageName.resolveFileName("Abstract".concat(databaseName.pascalize).concat("OpenHelper")),
					mOpenHelperGenerator.generate(it)
			);
			fsa.generateFile(
					packageName.resolveFileName(databaseName.pascalize.concat("OpenHelper")),
					stubOutput,
					mOpenHelperGenerator.generateStub(it, snapshot)
			);
			fsa.generateFile(
					packageName.resolveFileName(databaseName.pascalize.concat("Contract")),
					mContentProviderContractGenerator.generate(it, content)
			);

			fsa.generateFile(
					packageName.resolveFileName("Abstract".concat(databaseName.pascalize).concat("ContentProvider")),
					mContentProviderGenerator.generate(it, content)
			);

			fsa.generateFile(
					packageName.resolveFileName(databaseName.pascalize.concat("ContentProvider")),
					stubOutput,
					mContentProviderGenerator.generateStub(it, snapshot)
			);

			snapshot.tables.forEach[
				statement|
				generateActiveRecordEntity(it, resource, fsa, statement as CreateTableStatement)
			];

			snapshot.views.forEach[
				statement|
				generateActiveRecordEntity(it, resource, fsa, statement as CreateViewStatement)
			];

			it.initTables.forEach[
				statement|
				generateActiveRecordEntity(it, resource, fsa, statement as CreateTableStatement)
			];

			it.initViews.forEach[
				statement|
				generateActiveRecordEntity(it, resource, fsa, statement as CreateViewStatement)
			];

			it.migrations.forEach[
				item,index|generateMigration(packageName, databaseName, resource, fsa, item)
			];

			content.uris.forEach[p1|
				fsa.generateFile(
						packageName.concat('.actions').resolveFileName(p1.name.pascalize.concat("Actions")),
						mCustomActionsGenerator.generate(it, p1)
				);
			]
		]
	}

	def void generateActiveRecordEntity(MickeyDatabaseModel model, Resource resource, IFileSystemAccess fsa, CreateTableStatement statement) {

		if(statement.hasAndroidPrimaryKey) {
			var genFileName = model.packageName.resolveFileName(statement.name.pascalize.concat("Record"))

			fsa.generateFile(genFileName,
			mActiveRecordGenerator.generate(model.packageName, model.databaseName, statement)
			)
		}
	}

	def void generateActiveRecordEntity(MickeyDatabaseModel model, Resource resource, IFileSystemAccess fsa, CreateViewStatement statement) {

		if(statement.hasAndroidPrimaryKey) {
			var genFileName = model.packageName.resolveFileName(statement.name.pascalize.concat("Record"))

			fsa.generateFile(genFileName,
			mActiveRecordGenerator.generate(model.packageName, model.databaseName, statement)
			)
		}
	}

	def void generateMigration(String packageName, String databaseName, Resource resource, IFileSystemAccess fsa, MigrationBlock migration) {

		var model = resource.contents.head as MickeyFile;

		var genFileName = packageName.concat(".migrations").resolveFileName("Default".concat(databaseName.pascalize).concat("Migration").concat(String::valueOf(migration.name.pascalize)))

		var generator = mMigrationGenerator.get()

		fsa.generateFile(genFileName,
		generator.generate(model, packageName, databaseName, migration)
		)
	}
}
