package com.justeat.mickeydb.generator

import com.justeat.mickeydb.ContentUriInfo
import com.justeat.mickeydb.MickeyDatabaseModel
import com.justeat.mickeydb.mickeyLang.ColumnType
import com.justeat.mickeydb.mickeyLang.ContentUriParamSegment
import com.justeat.mickeydb.mickeyLang.ContentUriQueryParam

import static extension com.justeat.mickeydb.ModelUtil.*
import static extension com.justeat.mickeydb.Strings.*
import com.justeat.mickeydb.mickeyLang.ContentNotificationUri
import com.justeat.mickeydb.mickeyLang.NotifyContentUriParamSegment
import com.justeat.mickeydb.mickeyLang.NotifyContentUriSegment

class CustomActionsGenerator {
	def CharSequence generate(MickeyDatabaseModel model, ContentUriInfo content) '''
	«var snapshot = model.snapshot»
	«var hasSlugParams = content.action != null && !content.action.uri.segments.filter[it instanceof ContentUriParamSegment].empty»
	«var hasQueryParams = content.action != null &&  !content.action.params.empty»
	
	/*
	 * Generated by Mickey DB
	 */
	package «model.packageName».actions;
	
	import com.justeat.mickeydb.ActiveRecordFactory;
	import android.content.ContentValues;
	import android.database.sqlite.SQLiteDatabase;
	import android.net.Uri;
	import com.justeat.mickeydb.CustomActions;
	import com.justeat.mickeydb.MickeyContentProvider;
	import com.justeat.mickeydb.Query;
	import «model.packageName».«model.databaseName»Contract;
	import «model.packageName».«model.databaseName»Contract.«content.type.pascalize»;
	import «model.packageName».Abstract«model.databaseName»OpenHelper.Sources;
	«IF content.supportsActiveRecord»
	import «model.packageName».«content.type.pascalize»Record;
	«ENDIF»
	import java.util.List;
	import java.util.ArrayList;
	import java.util.Set;
	import com.justeat.mickeydb.util.Uris;
	
	public class «content.name.pascalize»Actions extends CustomActions {
		«IF hasQueryParams || hasSlugParams || (!content.directory && content.supportsActiveRecord)»
		@Override
		public void addQueryExpressionsFromUriSegmentParams(Uri uri, Query query) {
			«IF content.userDefined»
			«IF hasSlugParams»
			List<String> segments = uri.getPathSegments();
			«ENDIF»
			«IF hasQueryParams»
			Set<String> queryKeys = Uris.getQueryParameterNames(uri);
			«ENDIF»
			«createSlugVariables(content)»
			«createQueryParamVariables(content)»
			«createQueryStatements(content)»
			«ELSE»
			«IF !content.directory && content.supportsActiveRecord»
			List<String> segments = uri.getPathSegments();
			long _idSlug = Long.parseLong(segments.get(1));
			query.expr(«content.type.pascalize»._ID, Query.Op.EQ, _idSlug);
			«ENDIF»
			«ENDIF»
		}
		«ENDIF»
		
		@Override
		public String getSourceName() {
			return Sources.«content.type.underscore.toUpperCase»;
		}
		
		@Override
		public ActiveRecordFactory<?> getActiveRecordFactory() {
			«IF content.supportsActiveRecord»
			return «content.type.pascalize»Record.getFactory();
			«ELSE»
			throw new RuntimeException("«content.type» does not support active record, you may need to add an _id to that table");
			«ENDIF»
		}
		
		@Override
		public List<Uri> getNotifyUris(MickeyContentProvider provider, Uri uri) {
			«IF content.action?.notifications?.size > 0»
			ArrayList<Uri> notifyUris = new ArrayList<Uri>();
			«IF hasSlugParams»
			List<String> segments = uri.getPathSegments();
			«createStringSlugVariables(content)»
			«ENDIF»
			«FOR notificationUri : content.action.notifications»
			notifyUris.add(«createNotifyStatement(model, content, notificationUri)»);
			«ENDFOR»
			return notifyUris;
			«ELSE»
			return null;
			«ENDIF»
		}
		«IF hasSlugParams»
		
		@Override
		public void addContentValuesFromUri(MickeyContentProvider provider, Uri uri, ContentValues values) {
			«IF content.action != null»
			«IF hasSlugParams»
			List<String> segments = uri.getPathSegments();
			«createSlugVariables(content)»
			«ENDIF»
			«FOR seg : content.action.uri.segments»
			«IF seg instanceof ContentUriParamSegment»
			«var paramSeg = (seg as ContentUriParamSegment)»
			values.put(«content.action.type.name.pascalize».«paramSeg.param.name.underscore.toUpperCase», «paramSeg.param.name.camelize»Slug);
			«ENDIF»
			«ENDFOR»
			«ENDIF»
		}
		«ENDIF»
	}
	'''
	
	def createNotifyStatement(MickeyDatabaseModel model, ContentUriInfo info, ContentNotificationUri uri) '''
		«model.databaseName»Contract.BASE_CONTENT_URI
			.buildUpon()
			«FOR seg : uri.uri.segments»
			«IF seg instanceof NotifyContentUriParamSegment»
			.appendPath(«getSlugVariableForNotifyUriSegment(seg as NotifyContentUriSegment, info)»)
			«ELSE»
			.appendPath("«seg.name»")
			«ENDIF»
			«ENDFOR»
			.build()
	'''
	
	def getSlugVariableForNotifyUriSegment(NotifyContentUriSegment segment, ContentUriInfo info) {
		if(info.action.uri.segments.exists[(it instanceof ContentUriParamSegment) && segment.name.equals((it as ContentUriParamSegment).param.name)]) {
			return segment.name.camelize + "Slug"
		} else {
			return "\"NO-MATCH\""
		}
	}
	
	def createQueryStatements(ContentUriInfo content)
		'''«FOR entry : content.action.uri.segments.indexed»
		«IF entry.value instanceof ContentUriParamSegment»
		«var param = entry.value as ContentUriParamSegment»
		«IF param.param.inferredColumnType != ColumnType::TEXT»
		query.expr(«content.type.pascalize».«param.param.name.underscore.toUpperCase», Query.Op.EQ, «param.param.name.camelize»Slug);
		«ELSE»
		query.expr("cast(" + «content.type.pascalize».«param.param.name.underscore.toUpperCase» + " as text)", Query.Op.EQ, «param.param.name.camelize»Slug);
		«ENDIF» 
		«ENDIF» 
		«ENDFOR»
		«FOR queryParam : content.action.params»
		if(queryKeys.contains(«content.type.pascalize».«queryParam.column.name.underscore.toUpperCase»)) {
			query.expr(«content.type.pascalize».«queryParam.column.name.underscore.toUpperCase», «queryParam.generateOperator», «queryParam.column.name.camelize»QueryParam);
		}
		
		«ENDFOR»'''
	
	
	def createQueryParamVariables(ContentUriInfo content)
		'''«FOR queryParam : content.action.params»
		«var columnType = queryParam.column.inferredColumnType»
		«IF columnType == ColumnType::BOOLEAN»
		«queryParam.column.inferredColumnType.toJavaTypeName» «queryParam.column.name.camelize»QueryParam = Uris.getBooleanQueryParamOrDefault(uri, queryKeys, «content.type.pascalize».«queryParam.column.name.underscore.toUpperCase»);
		«ELSEIF columnType == ColumnType::INTEGER»
		«queryParam.column.inferredColumnType.toJavaTypeName» «queryParam.column.name.camelize»QueryParam = Uris.getIntQueryParamOrDefault(uri, queryKeys, «content.type.pascalize».«queryParam.column.name.underscore.toUpperCase»);
		«ELSEIF columnType == ColumnType::REAL»
		«queryParam.column.inferredColumnType.toJavaTypeName» «queryParam.column.name.camelize»QueryParam = Uris.getDoubleQueryParamOrDefault(uri, queryKeys, «content.type.pascalize».«queryParam.column.name.underscore.toUpperCase»);
		«ELSE»
		«queryParam.column.inferredColumnType.toJavaTypeName» «queryParam.column.name.camelize»QueryParam = Uris.getStringQueryParamOrDefault(uri, queryKeys, «content.type.pascalize».«queryParam.column.name.underscore.toUpperCase»);
		«ENDIF»
		«ENDFOR»'''
	
	
	def createSlugVariables(ContentUriInfo content)
		'''«FOR entry : content.action.uri.segments.indexed»
		«IF entry.value instanceof ContentUriParamSegment»
		«var param = entry.value as ContentUriParamSegment»
		«IF param.param.inferredColumnType != ColumnType::TEXT»
		long «param.param.name.camelize»Slug = Long.parseLong(segments.get(«entry.key»));
		«ELSE»
		String «param.param.name.camelize»Slug = segments.get(«entry.key»);
		«ENDIF» 
		«ENDIF»
		«ENDFOR»'''
		
	def createStringSlugVariables(ContentUriInfo content)
		'''«FOR entry : content.action.uri.segments.indexed»
		«IF entry.value instanceof ContentUriParamSegment»
		«var param = entry.value as ContentUriParamSegment»
		String «param.param.name.camelize»Slug = segments.get(«entry.key»);
		«ENDIF»
		«ENDFOR»'''
	
	
	def CharSequence generateOperator(ContentUriQueryParam param) {
		if(param.like) {
			return "Query.Op.LIKE"
		} else {
			return "Query.Op.EQ"
		}
	}
	
}