/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.scoping;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.justeat.mickeydb.MickeyAssembler;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.MickeyEnvironment;
import com.justeat.mickeydb.MickeyModel;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.ActionStatement;
import com.justeat.mickeydb.mickeyLang.AlterTableAddColumnStatement;
import com.justeat.mickeydb.mickeyLang.AlterTableRenameStatement;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnSourceRef;
import com.justeat.mickeydb.mickeyLang.ContentUriParamSegment;
import com.justeat.mickeydb.mickeyLang.ContentUriQueryParam;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateTriggerStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.DMLStatement;
import com.justeat.mickeydb.mickeyLang.DropTableStatement;
import com.justeat.mickeydb.mickeyLang.DropTriggerStatement;
import com.justeat.mickeydb.mickeyLang.DropViewStatement;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MickeyLangPackage;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import com.justeat.mickeydb.mickeyLang.NewColumn;
import com.justeat.mickeydb.mickeyLang.OldColumn;
import com.justeat.mickeydb.mickeyLang.SelectExpression;
import com.justeat.mickeydb.mickeyLang.SelectSource;
import com.justeat.mickeydb.mickeyLang.SingleSource;
import com.justeat.mickeydb.mickeyLang.SingleSourceTable;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import com.justeat.mickeydb.mickeyLang.UpdateColumnExpression;
import com.justeat.mickeydb.mickeyLang.UpdateStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MickeyLangScopeProvider
extends AbstractDeclarativeScopeProvider {
    private static final Logger LOG = Logger.getLogger(MickeyLangScopeProvider.class);
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private MickeyAssembler assembler;
    @Inject
    private MickeyEnvironment mickeyEnvironment;

    public IScope scope_AlterTableAddColumnStatement_table(final AlterTableAddColumnStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String tableName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, tableName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_AlterTableRenameStatement_table(final AlterTableRenameStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String tableName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, tableName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_ActionStatement_type(final ActionStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String tableName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, tableName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_SingleSourceTable_tableReference(final SingleSourceTable context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String tableName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, tableName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_ColumnSourceRef_column(ColumnSourceRef context, EReference ref) {
        boolean _notEquals;
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        String tableName = "";
        SelectSource _source = context.getSource();
        boolean bl = _notEquals = !Objects.equal((Object)_source, null);
        if (_notEquals) {
            String _featureNodeText;
            SelectSource _source_1 = context.getSource();
            tableName = _featureNodeText = ModelUtil.getFeatureNodeText(_source_1, MickeyLangPackage.Literals.SINGLE_SOURCE_TABLE__TABLE_REFERENCE);
        } else {
            boolean _notEquals_1;
            UpdateStatement updateStatement = ModelUtil.getAncestorOfType(context, UpdateStatement.class);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)updateStatement, null);
            if (_notEquals_1) {
                String _featureNodeText_1;
                tableName = _featureNodeText_1 = ModelUtil.getFeatureNodeText(updateStatement, MickeyLangPackage.Literals.UPDATE_STATEMENT__TABLE);
            }
        }
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }

    public IScope scope_NewColumn_column(NewColumn context, EReference ref) {
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        CreateTriggerStatement statement = ModelUtil.getAncestorOfType(context, CreateTriggerStatement.class);
        String tableName = ModelUtil.getFeatureNodeText(statement, MickeyLangPackage.Literals.CREATE_TRIGGER_STATEMENT__TABLE);
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }

    public IScope scope_OldColumn_column(OldColumn context, EReference ref) {
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        CreateTriggerStatement statement = ModelUtil.getAncestorOfType(context, CreateTriggerStatement.class);
        String tableName = ModelUtil.getFeatureNodeText(statement, MickeyLangPackage.Literals.CREATE_TRIGGER_STATEMENT__TABLE);
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }

    public IScope scope_UpdateColumnExpression_columnName(UpdateColumnExpression context, EReference ref) {
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        DMLStatement statement = ModelUtil.getAncestorOfType(context, DMLStatement.class);
        String tableName = ModelUtil.getTargetTableName(statement);
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }

    public IScope scope_ColumnSourceRef_source(ColumnSourceRef context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        SelectExpression select = ModelUtil.getAncestorOfType(context, SelectExpression.class);
        ArrayList<SingleSource> _findAllSingleSources = ModelUtil.findAllSingleSources(select);
        _xblockexpression = Scopes.scopeFor(_findAllSingleSources, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_DropViewStatement_view(final DropViewStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String viewName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, viewName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_DropTableStatement_table(final DropTableStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String viewName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, viewName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_DropTriggerStatement_trigger(final DropTriggerStatement context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String triggerName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, triggerName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public IScope scope_MigrationBlock_from(final MigrationBlock context, EReference ref) {
        IScope _xblockexpression = null;
        IScope scope = this.delegateGetScope(context, ref);
        MickeyFile model = ModelUtil.getModel(context);
        String migrationName = ModelUtil.getFeatureNodeText(context, ref);
        String _databaseName = model.getDatabaseName();
        QualifiedName _create = QualifiedName.create((String[])new String[]{_databaseName, migrationName});
        Iterable _elements = scope.getElements(_create);
        Functions.Function1<IEObjectDescription, EObject> _function = new Functions.Function1<IEObjectDescription, EObject>(){

            public EObject apply(IEObjectDescription e) {
                EObject _eObjectOrProxy = e.getEObjectOrProxy();
                return EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
            }
        };
        Iterable scopedElements = IterableExtensions.map((Iterable)_elements, (Functions.Function1)_function);
        _xblockexpression = Scopes.scopeFor((Iterable)scopedElements, (IScope)scope);
        return _xblockexpression;
    }

    public MickeyModel getMickeyModelInScope(final EObject context) {
        boolean _greaterThan;
        List files = null;
        boolean _isStandalone = this.mickeyEnvironment.isStandalone();
        String _plus = "[Get Model In Scope] Standalone: " + Boolean.valueOf(_isStandalone);
        LOG.debug((Object)_plus);
        boolean _isStandalone_1 = this.mickeyEnvironment.isStandalone();
        if (_isStandalone_1) {
            List _map;
            Resource _eResource = context.eResource();
            ResourceSet _resourceSet = _eResource.getResourceSet();
            EList _resources = _resourceSet.getResources();
            Functions.Function1<Resource, MickeyFile> _function = new Functions.Function1<Resource, MickeyFile>(){

                public MickeyFile apply(Resource it) {
                    TreeIterator _allContents = it.getAllContents();
                    EObject _head = (EObject)IteratorExtensions.head((Iterator)_allContents);
                    return (MickeyFile)_head;
                }
            };
            files = _map = ListExtensions.map((List)_resources, (Functions.Function1)_function);
        } else {
            List _list;
            Iterable _exportedObjectsByType = this.resourceDescriptions.getExportedObjectsByType(MickeyLangPackage.Literals.MICKEY_FILE);
            Functions.Function1<IEObjectDescription, MickeyFile> _function_1 = new Functions.Function1<IEObjectDescription, MickeyFile>(){

                public MickeyFile apply(IEObjectDescription e) {
                    EObject _eObjectOrProxy = e.getEObjectOrProxy();
                    EObject _resolve = EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)context);
                    return (MickeyFile)_resolve;
                }
            };
            Iterable _map_1 = IterableExtensions.map((Iterable)_exportedObjectsByType, (Functions.Function1)_function_1);
            files = _list = IterableExtensions.toList((Iterable)_map_1);
        }
        int _size = files.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            int _size_1 = files.size();
            String _plus_1 = "[Get Model In Scope] Files: " + Integer.valueOf(_size_1);
            LOG.debug((Object)_plus_1);
            MigrationBlock migration = ModelUtil.getAncestorOfType(context, MigrationBlock.class);
            try {
                return this.assembler.assemble(files, migration);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    LOG.debug((Object)"[Get Model In Scope] Failed with error ", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        LOG.debug((Object)"[Get Model In Scope] Failed ");
        return null;
    }

    public IScope scopeTableColumns(EObject context, String dbName, final String tableName) {
        boolean _notEquals;
        MickeyModel mickeyModel = this.getMickeyModelInScope(context);
        boolean bl = _notEquals = !Objects.equal((Object)mickeyModel, null);
        if (_notEquals) {
            boolean _equals_1;
            MickeyDatabaseModel _get = mickeyModel.databases.get(dbName);
            SqliteDatabaseSnapshot _snapshot = _get.getSnapshot();
            TableDefinition definition = _snapshot.getTableDefinition(tableName);
            boolean _equals = Objects.equal((Object)definition, null);
            if (_equals) {
                MickeyDatabaseModel _get_1 = mickeyModel.databases.get(dbName);
                Functions.Function1<CreateTableStatement, Boolean> _function = new Functions.Function1<CreateTableStatement, Boolean>(){

                    public Boolean apply(CreateTableStatement it) {
                        String _name = it.getName();
                        return _name.equals(tableName);
                    }
                };
                CreateTableStatement _findFirst = (CreateTableStatement)IterableExtensions.findFirst(_get_1.initTables, (Functions.Function1)_function);
                definition = _findFirst;
            }
            if (_equals_1 = Objects.equal((Object)definition, null)) {
                MickeyDatabaseModel _get_2 = mickeyModel.databases.get(dbName);
                Functions.Function1<CreateViewStatement, Boolean> _function_1 = new Functions.Function1<CreateViewStatement, Boolean>(){

                    public Boolean apply(CreateViewStatement it) {
                        String _name = it.getName();
                        return _name.equals(tableName);
                    }
                };
                CreateViewStatement _findFirst_1 = (CreateViewStatement)IterableExtensions.findFirst(_get_2.initViews, (Functions.Function1)_function_1);
                definition = _findFirst_1;
            }
            if (definition instanceof CreateTableStatement) {
                CreateTableStatement table = (CreateTableStatement)definition;
                EList<ColumnSource> _columnDefs = table.getColumnDefs();
                IScope columnScope = Scopes.scopeFor(_columnDefs, (IScope)IScope.NULLSCOPE);
                return columnScope;
            }
            CreateViewStatement view = (CreateViewStatement)definition;
            ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(view);
            IScope columnScope_1 = Scopes.scopeFor(_viewResultColumns, (IScope)IScope.NULLSCOPE);
            return columnScope_1;
        }
        return IScope.NULLSCOPE;
    }

    public IScope scope_ContentUriParamSegment_param(ContentUriParamSegment context, EReference ref) {
        String _featureNodeText;
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        String tableName = "";
        ActionStatement action = ModelUtil.getAncestorOfType(context, ActionStatement.class);
        tableName = _featureNodeText = ModelUtil.getFeatureNodeText(action, MickeyLangPackage.Literals.ACTION_STATEMENT__TYPE);
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }

    public IScope scope_ContentUriQueryParam_column(ContentUriQueryParam context, EReference ref) {
        String _featureNodeText;
        IScope _xblockexpression = null;
        MickeyFile _model = ModelUtil.getModel(context);
        String dbName = _model.getDatabaseName();
        String tableName = "";
        ActionStatement action = ModelUtil.getAncestorOfType(context, ActionStatement.class);
        tableName = _featureNodeText = ModelUtil.getFeatureNodeText(action, MickeyLangPackage.Literals.ACTION_STATEMENT__TYPE);
        _xblockexpression = this.scopeTableColumns(context, dbName, tableName);
        return _xblockexpression;
    }
}

