/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.mickeyLang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConflictResolution implements Enumerator
{
    ROLLBACK(0, "rollback", "rollback"),
    ABORT(1, "abort", "abort"),
    FAIL(2, "fail", "fail"),
    IGNORE(3, "ignore", "ignore"),
    REPLACE(4, "replace", "replace");

    public static final int ROLLBACK_VALUE = 0;
    public static final int ABORT_VALUE = 1;
    public static final int FAIL_VALUE = 2;
    public static final int IGNORE_VALUE = 3;
    public static final int REPLACE_VALUE = 4;
    private static final ConflictResolution[] VALUES_ARRAY;
    public static final List<ConflictResolution> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ConflictResolution get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ConflictResolution result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ConflictResolution getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ConflictResolution result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ConflictResolution get(int value) {
        switch (value) {
            case 0: {
                return ROLLBACK;
            }
            case 1: {
                return ABORT;
            }
            case 2: {
                return FAIL;
            }
            case 3: {
                return IGNORE;
            }
            case 4: {
                return REPLACE;
            }
        }
        return null;
    }

    private ConflictResolution(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ConflictResolution[]{ROLLBACK, ABORT, FAIL, IGNORE, REPLACE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

