/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.inject.Inject;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.SqliteDatabaseStatementGenerator;
import com.justeat.mickeydb.mickeyLang.DDLStatement;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class SqliteMigrationGenerator {
    @Inject
    @Extension
    private SqliteDatabaseStatementGenerator _sqliteDatabaseStatementGenerator;

    public CharSequence generate(MickeyFile model, String packageName, String databaseName, MigrationBlock migration) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)packageName, "");
        _builder.append((Object)".migrations;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import android.database.sqlite.SQLiteDatabase;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.Migration;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class Default");
        String _pascalize = Strings.pascalize(databaseName);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)"Migration");
        String _name = migration.getName();
        String _pascalize_1 = Strings.pascalize(_name);
        _builder.append((Object)_pascalize_1, "");
        _builder.append((Object)" extends Migration {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onBeforeUp(SQLiteDatabase db) {}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void up(SQLiteDatabase db) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<DDLStatement> _statements = migration.getStatements();
        CharSequence _generateStatements = this._sqliteDatabaseStatementGenerator.generateStatements((Iterable<DDLStatement>)_statements);
        _builder.append((Object)_generateStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onAfterUp(SQLiteDatabase db) {}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

