/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.common.base.Objects;
import com.justeat.mickeydb.ContentUriInfo;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.ActionStatement;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnType;
import com.justeat.mickeydb.mickeyLang.ContentNotificationUri;
import com.justeat.mickeydb.mickeyLang.ContentUri;
import com.justeat.mickeydb.mickeyLang.ContentUriParamSegment;
import com.justeat.mickeydb.mickeyLang.ContentUriQueryParam;
import com.justeat.mickeydb.mickeyLang.ContentUriSegment;
import com.justeat.mickeydb.mickeyLang.NotifyContentUri;
import com.justeat.mickeydb.mickeyLang.NotifyContentUriParamSegment;
import com.justeat.mickeydb.mickeyLang.NotifyContentUriSegment;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class CustomActionsGenerator {
    public CharSequence generate(MickeyDatabaseModel model, ContentUriInfo content) {
        boolean _greaterThan;
        ActionStatement _action_3;
        EList<ContentUriQueryParam> _params;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _notEquals_1;
        Functions.Function1<ContentUriSegment, Boolean> _function;
        ActionStatement _action_1;
        ContentUri _uri;
        EList<ContentUriSegment> _segments;
        Iterable _filter;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        SqliteDatabaseSnapshot snapshot = model.getSnapshot();
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        ActionStatement _action = content.getAction();
        boolean bl = _notEquals = !Objects.equal((Object)_action, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = IterableExtensions.isEmpty((Iterable)(_filter = IterableExtensions.filter(_segments = (_uri = (_action_1 = content.getAction()).getUri()).getSegments(), (Functions.Function1)(_function = new Functions.Function1<ContentUriSegment, Boolean>(){

            public Boolean apply(ContentUriSegment it) {
                return it instanceof ContentUriParamSegment;
            }
        }))))));
        boolean hasSlugParams = _and;
        _builder.newLineIfNotEmpty();
        boolean _and_1 = false;
        ActionStatement _action_2 = content.getAction();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_action_2, null);
        _and_1 = !_notEquals_1 ? false : (_not_1 = !(_isEmpty_1 = (_params = (_action_3 = content.getAction()).getParams()).isEmpty()));
        boolean hasQueryParams = _and_1;
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".actions;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.ActiveRecordFactory;");
        _builder.newLine();
        _builder.append((Object)"import android.content.ContentValues;");
        _builder.newLine();
        _builder.append((Object)"import android.database.sqlite.SQLiteDatabase;");
        _builder.newLine();
        _builder.append((Object)"import android.net.Uri;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.CustomActions;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.MickeyContentProvider;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.Query;");
        _builder.newLine();
        _builder.append((Object)"import ");
        String _packageName_1 = model.getPackageName();
        _builder.append((Object)_packageName_1, "");
        _builder.append((Object)".");
        String _databaseName = model.getDatabaseName();
        _builder.append((Object)_databaseName, "");
        _builder.append((Object)"Contract;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _packageName_2 = model.getPackageName();
        _builder.append((Object)_packageName_2, "");
        _builder.append((Object)".");
        String _databaseName_1 = model.getDatabaseName();
        _builder.append((Object)_databaseName_1, "");
        _builder.append((Object)"Contract.");
        String _type = content.getType();
        String _pascalize = Strings.pascalize(_type);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _packageName_3 = model.getPackageName();
        _builder.append((Object)_packageName_3, "");
        _builder.append((Object)".Abstract");
        String _databaseName_2 = model.getDatabaseName();
        _builder.append((Object)_databaseName_2, "");
        _builder.append((Object)"OpenHelper.Sources;");
        _builder.newLineIfNotEmpty();
        boolean _isSupportsActiveRecord = content.isSupportsActiveRecord();
        if (_isSupportsActiveRecord) {
            _builder.append((Object)"import ");
            String _packageName_4 = model.getPackageName();
            _builder.append((Object)_packageName_4, "");
            _builder.append((Object)".");
            String _type_1 = content.getType();
            String _pascalize_1 = Strings.pascalize(_type_1);
            _builder.append((Object)_pascalize_1, "");
            _builder.append((Object)"Record;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Set;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.util.Uris;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = content.getName();
        String _pascalize_2 = Strings.pascalize(_name);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"Actions extends CustomActions {");
        _builder.newLineIfNotEmpty();
        boolean _or = false;
        if (hasQueryParams || hasSlugParams) {
            _or = true;
        } else {
            boolean _isSupportsActiveRecord_1;
            boolean _and_2 = false;
            boolean _isDirectory = content.isDirectory();
            boolean _not_2 = !_isDirectory;
            _and_2 = !_not_2 ? false : (_isSupportsActiveRecord_1 = content.isSupportsActiveRecord());
            _or = _and_2;
        }
        if (_or) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void addQueryExpressionsFromUriSegmentParams(Uri uri, Query query) {");
            _builder.newLine();
            boolean _isUserDefined = content.isUserDefined();
            if (_isUserDefined) {
                if (hasSlugParams) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"List<String> segments = uri.getPathSegments();");
                    _builder.newLine();
                }
                if (hasQueryParams) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"Set<String> queryKeys = Uris.getQueryParameterNames(uri);");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _createSlugVariables = this.createSlugVariables(content);
                _builder.append((Object)_createSlugVariables, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _createQueryParamVariables = this.createQueryParamVariables(content);
                _builder.append((Object)_createQueryParamVariables, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _createQueryStatements = this.createQueryStatements(content);
                _builder.append((Object)_createQueryStatements, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _isSupportsActiveRecord_2;
                boolean _and_3 = false;
                boolean _isDirectory_1 = content.isDirectory();
                boolean _not_3 = !_isDirectory_1;
                _and_3 = !_not_3 ? false : (_isSupportsActiveRecord_2 = content.isSupportsActiveRecord());
                if (_and_3) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"List<String> segments = uri.getPathSegments();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"long _idSlug = Long.parseLong(segments.get(1));");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"query.expr(");
                    String _type_2 = content.getType();
                    String _pascalize_3 = Strings.pascalize(_type_2);
                    _builder.append((Object)_pascalize_3, "\t\t");
                    _builder.append((Object)"._ID, Query.Op.EQ, _idSlug);");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getSourceName() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Sources.");
        String _type_3 = content.getType();
        String _underscore = Strings.underscore(_type_3);
        String _upperCase = _underscore.toUpperCase();
        _builder.append((Object)_upperCase, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ActiveRecordFactory<?> getActiveRecordFactory() {");
        _builder.newLine();
        boolean _isSupportsActiveRecord_3 = content.isSupportsActiveRecord();
        if (_isSupportsActiveRecord_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ");
            String _type_4 = content.getType();
            String _pascalize_4 = Strings.pascalize(_type_4);
            _builder.append((Object)_pascalize_4, "\t\t");
            _builder.append((Object)"Record.getFactory();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"throw new RuntimeException(\"");
            String _type_5 = content.getType();
            _builder.append((Object)_type_5, "\t\t");
            _builder.append((Object)" does not support active record, you may need to add an _id to that table\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<Uri> getNotifyUris(MickeyContentProvider provider, Uri uri) {");
        _builder.newLine();
        ActionStatement _action_4 = content.getAction();
        EList<ContentNotificationUri> _notifications = null;
        if (_action_4 != null) {
            _notifications = _action_4.getNotifications();
        }
        int _size = 0;
        if (_notifications != null) {
            _size = _notifications.size();
        }
        boolean bl3 = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"ArrayList<Uri> notifyUris = new ArrayList<Uri>();");
            _builder.newLine();
            if (hasSlugParams) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"List<String> segments = uri.getPathSegments();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CharSequence _createStringSlugVariables = this.createStringSlugVariables(content);
                _builder.append((Object)_createStringSlugVariables, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            ActionStatement _action_5 = content.getAction();
            EList<ContentNotificationUri> _notifications_1 = _action_5.getNotifications();
            for (ContentNotificationUri notificationUri : _notifications_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"notifyUris.add(");
                CharSequence _createNotifyStatement = this.createNotifyStatement(model, content, notificationUri);
                _builder.append((Object)_createNotifyStatement, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return notifyUris;");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return null;");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (hasSlugParams) {
            boolean _notEquals_2;
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void addContentValuesFromUri(MickeyContentProvider provider, Uri uri, ContentValues values) {");
            _builder.newLine();
            ActionStatement _action_6 = content.getAction();
            boolean bl4 = _notEquals_2 = !Objects.equal((Object)_action_6, null);
            if (_notEquals_2) {
                if (hasSlugParams) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"List<String> segments = uri.getPathSegments();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _createSlugVariables_1 = this.createSlugVariables(content);
                    _builder.append((Object)_createSlugVariables_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                ActionStatement _action_7 = content.getAction();
                ContentUri _uri_1 = _action_7.getUri();
                EList<ContentUriSegment> _segments_1 = _uri_1.getSegments();
                for (ContentUriSegment seg : _segments_1) {
                    if (!(seg instanceof ContentUriParamSegment)) continue;
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    ContentUriParamSegment paramSeg = (ContentUriParamSegment)seg;
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"values.put(");
                    ActionStatement _action_8 = content.getAction();
                    TableDefinition _type_6 = _action_8.getType();
                    String _name_1 = _type_6.getName();
                    String _pascalize_5 = Strings.pascalize(_name_1);
                    _builder.append((Object)_pascalize_5, "\t\t");
                    _builder.append((Object)".");
                    ColumnSource _param = paramSeg.getParam();
                    String _name_2 = _param.getName();
                    String _underscore_1 = Strings.underscore(_name_2);
                    String _upperCase_1 = _underscore_1.toUpperCase();
                    _builder.append((Object)_upperCase_1, "\t\t");
                    _builder.append((Object)", ");
                    ColumnSource _param_1 = paramSeg.getParam();
                    String _name_3 = _param_1.getName();
                    String _camelize = Strings.camelize(_name_3);
                    _builder.append((Object)_camelize, "\t\t");
                    _builder.append((Object)"Slug);");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createNotifyStatement(MickeyDatabaseModel model, ContentUriInfo info, ContentNotificationUri uri) {
        StringConcatenation _builder = new StringConcatenation();
        String _databaseName = model.getDatabaseName();
        _builder.append((Object)_databaseName, "");
        _builder.append((Object)"Contract.BASE_CONTENT_URI");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".buildUpon()");
        _builder.newLine();
        NotifyContentUri _uri = uri.getUri();
        EList<NotifyContentUriSegment> _segments = _uri.getSegments();
        for (NotifyContentUriSegment seg : _segments) {
            if (seg instanceof NotifyContentUriParamSegment) {
                _builder.append((Object)"\t");
                _builder.append((Object)".appendPath(");
                String _slugVariableForNotifyUriSegment = this.getSlugVariableForNotifyUriSegment(seg, info);
                _builder.append((Object)_slugVariableForNotifyUriSegment, "\t");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            _builder.append((Object)".appendPath(\"");
            String _name = seg.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)"\")");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)".build()");
        _builder.newLine();
        return _builder;
    }

    public String getSlugVariableForNotifyUriSegment(final NotifyContentUriSegment segment, ContentUriInfo info) {
        Functions.Function1<ContentUriSegment, Boolean> _function;
        ActionStatement _action = info.getAction();
        ContentUri _uri = _action.getUri();
        EList<ContentUriSegment> _segments = _uri.getSegments();
        boolean _exists = IterableExtensions.exists(_segments, (Functions.Function1)(_function = new Functions.Function1<ContentUriSegment, Boolean>(){

            public Boolean apply(ContentUriSegment it) {
                boolean _and = false;
                if (!(it instanceof ContentUriParamSegment)) {
                    _and = false;
                } else {
                    boolean _equals;
                    String _name = segment.getName();
                    ColumnSource _param = ((ContentUriParamSegment)it).getParam();
                    String _name_1 = _param.getName();
                    _and = _equals = _name.equals(_name_1);
                }
                return _and;
            }
        }));
        if (_exists) {
            String _name = segment.getName();
            String _camelize = Strings.camelize(_name);
            return _camelize + "Slug";
        }
        return "\"NO-MATCH\"";
    }

    public CharSequence createQueryStatements(ContentUriInfo content) {
        StringConcatenation _builder = new StringConcatenation();
        ActionStatement _action = content.getAction();
        ContentUri _uri = _action.getUri();
        EList<ContentUriSegment> _segments = _uri.getSegments();
        Iterable _indexed = IterableExtensions.indexed(_segments);
        for (Pair entry : _indexed) {
            boolean _notEquals;
            _builder.newLineIfNotEmpty();
            ContentUriSegment _value = (ContentUriSegment)entry.getValue();
            if (!(_value instanceof ContentUriParamSegment)) continue;
            ContentUriSegment _value_1 = (ContentUriSegment)entry.getValue();
            ContentUriParamSegment param = (ContentUriParamSegment)_value_1;
            _builder.newLineIfNotEmpty();
            ColumnSource _param = param.getParam();
            ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
            boolean bl = _notEquals = !Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
            if (_notEquals) {
                _builder.append((Object)"query.expr(");
                String _type = content.getType();
                String _pascalize = Strings.pascalize(_type);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)".");
                ColumnSource _param_1 = param.getParam();
                String _name = _param_1.getName();
                String _underscore = Strings.underscore(_name);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "");
                _builder.append((Object)", Query.Op.EQ, ");
                ColumnSource _param_2 = param.getParam();
                String _name_1 = _param_2.getName();
                String _camelize = Strings.camelize(_name_1);
                _builder.append((Object)_camelize, "");
                _builder.append((Object)"Slug);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"query.expr(\"cast(\" + ");
            String _type_1 = content.getType();
            String _pascalize_1 = Strings.pascalize(_type_1);
            _builder.append((Object)_pascalize_1, "");
            _builder.append((Object)".");
            ColumnSource _param_3 = param.getParam();
            String _name_2 = _param_3.getName();
            String _underscore_1 = Strings.underscore(_name_2);
            String _upperCase_1 = _underscore_1.toUpperCase();
            _builder.append((Object)_upperCase_1, "");
            _builder.append((Object)" + \" as text)\", Query.Op.EQ, ");
            ColumnSource _param_4 = param.getParam();
            String _name_3 = _param_4.getName();
            String _camelize_1 = Strings.camelize(_name_3);
            _builder.append((Object)_camelize_1, "");
            _builder.append((Object)"Slug);");
            _builder.newLineIfNotEmpty();
        }
        ActionStatement _action_1 = content.getAction();
        EList<ContentUriQueryParam> _params = _action_1.getParams();
        for (ContentUriQueryParam queryParam : _params) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if(queryKeys.contains(");
            String _type_2 = content.getType();
            String _pascalize_2 = Strings.pascalize(_type_2);
            _builder.append((Object)_pascalize_2, "\t\t");
            _builder.append((Object)".");
            ColumnSource _column = queryParam.getColumn();
            String _name_4 = _column.getName();
            String _underscore_2 = Strings.underscore(_name_4);
            String _upperCase_2 = _underscore_2.toUpperCase();
            _builder.append((Object)_upperCase_2, "\t\t");
            _builder.append((Object)")) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"query.expr(");
            String _type_3 = content.getType();
            String _pascalize_3 = Strings.pascalize(_type_3);
            _builder.append((Object)_pascalize_3, "\t\t\t");
            _builder.append((Object)".");
            ColumnSource _column_1 = queryParam.getColumn();
            String _name_5 = _column_1.getName();
            String _underscore_3 = Strings.underscore(_name_5);
            String _upperCase_3 = _underscore_3.toUpperCase();
            _builder.append((Object)_upperCase_3, "\t\t\t");
            _builder.append((Object)", ");
            CharSequence _generateOperator = this.generateOperator(queryParam);
            _builder.append((Object)_generateOperator, "\t\t\t");
            _builder.append((Object)", ");
            ColumnSource _column_2 = queryParam.getColumn();
            String _name_6 = _column_2.getName();
            String _camelize_2 = Strings.camelize(_name_6);
            _builder.append((Object)_camelize_2, "\t\t\t");
            _builder.append((Object)"QueryParam);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
        }
        return _builder;
    }

    public CharSequence createQueryParamVariables(ContentUriInfo content) {
        StringConcatenation _builder = new StringConcatenation();
        ActionStatement _action = content.getAction();
        EList<ContentUriQueryParam> _params = _action.getParams();
        for (ContentUriQueryParam queryParam : _params) {
            _builder.newLineIfNotEmpty();
            ColumnSource _column = queryParam.getColumn();
            ColumnType columnType = ModelUtil.getInferredColumnType(_column);
            _builder.newLineIfNotEmpty();
            boolean _equals = Objects.equal((Object)((Object)columnType), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                ColumnSource _column_1 = queryParam.getColumn();
                ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_column_1);
                String _javaTypeName = ModelUtil.toJavaTypeName(_inferredColumnType);
                _builder.append((Object)_javaTypeName, "");
                _builder.append((Object)" ");
                ColumnSource _column_2 = queryParam.getColumn();
                String _name = _column_2.getName();
                String _camelize = Strings.camelize(_name);
                _builder.append((Object)_camelize, "");
                _builder.append((Object)"QueryParam = Uris.getBooleanQueryParamOrDefault(uri, queryKeys, ");
                String _type = content.getType();
                String _pascalize = Strings.pascalize(_type);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)".");
                ColumnSource _column_3 = queryParam.getColumn();
                String _name_1 = _column_3.getName();
                String _underscore = Strings.underscore(_name_1);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _equals_1 = Objects.equal((Object)((Object)columnType), (Object)((Object)ColumnType.INTEGER));
            if (_equals_1) {
                ColumnSource _column_4 = queryParam.getColumn();
                ColumnType _inferredColumnType_1 = ModelUtil.getInferredColumnType(_column_4);
                String _javaTypeName_1 = ModelUtil.toJavaTypeName(_inferredColumnType_1);
                _builder.append((Object)_javaTypeName_1, "");
                _builder.append((Object)" ");
                ColumnSource _column_5 = queryParam.getColumn();
                String _name_2 = _column_5.getName();
                String _camelize_1 = Strings.camelize(_name_2);
                _builder.append((Object)_camelize_1, "");
                _builder.append((Object)"QueryParam = Uris.getIntQueryParamOrDefault(uri, queryKeys, ");
                String _type_1 = content.getType();
                String _pascalize_1 = Strings.pascalize(_type_1);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)".");
                ColumnSource _column_6 = queryParam.getColumn();
                String _name_3 = _column_6.getName();
                String _underscore_1 = Strings.underscore(_name_3);
                String _upperCase_1 = _underscore_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _equals_2 = Objects.equal((Object)((Object)columnType), (Object)((Object)ColumnType.REAL));
            if (_equals_2) {
                ColumnSource _column_7 = queryParam.getColumn();
                ColumnType _inferredColumnType_2 = ModelUtil.getInferredColumnType(_column_7);
                String _javaTypeName_2 = ModelUtil.toJavaTypeName(_inferredColumnType_2);
                _builder.append((Object)_javaTypeName_2, "");
                _builder.append((Object)" ");
                ColumnSource _column_8 = queryParam.getColumn();
                String _name_4 = _column_8.getName();
                String _camelize_2 = Strings.camelize(_name_4);
                _builder.append((Object)_camelize_2, "");
                _builder.append((Object)"QueryParam = Uris.getDoubleQueryParamOrDefault(uri, queryKeys, ");
                String _type_2 = content.getType();
                String _pascalize_2 = Strings.pascalize(_type_2);
                _builder.append((Object)_pascalize_2, "");
                _builder.append((Object)".");
                ColumnSource _column_9 = queryParam.getColumn();
                String _name_5 = _column_9.getName();
                String _underscore_2 = Strings.underscore(_name_5);
                String _upperCase_2 = _underscore_2.toUpperCase();
                _builder.append((Object)_upperCase_2, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ColumnSource _column_10 = queryParam.getColumn();
            ColumnType _inferredColumnType_3 = ModelUtil.getInferredColumnType(_column_10);
            String _javaTypeName_3 = ModelUtil.toJavaTypeName(_inferredColumnType_3);
            _builder.append((Object)_javaTypeName_3, "");
            _builder.append((Object)" ");
            ColumnSource _column_11 = queryParam.getColumn();
            String _name_6 = _column_11.getName();
            String _camelize_3 = Strings.camelize(_name_6);
            _builder.append((Object)_camelize_3, "");
            _builder.append((Object)"QueryParam = Uris.getStringQueryParamOrDefault(uri, queryKeys, ");
            String _type_3 = content.getType();
            String _pascalize_3 = Strings.pascalize(_type_3);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)".");
            ColumnSource _column_12 = queryParam.getColumn();
            String _name_7 = _column_12.getName();
            String _underscore_3 = Strings.underscore(_name_7);
            String _upperCase_3 = _underscore_3.toUpperCase();
            _builder.append((Object)_upperCase_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence createSlugVariables(ContentUriInfo content) {
        StringConcatenation _builder = new StringConcatenation();
        ActionStatement _action = content.getAction();
        ContentUri _uri = _action.getUri();
        EList<ContentUriSegment> _segments = _uri.getSegments();
        Iterable _indexed = IterableExtensions.indexed(_segments);
        for (Pair entry : _indexed) {
            boolean _notEquals;
            _builder.newLineIfNotEmpty();
            ContentUriSegment _value = (ContentUriSegment)entry.getValue();
            if (!(_value instanceof ContentUriParamSegment)) continue;
            ContentUriSegment _value_1 = (ContentUriSegment)entry.getValue();
            ContentUriParamSegment param = (ContentUriParamSegment)_value_1;
            _builder.newLineIfNotEmpty();
            ColumnSource _param = param.getParam();
            ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
            boolean bl = _notEquals = !Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
            if (_notEquals) {
                _builder.append((Object)"long ");
                ColumnSource _param_1 = param.getParam();
                String _name = _param_1.getName();
                String _camelize = Strings.camelize(_name);
                _builder.append((Object)_camelize, "");
                _builder.append((Object)"Slug = Long.parseLong(segments.get(");
                Integer _key = (Integer)entry.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"String ");
            ColumnSource _param_2 = param.getParam();
            String _name_1 = _param_2.getName();
            String _camelize_1 = Strings.camelize(_name_1);
            _builder.append((Object)_camelize_1, "");
            _builder.append((Object)"Slug = segments.get(");
            Integer _key_1 = (Integer)entry.getKey();
            _builder.append((Object)_key_1, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence createStringSlugVariables(ContentUriInfo content) {
        StringConcatenation _builder = new StringConcatenation();
        ActionStatement _action = content.getAction();
        ContentUri _uri = _action.getUri();
        EList<ContentUriSegment> _segments = _uri.getSegments();
        Iterable _indexed = IterableExtensions.indexed(_segments);
        for (Pair entry : _indexed) {
            _builder.newLineIfNotEmpty();
            ContentUriSegment _value = (ContentUriSegment)entry.getValue();
            if (!(_value instanceof ContentUriParamSegment)) continue;
            ContentUriSegment _value_1 = (ContentUriSegment)entry.getValue();
            ContentUriParamSegment param = (ContentUriParamSegment)_value_1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"String ");
            ColumnSource _param = param.getParam();
            String _name = _param.getName();
            String _camelize = Strings.camelize(_name);
            _builder.append((Object)_camelize, "");
            _builder.append((Object)"Slug = segments.get(");
            Integer _key = (Integer)entry.getKey();
            _builder.append((Object)_key, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateOperator(ContentUriQueryParam param) {
        boolean _isLike = param.isLike();
        if (_isLike) {
            return "Query.Op.LIKE";
        }
        return "Query.Op.EQ";
    }
}

