/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.common.base.Objects;
import com.justeat.mickeydb.ContentUriInfo;
import com.justeat.mickeydb.ContentUris;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.ActionStatement;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnType;
import com.justeat.mickeydb.mickeyLang.ContentUri;
import com.justeat.mickeydb.mickeyLang.ContentUriParamSegment;
import com.justeat.mickeydb.mickeyLang.ContentUriSegment;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ContentProviderGenerator {
    public CharSequence generate(MickeyDatabaseModel model, ContentUris content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t\t");
        SqliteDatabaseSnapshot snapshot = model.getSnapshot();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import android.content.Context;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import android.content.UriMatcher;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import android.net.Uri;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import java.util.Set;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import com.justeat.mickeydb.MickeyContentProvider;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import com.justeat.mickeydb.MickeyOpenHelper;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import com.justeat.mickeydb.DefaultContentProviderActions;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"import com.justeat.mickeydb.ContentProviderActions;");
        _builder.newLine();
        for (ContentUriInfo uri : content.uris) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"import ");
            String _packageName_1 = model.getPackageName();
            _builder.append((Object)_packageName_1, "\t\t");
            _builder.append((Object)".actions.");
            String _name = uri.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "\t\t");
            _builder.append((Object)"Actions;\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public abstract class Abstract");
        String _databaseName = model.getDatabaseName();
        String _pascalize_1 = Strings.pascalize(_databaseName);
        _builder.append((Object)_pascalize_1, "\t\t");
        _builder.append((Object)"ContentProvider extends MickeyContentProvider {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        int counter = -1;
        _builder.newLineIfNotEmpty();
        for (ContentUriInfo uri_1 : content.uris) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"public static final int ");
            String _id = uri_1.getId();
            _builder.append((Object)_id, "\t\t\t");
            _builder.append((Object)" = ");
            _builder.append((Object)(++counter), "\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"public static final int NUM_URI_MATCHERS = ");
        int _size = content.uris.size();
        _builder.append((Object)_size, "\t\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"public Abstract");
        String _databaseName_1 = model.getDatabaseName();
        String _pascalize_2 = Strings.pascalize(_databaseName_1);
        _builder.append((Object)_pascalize_2, "\t\t\t");
        _builder.append((Object)"ContentProvider(boolean debug) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"super(debug);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"public Abstract");
        String _databaseName_2 = model.getDatabaseName();
        String _pascalize_3 = Strings.pascalize(_databaseName_2);
        _builder.append((Object)_pascalize_3, "\t\t\t");
        _builder.append((Object)"ContentProvider() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"super(false);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"protected UriMatcher createUriMatcher() {");
        _builder.newLine();
        _builder.append((Object)"\t\t        ");
        _builder.append((Object)"final UriMatcher matcher = new UriMatcher(UriMatcher.NO_MATCH);");
        _builder.newLine();
        _builder.append((Object)"\t\t        ");
        _builder.append((Object)"final String authority = ");
        String _databaseName_3 = model.getDatabaseName();
        String _pascalize_4 = Strings.pascalize(_databaseName_3);
        _builder.append((Object)_pascalize_4, "\t\t        ");
        _builder.append((Object)"Contract.CONTENT_AUTHORITY;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        for (ContentUriInfo uri_2 : content.uris) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"matcher.addURI(authority, \"");
            String _pathPattern = uri_2.getPathPattern();
            _builder.append((Object)_pathPattern, "\t\t\t\t");
            _builder.append((Object)"\", ");
            String _id_1 = uri_2.getId();
            _builder.append((Object)_id_1, "\t\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t        ");
        _builder.append((Object)"return matcher;");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"protected String[] createContentTypes() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"String[] contentTypes = new String[NUM_URI_MATCHERS];");
        _builder.newLine();
        _builder.newLine();
        for (ContentUriInfo uri_3 : content.uris) {
            boolean _isDirectory = uri_3.isDirectory();
            if (_isDirectory) {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"contentTypes[");
                String _id_2 = uri_3.getId();
                _builder.append((Object)_id_2, "\t\t\t\t");
                _builder.append((Object)"] = ");
                String _databaseName_4 = model.getDatabaseName();
                String _pascalize_5 = Strings.pascalize(_databaseName_4);
                _builder.append((Object)_pascalize_5, "\t\t\t\t");
                _builder.append((Object)"Contract.");
                String _type = uri_3.getType();
                String _pascalize_6 = Strings.pascalize(_type);
                _builder.append((Object)_pascalize_6, "\t\t\t\t");
                _builder.append((Object)".CONTENT_TYPE;");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"contentTypes[");
            String _id_3 = uri_3.getId();
            _builder.append((Object)_id_3, "\t\t\t\t");
            _builder.append((Object)"] = ");
            String _databaseName_5 = model.getDatabaseName();
            String _pascalize_7 = Strings.pascalize(_databaseName_5);
            _builder.append((Object)_pascalize_7, "\t\t\t\t");
            _builder.append((Object)"Contract.");
            String _type_1 = uri_3.getType();
            String _pascalize_8 = Strings.pascalize(_type_1);
            _builder.append((Object)_pascalize_8, "\t\t\t\t");
            _builder.append((Object)".ITEM_CONTENT_TYPE;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return contentTypes;");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"protected MickeyOpenHelper createOpenHelper(Context context) {");
        _builder.newLine();
        _builder.append((Object)"\t\t        ");
        _builder.append((Object)"return new ");
        String _databaseName_6 = model.getDatabaseName();
        String _pascalize_9 = Strings.pascalize(_databaseName_6);
        _builder.append((Object)_pascalize_9, "\t\t        ");
        _builder.append((Object)"OpenHelper(context);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"protected Set<Uri> getRelatedUris(Uri uri) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return ");
        String _databaseName_7 = model.getDatabaseName();
        String _pascalize_10 = Strings.pascalize(_databaseName_7);
        _builder.append((Object)_pascalize_10, "\t\t\t\t");
        _builder.append((Object)"Contract.REFERENCING_VIEWS.get(uri);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"protected ContentProviderActions createActions(int id) {");
        _builder.newLine();
        _builder.append((Object)"\t\t    \t");
        _builder.append((Object)"switch(id) {");
        _builder.newLine();
        for (ContentUriInfo uri_4 : content.uris) {
            _builder.append((Object)"\t\t    \t\t");
            _builder.append((Object)"case ");
            String _id_4 = uri_4.getId();
            _builder.append((Object)_id_4, "\t\t    \t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t    \t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return create");
            String _name_1 = uri_4.getName();
            String _pascalize_11 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_11, "\t\t    \t\t\t");
            _builder.append((Object)"Actions();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new UnsupportedOperationException(\"Unknown id: \" + id);");
        _builder.newLine();
        _builder.append((Object)"\t\t    \t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.newLine();
        for (ContentUriInfo uri_5 : content.uris) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"protected ContentProviderActions create");
            String _name_2 = uri_5.getName();
            String _pascalize_12 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_12, "\t\t\t");
            _builder.append((Object)"Actions() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return new ");
            String _name_3 = uri_5.getName();
            String _pascalize_13 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_13, "\t\t\t\t");
            _builder.append((Object)"Actions();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}\t\t\t\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String asString(ActionStatement action) {
        StringBuilder builder = new StringBuilder();
        TableDefinition _type = action.getType();
        builder.append(_type);
        ContentUri _uri = action.getUri();
        EList<ContentUriSegment> _segments = _uri.getSegments();
        for (ContentUriSegment seg : _segments) {
            builder.append("/");
            if (seg instanceof ContentUriParamSegment) {
                ColumnSource _param = ((ContentUriParamSegment)seg).getParam();
                ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
                boolean _equals = Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
                if (_equals) {
                    builder.append("*");
                    continue;
                }
                builder.append("#");
                continue;
            }
            String _name = seg.getName();
            builder.append(_name);
        }
        return builder.toString();
    }

    public String generateContentTypeConstantReference(ActionStatement action, String databaseName) {
        boolean _isUnique = action.isUnique();
        if (_isUnique) {
            String _pascalize = Strings.pascalize(databaseName);
            String _plus = _pascalize + "Contract.";
            TableDefinition _type = action.getType();
            String _name = _type.getName();
            String _pascalize_1 = Strings.pascalize(_name);
            String _plus_1 = _plus + _pascalize_1;
            return _plus_1 + ".ITEM_CONTENT_TYPE";
        }
        String _pascalize_2 = Strings.pascalize(databaseName);
        String _plus_2 = _pascalize_2 + "Contract.";
        TableDefinition _type_1 = action.getType();
        String _name_1 = _type_1.getName();
        String _pascalize_3 = Strings.pascalize(_name_1);
        String _plus_3 = _plus_2 + _pascalize_3;
        return _plus_3 + ".CONTENT_TYPE";
    }

    public CharSequence generateStub(MickeyDatabaseModel model, SqliteDatabaseSnapshot snapshot) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*******************************************************************************");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Copyright (c) 2012, Robotoworks Limited");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* All rights reserved. This program and the accompanying materials");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* are made available under the terms of the Eclipse Public License v1.0");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* which accompanies this distribution, and is available at");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* http://www.eclipse.org/legal/epl-v10.html");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*******************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _packageName_1 = model.getPackageName();
        _builder.append((Object)_packageName_1, "");
        _builder.append((Object)".Abstract");
        String _databaseName = model.getDatabaseName();
        String _pascalize = Strings.pascalize(_databaseName);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)"ContentProvider;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _databaseName_1 = model.getDatabaseName();
        String _pascalize_1 = Strings.pascalize(_databaseName_1);
        _builder.append((Object)_pascalize_1, "");
        _builder.append((Object)"ContentProvider extends Abstract");
        String _databaseName_2 = model.getDatabaseName();
        String _pascalize_2 = Strings.pascalize(_databaseName_2);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"ContentProvider {}");
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

