/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.mickeyLang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompoundOperator implements Enumerator
{
    UNIONALL(0, "unionall", "union all"),
    UNION(1, "union", "union"),
    INTERSECT(2, "intersect", "intersect"),
    EXCEPT(3, "except", "except");

    public static final int UNIONALL_VALUE = 0;
    public static final int UNION_VALUE = 1;
    public static final int INTERSECT_VALUE = 2;
    public static final int EXCEPT_VALUE = 3;
    private static final CompoundOperator[] VALUES_ARRAY;
    public static final List<CompoundOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CompoundOperator get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CompoundOperator result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CompoundOperator getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CompoundOperator result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CompoundOperator get(int value) {
        switch (value) {
            case 0: {
                return UNIONALL;
            }
            case 1: {
                return UNION;
            }
            case 2: {
                return INTERSECT;
            }
            case 3: {
                return EXCEPT;
            }
        }
        return null;
    }

    private CompoundOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CompoundOperator[]{UNIONALL, UNION, INTERSECT, EXCEPT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

