/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.mickeyLang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ColumnType implements Enumerator
{
    TEXT(0, "text", "text"),
    INTEGER(1, "integer", "integer"),
    REAL(2, "real", "real"),
    BLOB(3, "blob", "blob"),
    BOOLEAN(4, "boolean", "boolean");

    public static final int TEXT_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int REAL_VALUE = 2;
    public static final int BLOB_VALUE = 3;
    public static final int BOOLEAN_VALUE = 4;
    private static final ColumnType[] VALUES_ARRAY;
    public static final List<ColumnType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ColumnType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ColumnType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ColumnType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ColumnType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ColumnType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return REAL;
            }
            case 3: {
                return BLOB;
            }
            case 4: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private ColumnType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ColumnType[]{TEXT, INTEGER, REAL, BLOB, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

