/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.generator.SqliteDatabaseStatementGenerator;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.DDLStatement;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

public class SqliteOpenHelperGenerator {
    @Inject
    @Extension
    private SqliteDatabaseStatementGenerator _sqliteDatabaseStatementGenerator;

    public CharSequence generate(MickeyDatabaseModel model) {
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        Iterator<CreateViewStatement> _databaseName;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        SqliteDatabaseSnapshot snapshot = model.getSnapshot();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import android.content.Context;");
        _builder.newLine();
        _builder.append((Object)"import android.database.sqlite.SQLiteDatabase;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.MickeyOpenHelper;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.Migration;");
        _builder.newLine();
        _builder.newLine();
        int _size = model.migrations.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (MigrationBlock migration : model.migrations) {
                _builder.append((Object)"import ");
                String _packageName_1 = model.getPackageName();
                _builder.append((Object)_packageName_1, "");
                _builder.append((Object)".migrations.Default");
                _databaseName = model.getDatabaseName();
                String _pascalize = Strings.pascalize((String)((Object)_databaseName));
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)"Migration");
                String _name = migration.getName();
                String _pascalize_1 = Strings.pascalize(_name);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"public abstract class Abstract");
        String _databaseName_1 = model.getDatabaseName();
        String _pascalize_2 = Strings.pascalize(_databaseName_1);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"OpenHelper extends MickeyOpenHelper {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String DATABASE_NAME = \"");
        String _databaseName_2 = model.getDatabaseName();
        _builder.append((Object)_databaseName_2, "\t");
        _builder.append((Object)".db\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int VERSION = ");
        int _length = ((Object[])Conversions.unwrapArray(model.migrations, Object.class)).length;
        _builder.append((Object)_length, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public interface Sources {");
        _builder.newLine();
        ArrayList<CreateTableStatement> _tables = snapshot.getTables();
        for (CreateTableStatement table : _tables) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String ");
            String _name_1 = table.getName();
            String _underscore = Strings.underscore(_name_1);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "\t\t");
            _builder.append((Object)" = \"");
            String _name_2 = table.getName();
            _builder.append((Object)_name_2, "\t\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        Iterator<CreateViewStatement> _views = snapshot.getViews();
        _databaseName = ((ArrayList)((Object)_views)).iterator();
        while (_databaseName.hasNext()) {
            CreateViewStatement view = _databaseName.next();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String ");
            String _name_3 = view.getName();
            String _underscore_1 = Strings.underscore(_name_3);
            String _upperCase_1 = _underscore_1.toUpperCase();
            _builder.append((Object)_upperCase_1, "\t\t");
            _builder.append((Object)" = \"");
            String _name_4 = view.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        for (CreateTableStatement table_1 : model.initTables) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String ");
            String _name_5 = table_1.getName();
            String _underscore_2 = Strings.underscore(_name_5);
            String _upperCase_2 = _underscore_2.toUpperCase();
            _builder.append((Object)_upperCase_2, "\t\t");
            _builder.append((Object)" = \"");
            String _name_6 = table_1.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        for (CreateViewStatement view_1 : model.initViews) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"String ");
            String _name_7 = view_1.getName();
            String _underscore_3 = Strings.underscore(_name_7);
            String _upperCase_3 = _underscore_3.toUpperCase();
            _builder.append((Object)_upperCase_3, "\t\t");
            _builder.append((Object)" = \"");
            String _name_8 = view_1.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Abstract");
        String _databaseName_3 = model.getDatabaseName();
        String _pascalize_3 = Strings.pascalize(_databaseName_3);
        _builder.append((Object)_pascalize_3, "\t");
        _builder.append((Object)"OpenHelper(Context context) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(context, DATABASE_NAME, null, VERSION);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Abstract");
        String _databaseName_4 = model.getDatabaseName();
        String _pascalize_4 = Strings.pascalize(_databaseName_4);
        _builder.append((Object)_pascalize_4, "\t");
        _builder.append((Object)"OpenHelper(Context context, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(context, name, null, VERSION);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void onCreate(SQLiteDatabase db) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"applyMigrations(db, 0, VERSION);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        boolean _or = false;
        boolean _isEmpty = model.initTables.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        _or = _not ? true : (_not_1 = !(_isEmpty_1 = model.initViews.isEmpty()));
        if (_or) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void onOpen(SQLiteDatabase db) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"super.onOpen(db);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            Iterable _filter = Iterables.filter(model.initTables, DDLStatement.class);
            CharSequence _generateStatements = this._sqliteDatabaseStatementGenerator.generateStatements(_filter);
            _builder.append((Object)_generateStatements, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            Iterable _filter_1 = Iterables.filter(model.initViews, DDLStatement.class);
            CharSequence _generateStatements_1 = this._sqliteDatabaseStatementGenerator.generateStatements(_filter_1);
            _builder.append((Object)_generateStatements_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected Migration createMigration(int version) {");
        _builder.newLine();
        int _size_1 = model.migrations.size();
        boolean bl3 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append((Object)"\t\t");
            int version = -1;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch(version) {");
            _builder.newLine();
            for (MigrationBlock migration_1 : model.migrations) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                _builder.append((Object)(++version), "\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return create");
                String _databaseName_5 = model.getDatabaseName();
                String _pascalize_5 = Strings.pascalize(_databaseName_5);
                _builder.append((Object)_pascalize_5, "\t\t\t\t");
                _builder.append((Object)"Migration");
                String _name_9 = migration_1.getName();
                String _pascalize_6 = Strings.pascalize(_name_9);
                _builder.append((Object)_pascalize_6, "\t\t\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"throw new IllegalStateException(\"No migration for version \" + version);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"throw new IllegalStateException(\"No migrations for any version\");");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        int _size_2 = model.migrations.size();
        boolean bl4 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            for (MigrationBlock migration_2 : model.migrations) {
                _builder.append((Object)"\t");
                _builder.append((Object)"protected Migration create");
                String _databaseName_6 = model.getDatabaseName();
                String _pascalize_7 = Strings.pascalize(_databaseName_6);
                _builder.append((Object)_pascalize_7, "\t");
                _builder.append((Object)"Migration");
                String _name_10 = migration_2.getName();
                String _pascalize_8 = Strings.pascalize(_name_10);
                _builder.append((Object)_pascalize_8, "\t");
                _builder.append((Object)"() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return new Default");
                String _databaseName_7 = model.getDatabaseName();
                String _pascalize_9 = Strings.pascalize(_databaseName_7);
                _builder.append((Object)_pascalize_9, "\t\t");
                _builder.append((Object)"Migration");
                String _name_11 = migration_2.getName();
                String _pascalize_10 = Strings.pascalize(_name_11);
                _builder.append((Object)_pascalize_10, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateStub(MickeyDatabaseModel model, SqliteDatabaseSnapshot snapshot) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import android.content.Context;");
        _builder.newLine();
        _builder.append((Object)"import ");
        String _packageName_1 = model.getPackageName();
        _builder.append((Object)_packageName_1, "");
        _builder.append((Object)".Abstract");
        String _databaseName = model.getDatabaseName();
        String _pascalize = Strings.pascalize(_databaseName);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)"OpenHelper;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _databaseName_1 = model.getDatabaseName();
        String _pascalize_1 = Strings.pascalize(_databaseName_1);
        _builder.append((Object)_pascalize_1, "");
        _builder.append((Object)"OpenHelper extends Abstract");
        String _databaseName_2 = model.getDatabaseName();
        String _pascalize_2 = Strings.pascalize(_databaseName_2);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"OpenHelper {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _databaseName_3 = model.getDatabaseName();
        String _pascalize_3 = Strings.pascalize(_databaseName_3);
        _builder.append((Object)_pascalize_3, "\t");
        _builder.append((Object)"OpenHelper(Context context) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(context);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

