/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.inject.Inject;
import com.justeat.mickeydb.mickeyLang.CreateIndexStatement;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateTriggerStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.DDLStatement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.xbase.lib.Extension;

public class SqliteDatabaseStatementGenerator {
    @Inject
    @Extension
    private ISerializer _iSerializer;
    private SaveOptions saveOptions;
    private final Pattern stripCommentsExpr = Pattern.compile("\\/\\/[^\\r\\n]+|\\/\\*.*?\\*\\/", 32);

    public SqliteDatabaseStatementGenerator() {
        SaveOptions _options;
        SaveOptions.Builder _newBuilder = SaveOptions.newBuilder();
        SaveOptions.Builder _noValidation = _newBuilder.noValidation();
        this.saveOptions = _options = _noValidation.getOptions();
    }

    public CharSequence generateStatements(Iterable<DDLStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (DDLStatement stmt : statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateTableStatements(Iterable<CreateTableStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (CreateTableStatement stmt : statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateViewStatements(Iterable<CreateViewStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (CreateViewStatement stmt : statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateTriggerStatements(Iterable<CreateTriggerStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (CreateTriggerStatement stmt : statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateIndexStatements(Iterable<CreateIndexStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (CreateIndexStatement stmt : statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateStatement(DDLStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"db.execSQL(");
        _builder.newLine();
        String _serialize = this._iSerializer.serialize((EObject)stmt, this.saveOptions);
        String _stripComments = this.stripComments(_serialize);
        String _trim = _stripComments.trim();
        String[] _split = _trim.split("\\r?\\n");
        boolean _hasElements = false;
        for (String line : _split) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" +", "\t");
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\"");
            String _trim_1 = line.trim();
            String _replaceAll = _trim_1.replaceAll("\\\"", "\\\\\"");
            _builder.append((Object)_replaceAll, "\t");
            _builder.append((Object)" \"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)");\t");
        _builder.newLine();
        return _builder;
    }

    public String stripComments(String s) {
        Matcher _matcher = this.stripCommentsExpr.matcher(s);
        return _matcher.replaceAll("");
    }
}

