/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.inject.Inject;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.mickeyLang.AlterTableAddColumnStatement;
import com.justeat.mickeydb.mickeyLang.AlterTableRenameStatement;
import com.justeat.mickeydb.mickeyLang.ColumnDef;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.CreateIndexStatement;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateTriggerStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.DDLStatement;
import com.justeat.mickeydb.mickeyLang.DropIndexStatement;
import com.justeat.mickeydb.mickeyLang.DropTableStatement;
import com.justeat.mickeydb.mickeyLang.DropTriggerStatement;
import com.justeat.mickeydb.mickeyLang.DropViewStatement;
import com.justeat.mickeydb.mickeyLang.IndexedColumn;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MickeyLangFactory;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import com.justeat.mickeydb.mickeyLang.PrimaryConstraint;
import com.justeat.mickeydb.mickeyLang.TableConstraint;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import com.justeat.mickeydb.mickeyLang.UniqueTableConstraint;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SqliteDatabaseSnapshot {
    private ArrayList<CreateTableStatement> mTables = new ArrayList();
    private ArrayList<CreateViewStatement> mViews = new ArrayList();
    private ArrayList<CreateTriggerStatement> mTriggers = new ArrayList();
    private ArrayList<CreateIndexStatement> mIndexes = new ArrayList();
    private LinkedHashMap<String, CreateTableStatement> mTableMap;
    private LinkedHashMap<String, CreateViewStatement> mViewMap;
    private LinkedHashMap<String, CreateTriggerStatement> mTriggerMap;
    private LinkedHashMap<String, CreateIndexStatement> mCreateIndexMap;

    public SqliteDatabaseSnapshot(LinkedHashMap<String, CreateTableStatement> tables, LinkedHashMap<String, CreateViewStatement> views, LinkedHashMap<String, CreateTriggerStatement> triggers, LinkedHashMap<String, CreateIndexStatement> indexes) {
        this.mTableMap = tables;
        this.mViewMap = views;
        this.mTriggerMap = triggers;
        this.mCreateIndexMap = indexes;
        this.mTables.addAll(tables.values());
        this.mViews.addAll(views.values());
        this.mTriggers.addAll(triggers.values());
        this.mIndexes.addAll(indexes.values());
    }

    public ArrayList<CreateTableStatement> getTables() {
        return this.mTables;
    }

    public ArrayList<CreateViewStatement> getViews() {
        return this.mViews;
    }

    public ArrayList<CreateTriggerStatement> getTriggers() {
        return this.mTriggers;
    }

    public ArrayList<CreateIndexStatement> getIndexes() {
        return this.mIndexes;
    }

    public boolean containsDefinition(final String name) {
        CreateTableStatement tableStmt = (CreateTableStatement)IterableExtensions.findFirst(this.mTables, (Functions.Function1)new Functions.Function1<CreateTableStatement, Boolean>(){

            public Boolean apply(CreateTableStatement p) {
                return p.getName().equals(name);
            }
        });
        if (tableStmt != null) {
            return true;
        }
        CreateViewStatement viewStmt = (CreateViewStatement)IterableExtensions.findFirst(this.mViews, (Functions.Function1)new Functions.Function1<CreateViewStatement, Boolean>(){

            public Boolean apply(CreateViewStatement p) {
                return p.getName().equals(name);
            }
        });
        return viewStmt != null;
    }

    public TableDefinition getTableDefinition(String name) {
        TableDefinition tbl = this.mTableMap.get(name);
        if (tbl == null) {
            tbl = this.mViewMap.get(name);
        }
        return tbl;
    }

    public static class Builder {
        @Inject
        XtextResourceSet mSnapshotResourceSet;
        private LinkedHashMap<String, CreateTableStatement> mTables = new LinkedHashMap();
        private LinkedHashMap<String, CreateViewStatement> mViews = new LinkedHashMap();
        private LinkedHashMap<String, CreateTriggerStatement> mTriggers = new LinkedHashMap();
        private LinkedHashMap<String, CreateIndexStatement> mIndexes = new LinkedHashMap();
        private MickeyFile mSnapshotModel;
        private MickeyDatabaseModel mSourceModel;

        private void buildSnapshot(MickeyDatabaseModel model) {
            for (MigrationBlock migration : model.migrations) {
                EList<DDLStatement> statements = migration.getStatements();
                for (DDLStatement statement : statements) {
                    CreateTableStatement tableToAlter;
                    if (statement instanceof CreateTableStatement) {
                        CreateTableStatement createTableStmt = (CreateTableStatement)statement;
                        CreateTableStatement copy = (CreateTableStatement)EcoreUtil2.copy((EObject)createTableStmt);
                        this.mTables.put(createTableStmt.getName(), copy);
                        continue;
                    }
                    if (statement instanceof CreateViewStatement) {
                        CreateViewStatement createViewStmt = (CreateViewStatement)statement;
                        this.mViews.put(createViewStmt.getName(), createViewStmt);
                        continue;
                    }
                    if (statement instanceof AlterTableRenameStatement) {
                        AlterTableRenameStatement renameStmt = (AlterTableRenameStatement)statement;
                        tableToAlter = this.mTables.get(renameStmt.getTable().getName());
                        tableToAlter.setName(renameStmt.getName());
                        this.mTables.put(renameStmt.getName(), tableToAlter);
                        this.mTables.remove(renameStmt.getTable().getName());
                        continue;
                    }
                    if (statement instanceof AlterTableAddColumnStatement) {
                        AlterTableAddColumnStatement addColumnStmt = (AlterTableAddColumnStatement)statement;
                        tableToAlter = this.mTables.get(addColumnStmt.getTable().getName());
                        tableToAlter.getColumnDefs().add((Object)EcoreUtil.copy((EObject)addColumnStmt.getColumnDef()));
                        continue;
                    }
                    if (statement instanceof CreateTriggerStatement) {
                        CreateTriggerStatement createTriggerStmt = (CreateTriggerStatement)statement;
                        this.mTriggers.put(createTriggerStmt.getName(), createTriggerStmt);
                        continue;
                    }
                    if (statement instanceof CreateIndexStatement) {
                        CreateIndexStatement createIndexStmt = (CreateIndexStatement)statement;
                        this.mIndexes.put(createIndexStmt.getName(), createIndexStmt);
                        continue;
                    }
                    if (statement instanceof DropTableStatement) {
                        DropTableStatement dropTableStmt = (DropTableStatement)statement;
                        this.mTables.remove(dropTableStmt.getTable().getName());
                        continue;
                    }
                    if (statement instanceof DropViewStatement) {
                        DropViewStatement dropViewStmt = (DropViewStatement)statement;
                        this.mViews.remove(dropViewStmt.getView().getName());
                        continue;
                    }
                    if (statement instanceof DropTriggerStatement) {
                        DropTriggerStatement dropTriggerStmt = (DropTriggerStatement)statement;
                        this.mTriggers.remove(dropTriggerStmt.getTrigger().getName());
                        continue;
                    }
                    if (!(statement instanceof DropIndexStatement)) continue;
                    DropIndexStatement dropIndexStmt = (DropIndexStatement)statement;
                    this.mIndexes.remove(dropIndexStmt.getIndex().getName());
                }
            }
        }

        private void buildSnapshotModel() {
            XtextResource resource = (XtextResource)this.mSnapshotResourceSet.createResource(URI.createURI((String)"platform:/resource/app1/temp.mickey"));
            this.mSnapshotModel = MickeyLangFactory.eINSTANCE.createMickeyFile();
            this.mSnapshotModel.setDatabaseName(this.mSourceModel.getDatabaseName());
            resource.getContents().add((Object)this.mSnapshotModel);
            MigrationBlock migration = MickeyLangFactory.eINSTANCE.createMigrationBlock();
            this.mSnapshotModel.getBlocks().add((Object)migration);
            for (CreateTableStatement stmt : this.mTables.values()) {
                migration.getStatements().add((Object)stmt);
                this.resolveIndexedColumnReferences(stmt);
            }
            EcoreUtil2.resolveAll((ResourceSet)this.mSnapshotResourceSet);
        }

        private void resolveIndexedColumnReferences(CreateTableStatement stmt) {
            EList<IndexedColumn> columns = null;
            for (TableConstraint c : stmt.getConstraints()) {
                if (c instanceof UniqueTableConstraint) {
                    UniqueTableConstraint uc = (UniqueTableConstraint)c;
                    columns = uc.getColumns();
                } else if (c instanceof PrimaryConstraint) {
                    PrimaryConstraint pc = (PrimaryConstraint)c;
                    columns = pc.getColumns();
                }
                if (columns == null) {
                    return;
                }
                for (final IndexedColumn col : columns) {
                    ColumnSource source = (ColumnSource)IterableExtensions.findFirst(stmt.getColumnDefs(), (Functions.Function1)new Functions.Function1<ColumnSource, Boolean>(){

                        public Boolean apply(ColumnSource p) {
                            if (p.getName().equals(col.getColumnReference().getName())) {
                                return true;
                            }
                            return false;
                        }
                    });
                    col.setColumnReference((ColumnDef)source);
                }
            }
        }

        public SqliteDatabaseSnapshot build(MickeyDatabaseModel model) {
            this.mSourceModel = model;
            try {
                this.buildSnapshot(model);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.buildSnapshotModel();
            return new SqliteDatabaseSnapshot(this.mTables, this.mViews, this.mTriggers, this.mIndexes);
        }
    }
}

