/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.justeat.mickeydb.ContentUriInfo;
import com.justeat.mickeydb.ContentUris;
import com.justeat.mickeydb.MickeyAssembler;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.MickeyModel;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.ActiveRecordGenerator;
import com.justeat.mickeydb.generator.ContentProviderContractGenerator;
import com.justeat.mickeydb.generator.ContentProviderGenerator;
import com.justeat.mickeydb.generator.CustomActionsGenerator;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.generator.SqliteMigrationGenerator;
import com.justeat.mickeydb.generator.SqliteOpenHelperGenerator;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MickeyLangGenerator
extends AbstractGenerator {
    @Inject
    private SqliteOpenHelperGenerator mOpenHelperGenerator;
    @Inject
    private ContentProviderContractGenerator mContentProviderContractGenerator;
    @Inject
    private ContentProviderGenerator mContentProviderGenerator;
    @Inject
    private Provider<SqliteMigrationGenerator> mMigrationGenerator;
    @Inject
    private ActiveRecordGenerator mActiveRecordGenerator;
    @Inject
    private CustomActionsGenerator mCustomActionsGenerator;
    @Inject
    private MickeyAssembler assembler;

    public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, IGeneratorContext context) {
        boolean _not;
        URI _uRI = resource.getURI();
        String _string = _uRI.toString();
        boolean _contains = _string.contains("init.mickey");
        boolean bl = _not = !_contains;
        if (_not) {
            return;
        }
        MickeyModel mickeyModel = this.assembler.assemble(resource);
        String stubOutput = "DEFAULT_STUB_OUTPUT";
        Collection<MickeyDatabaseModel> _values = mickeyModel.databases.values();
        Consumer<MickeyDatabaseModel> _function = new Consumer<MickeyDatabaseModel>(){

            @Override
            public void accept(final MickeyDatabaseModel it) {
                ContentUris content = new ContentUris();
                content.init(it);
                String _packageName = it.getPackageName();
                String _databaseName = it.getDatabaseName();
                String _pascalize = Strings.pascalize(_databaseName);
                String _concat = "Abstract".concat(_pascalize);
                String _concat_1 = _concat.concat("OpenHelper");
                String _resolveFileName = Strings.resolveFileName(_packageName, _concat_1);
                CharSequence _generate = MickeyLangGenerator.this.mOpenHelperGenerator.generate(it);
                fsa.generateFile(_resolveFileName, _generate);
                String _packageName_1 = it.getPackageName();
                String _databaseName_1 = it.getDatabaseName();
                String _pascalize_1 = Strings.pascalize(_databaseName_1);
                String _concat_2 = _pascalize_1.concat("OpenHelper");
                String _resolveFileName_1 = Strings.resolveFileName(_packageName_1, _concat_2);
                SqliteDatabaseSnapshot _snapshot = it.getSnapshot();
                CharSequence _generateStub = MickeyLangGenerator.this.mOpenHelperGenerator.generateStub(it, _snapshot);
                fsa.generateFile(_resolveFileName_1, "DEFAULT_STUB_OUTPUT", _generateStub);
                String _packageName_2 = it.getPackageName();
                String _databaseName_2 = it.getDatabaseName();
                String _pascalize_2 = Strings.pascalize(_databaseName_2);
                String _concat_3 = _pascalize_2.concat("Contract");
                String _resolveFileName_2 = Strings.resolveFileName(_packageName_2, _concat_3);
                CharSequence _generate_1 = MickeyLangGenerator.this.mContentProviderContractGenerator.generate(it, content);
                fsa.generateFile(_resolveFileName_2, _generate_1);
                String _packageName_3 = it.getPackageName();
                String _databaseName_3 = it.getDatabaseName();
                String _pascalize_3 = Strings.pascalize(_databaseName_3);
                String _concat_4 = "Abstract".concat(_pascalize_3);
                String _concat_5 = _concat_4.concat("ContentProvider");
                String _resolveFileName_3 = Strings.resolveFileName(_packageName_3, _concat_5);
                CharSequence _generate_2 = MickeyLangGenerator.this.mContentProviderGenerator.generate(it, content);
                fsa.generateFile(_resolveFileName_3, _generate_2);
                String _packageName_4 = it.getPackageName();
                String _databaseName_4 = it.getDatabaseName();
                String _pascalize_4 = Strings.pascalize(_databaseName_4);
                String _concat_6 = _pascalize_4.concat("ContentProvider");
                String _resolveFileName_4 = Strings.resolveFileName(_packageName_4, _concat_6);
                SqliteDatabaseSnapshot _snapshot_1 = it.getSnapshot();
                CharSequence _generateStub_1 = MickeyLangGenerator.this.mContentProviderGenerator.generateStub(it, _snapshot_1);
                fsa.generateFile(_resolveFileName_4, "DEFAULT_STUB_OUTPUT", _generateStub_1);
                SqliteDatabaseSnapshot _snapshot_2 = it.getSnapshot();
                ArrayList<CreateTableStatement> _tables = _snapshot_2.getTables();
                Consumer<CreateTableStatement> _function = new Consumer<CreateTableStatement>(){

                    @Override
                    public void accept(CreateTableStatement statement) {
                        MickeyLangGenerator.this.generateActiveRecordEntity(it, resource, (IFileSystemAccess)fsa, statement);
                    }
                };
                _tables.forEach(_function);
                SqliteDatabaseSnapshot _snapshot_3 = it.getSnapshot();
                ArrayList<CreateViewStatement> _views = _snapshot_3.getViews();
                Consumer<CreateViewStatement> _function_1 = new Consumer<CreateViewStatement>(){

                    @Override
                    public void accept(CreateViewStatement statement) {
                        MickeyLangGenerator.this.generateActiveRecordEntity(it, resource, (IFileSystemAccess)fsa, statement);
                    }
                };
                _views.forEach(_function_1);
                Consumer<CreateTableStatement> _function_2 = new Consumer<CreateTableStatement>(){

                    @Override
                    public void accept(CreateTableStatement statement) {
                        MickeyLangGenerator.this.generateActiveRecordEntity(it, resource, (IFileSystemAccess)fsa, statement);
                    }
                };
                it.initTables.forEach(_function_2);
                Consumer<CreateViewStatement> _function_3 = new Consumer<CreateViewStatement>(){

                    @Override
                    public void accept(CreateViewStatement statement) {
                        MickeyLangGenerator.this.generateActiveRecordEntity(it, resource, (IFileSystemAccess)fsa, statement);
                    }
                };
                it.initViews.forEach(_function_3);
                Procedures.Procedure2<MigrationBlock, Integer> _function_4 = new Procedures.Procedure2<MigrationBlock, Integer>(){

                    public void apply(MigrationBlock item, Integer index) {
                        String _packageName = it.getPackageName();
                        String _databaseName = it.getDatabaseName();
                        MickeyLangGenerator.this.generateMigration(_packageName, _databaseName, resource, (IFileSystemAccess)fsa, item);
                    }
                };
                IterableExtensions.forEach(it.migrations, (Procedures.Procedure2)_function_4);
                Consumer<ContentUriInfo> _function_5 = new Consumer<ContentUriInfo>(){

                    @Override
                    public void accept(ContentUriInfo p1) {
                        String _packageName = it.getPackageName();
                        String _concat = _packageName.concat(".actions");
                        String _name = p1.getName();
                        String _pascalize = Strings.pascalize(_name);
                        String _concat_1 = _pascalize.concat("Actions");
                        String _resolveFileName = Strings.resolveFileName(_concat, _concat_1);
                        CharSequence _generate = MickeyLangGenerator.this.mCustomActionsGenerator.generate(it, p1);
                        fsa.generateFile(_resolveFileName, _generate);
                    }
                };
                content.uris.forEach(_function_5);
            }
        };
        _values.forEach(_function);
    }

    public void generateActiveRecordEntity(MickeyDatabaseModel model, Resource resource, IFileSystemAccess fsa, CreateTableStatement statement) {
        boolean _hasAndroidPrimaryKey = ModelUtil.hasAndroidPrimaryKey(statement);
        if (_hasAndroidPrimaryKey) {
            String _packageName = model.getPackageName();
            String _name = statement.getName();
            String _pascalize = Strings.pascalize(_name);
            String _concat = _pascalize.concat("Record");
            String genFileName = Strings.resolveFileName(_packageName, _concat);
            String _packageName_1 = model.getPackageName();
            String _databaseName = model.getDatabaseName();
            CharSequence _generate = this.mActiveRecordGenerator.generate(_packageName_1, _databaseName, statement);
            fsa.generateFile(genFileName, _generate);
        }
    }

    public void generateActiveRecordEntity(MickeyDatabaseModel model, Resource resource, IFileSystemAccess fsa, CreateViewStatement statement) {
        boolean _hasAndroidPrimaryKey = ModelUtil.hasAndroidPrimaryKey(statement);
        if (_hasAndroidPrimaryKey) {
            String _packageName = model.getPackageName();
            String _name = statement.getName();
            String _pascalize = Strings.pascalize(_name);
            String _concat = _pascalize.concat("Record");
            String genFileName = Strings.resolveFileName(_packageName, _concat);
            String _packageName_1 = model.getPackageName();
            String _databaseName = model.getDatabaseName();
            CharSequence _generate = this.mActiveRecordGenerator.generate(_packageName_1, _databaseName, statement);
            fsa.generateFile(genFileName, _generate);
        }
    }

    public void generateMigration(String packageName, String databaseName, Resource resource, IFileSystemAccess fsa, MigrationBlock migration) {
        EList _contents = resource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        MickeyFile model = (MickeyFile)_head;
        String _concat = packageName.concat(".migrations");
        String _pascalize = Strings.pascalize(databaseName);
        String _concat_1 = "Default".concat(_pascalize);
        String _concat_2 = _concat_1.concat("Migration");
        String _name = migration.getName();
        String _pascalize_1 = Strings.pascalize(_name);
        String _valueOf = String.valueOf(_pascalize_1);
        String _concat_3 = _concat_2.concat(_valueOf);
        String genFileName = Strings.resolveFileName(_concat, _concat_3);
        SqliteMigrationGenerator generator = (SqliteMigrationGenerator)this.mMigrationGenerator.get();
        CharSequence _generate = generator.generate(model, packageName, databaseName, migration);
        fsa.generateFile(genFileName, _generate);
    }
}

