/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.justeat.mickeydb.ContentUris;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.ActionStatement;
import com.justeat.mickeydb.mickeyLang.ColumnDef;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnType;
import com.justeat.mickeydb.mickeyLang.ContentUri;
import com.justeat.mickeydb.mickeyLang.ContentUriParamSegment;
import com.justeat.mickeydb.mickeyLang.ContentUriQueryParam;
import com.justeat.mickeydb.mickeyLang.ContentUriSegment;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.ResultColumn;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ContentProviderContractGenerator {
    public CharSequence generate(MickeyDatabaseModel model, ContentUris content) {
        StringConcatenation _builder = new StringConcatenation();
        SqliteDatabaseSnapshot snapshot = model.getSnapshot();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by MickeyDB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        String _packageName = model.getPackageName();
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import android.net.Uri;");
        _builder.newLine();
        _builder.append((Object)"import android.provider.BaseColumns;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.AbstractValuesBuilder;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.Mickey;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.MickeyUriBuilder;");
        _builder.newLine();
        _builder.append((Object)"import java.lang.reflect.Field;\t\t\t");
        _builder.newLine();
        _builder.append((Object)"import java.util.Collections;");
        _builder.newLine();
        _builder.append((Object)"import java.util.HashSet;");
        _builder.newLine();
        _builder.append((Object)"import java.util.HashMap;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Set;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _databaseName = model.getDatabaseName();
        _builder.append((Object)_databaseName, "");
        _builder.append((Object)"Contract  {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static final String CONTENT_AUTHORITY = initAuthority();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static String initAuthority() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String authority = \"");
        String _packageName_1 = model.getPackageName();
        _builder.append((Object)_packageName_1, "\t\t");
        _builder.append((Object)".");
        String _databaseName_1 = model.getDatabaseName();
        String _lowerCase = _databaseName_1.toLowerCase();
        _builder.append((Object)_lowerCase, "\t\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"ClassLoader loader = ");
        String _databaseName_2 = model.getDatabaseName();
        String _pascalize = Strings.pascalize(_databaseName_2);
        _builder.append((Object)_pascalize, "    \t\t");
        _builder.append((Object)"Contract.class.getClassLoader();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Class<?> clz = loader.loadClass(\"");
        String _packageName_2 = model.getPackageName();
        _builder.append((Object)_packageName_2, "\t\t\t");
        _builder.append((Object)".");
        String _databaseName_3 = model.getDatabaseName();
        String _pascalize_1 = Strings.pascalize(_databaseName_3);
        _builder.append((Object)_pascalize_1, "\t\t\t");
        _builder.append((Object)"ContentProviderAuthority\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Field declaredField = clz.getDeclaredField(\"CONTENT_AUTHORITY\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"authority = declaredField.get(null).toString();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (ClassNotFoundException e) {} ");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"catch (NoSuchFieldException e) {} ");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"catch (IllegalArgumentException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IllegalAccessException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return authority;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static final Uri BASE_CONTENT_URI = Uri.parse(\"content://\" + CONTENT_AUTHORITY);");
        _builder.newLine();
        _builder.newLine();
        ArrayList<CreateTableStatement> _tables = snapshot.getTables();
        for (CreateTableStatement tbl : _tables) {
            _builder.append((Object)"\t");
            _builder.append((Object)"interface ");
            String _name = tbl.getName();
            String _pascalize_2 = Strings.pascalize(_name);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)"Columns {");
            _builder.newLineIfNotEmpty();
            EList<ColumnSource> _columnDefs = tbl.getColumnDefs();
            Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

                public Boolean apply(ColumnSource it) {
                    String _name = it.getName();
                    boolean _equals = _name.equals("_id");
                    return !_equals;
                }
            };
            Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
            for (ColumnSource col : _filter) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"String ");
                String _name_1 = col.getName();
                String _underscore = Strings.underscore(_name_1);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "\t\t");
                _builder.append((Object)" = \"");
                String _name_2 = col.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"\";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        Iterator<CreateViewStatement> _views = snapshot.getViews();
        Iterator<CreateViewStatement> iterator = ((ArrayList)((Object)_views)).iterator();
        while (iterator.hasNext()) {
            CreateViewStatement vw = iterator.next();
            _builder.append((Object)"\t");
            _builder.append((Object)"interface ");
            String _name_3 = vw.getName();
            String _pascalize_3 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_3, "\t");
            _builder.append((Object)"Columns {");
            _builder.newLineIfNotEmpty();
            ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(vw);
            Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

                public Boolean apply(ColumnSource it) {
                    String _name = it.getName();
                    boolean _equals = _name.equals("_id");
                    return !_equals;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter(_viewResultColumns, (Functions.Function1)_function_1);
            for (ColumnSource col_1 : _filter_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _generateInterfaceMemberForResultColumn = this.generateInterfaceMemberForResultColumn(col_1);
                _builder.append((Object)_generateInterfaceMemberForResultColumn, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        for (CreateTableStatement createTableStatement : model.initTables) {
            _builder.append((Object)"\t");
            _builder.append((Object)"interface ");
            String _name_4 = createTableStatement.getName();
            String _pascalize_4 = Strings.pascalize(_name_4);
            _builder.append((Object)_pascalize_4, "\t");
            _builder.append((Object)"Columns {");
            _builder.newLineIfNotEmpty();
            EList<ColumnSource> _columnDefs_1 = createTableStatement.getColumnDefs();
            Functions.Function1<ColumnSource, Boolean> _function_2 = new Functions.Function1<ColumnSource, Boolean>(){

                public Boolean apply(ColumnSource it) {
                    String _name = it.getName();
                    boolean _equals = _name.equals("_id");
                    return !_equals;
                }
            };
            Iterable _filter_2 = IterableExtensions.filter(_columnDefs_1, (Functions.Function1)_function_2);
            for (ColumnSource col_2 : _filter_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"String ");
                String _name_5 = col_2.getName();
                String _underscore_1 = Strings.underscore(_name_5);
                String _upperCase_1 = _underscore_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "\t\t");
                _builder.append((Object)" = \"");
                String _name_6 = col_2.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)"\";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        for (CreateViewStatement createViewStatement : model.initViews) {
            _builder.append((Object)"\t");
            _builder.append((Object)"interface ");
            String _name_7 = createViewStatement.getName();
            String _pascalize_5 = Strings.pascalize(_name_7);
            _builder.append((Object)_pascalize_5, "\t");
            _builder.append((Object)"Columns {");
            _builder.newLineIfNotEmpty();
            ArrayList<ColumnSource> _viewResultColumns_1 = ModelUtil.getViewResultColumns(createViewStatement);
            Functions.Function1<ColumnSource, Boolean> _function_3 = new Functions.Function1<ColumnSource, Boolean>(){

                public Boolean apply(ColumnSource it) {
                    String _name = it.getName();
                    boolean _equals = _name.equals("_id");
                    return !_equals;
                }
            };
            Iterable _filter_3 = IterableExtensions.filter(_viewResultColumns_1, (Functions.Function1)_function_3);
            for (ColumnSource col_3 : _filter_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _generateInterfaceMemberForResultColumn_1 = this.generateInterfaceMemberForResultColumn(col_3);
                _builder.append((Object)_generateInterfaceMemberForResultColumn_1, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        ArrayList<CreateTableStatement> _tables_1 = snapshot.getTables();
        for (CreateTableStatement tbl_2 : _tables_1) {
            _builder.append((Object)"\t");
            CharSequence _generateContractItem = this.generateContractItem(model, snapshot, tbl_2, content);
            _builder.append((Object)_generateContractItem, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterator<CreateViewStatement> _views_1 = snapshot.getViews();
        Iterator<CreateViewStatement> iterator2 = ((ArrayList)((Object)_views_1)).iterator();
        while (iterator2.hasNext()) {
            CreateViewStatement vw_2 = iterator2.next();
            _builder.append((Object)"\t");
            CharSequence _generateContractItem_1 = this.generateContractItem(model, snapshot, vw_2, content);
            _builder.append((Object)_generateContractItem_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        for (CreateTableStatement createTableStatement : model.initTables) {
            _builder.append((Object)"\t");
            CharSequence _generateContractItem_2 = this.generateContractItem(model, snapshot, createTableStatement, content);
            _builder.append((Object)_generateContractItem_2, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        for (CreateViewStatement createViewStatement : model.initViews) {
            _builder.append((Object)"\t");
            CharSequence _generateContractItem_3 = this.generateContractItem(model, snapshot, createViewStatement, content);
            _builder.append((Object)_generateContractItem_3, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static Map<Uri, Set<Uri>> REFERENCING_VIEWS;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<Uri, Set<Uri>> map = new HashMap<Uri, Set<Uri>>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        ArrayList<CreateTableStatement> _tables_2 = snapshot.getTables();
        for (CreateTableStatement tbl_4 : _tables_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"map.put(");
            String _name_8 = tbl_4.getName();
            String _pascalize_6 = Strings.pascalize(_name_8);
            _builder.append((Object)_pascalize_6, "\t\t");
            _builder.append((Object)".CONTENT_URI, ");
            String _name_9 = tbl_4.getName();
            String _pascalize_7 = Strings.pascalize(_name_9);
            _builder.append((Object)_pascalize_7, "\t\t");
            _builder.append((Object)".VIEW_URIS);");
            _builder.newLineIfNotEmpty();
        }
        Iterator<CreateViewStatement> _views_2 = snapshot.getViews();
        Iterator<CreateViewStatement> iterator3 = ((ArrayList)((Object)_views_2)).iterator();
        while (iterator3.hasNext()) {
            CreateViewStatement vw_4 = iterator3.next();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"map.put(");
            String _name_10 = vw_4.getName();
            String _pascalize_8 = Strings.pascalize(_name_10);
            _builder.append((Object)_pascalize_8, "\t\t");
            _builder.append((Object)".CONTENT_URI, ");
            String _name_11 = vw_4.getName();
            String _pascalize_9 = Strings.pascalize(_name_11);
            _builder.append((Object)_pascalize_9, "\t\t");
            _builder.append((Object)".VIEW_URIS);");
            _builder.newLineIfNotEmpty();
        }
        for (CreateTableStatement createTableStatement : model.initTables) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"map.put(");
            String _name_12 = createTableStatement.getName();
            String _pascalize_10 = Strings.pascalize(_name_12);
            _builder.append((Object)_pascalize_10, "\t\t");
            _builder.append((Object)".CONTENT_URI, ");
            String _name_13 = createTableStatement.getName();
            String _pascalize_11 = Strings.pascalize(_name_13);
            _builder.append((Object)_pascalize_11, "\t\t");
            _builder.append((Object)".VIEW_URIS);");
            _builder.newLineIfNotEmpty();
        }
        for (CreateViewStatement createViewStatement : model.initViews) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"map.put(");
            String _name_14 = createViewStatement.getName();
            String _pascalize_12 = Strings.pascalize(_name_14);
            _builder.append((Object)_pascalize_12, "\t\t");
            _builder.append((Object)".CONTENT_URI, ");
            String _name_15 = createViewStatement.getName();
            String _pascalize_13 = Strings.pascalize(_name_15);
            _builder.append((Object)_pascalize_13, "\t\t");
            _builder.append((Object)".VIEW_URIS);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"REFERENCING_VIEWS = Collections.unmodifiableMap(map);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _databaseName_4 = model.getDatabaseName();
        String string = Strings.pascalize(_databaseName_4);
        _builder.append((Object)string, "\t");
        _builder.append((Object)"Contract(){}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Delete all rows from all tables</p>");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void deleteAll() {");
        _builder.newLine();
        ArrayList<CreateTableStatement> _tables_3 = snapshot.getTables();
        for (CreateTableStatement tbl_6 : _tables_3) {
            _builder.append((Object)"\t\t");
            String _name_16 = tbl_6.getName();
            String _pascalize_15 = Strings.pascalize(_name_16);
            _builder.append((Object)_pascalize_15, "\t\t");
            _builder.append((Object)".delete();");
            _builder.newLineIfNotEmpty();
        }
        for (CreateTableStatement tbl_7 : model.initTables) {
            _builder.append((Object)"\t\t");
            String _name_17 = tbl_7.getName();
            String _pascalize_16 = Strings.pascalize(_name_17);
            _builder.append((Object)_pascalize_16, "\t\t");
            _builder.append((Object)".delete();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createActionUriBuilder(ActionStatement action) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Create a new URI for ");
        ContentUri _uri = action.getUri();
        String _asString = this.asString(_uri);
        _builder.append((Object)_asString, " ");
        _builder.newLineIfNotEmpty();
        EList<ContentUriQueryParam> _params = action.getParams();
        boolean _isEmpty = _params.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)" ");
            _builder.append((Object)"* <b>Query Params:</b>");
            _builder.newLine();
            EList<ContentUriQueryParam> _params_1 = action.getParams();
            for (ContentUriQueryParam param : _params_1) {
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                ColumnSource _column = param.getColumn();
                String _name = _column.getName();
                _builder.append((Object)_name, " ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static class ");
        String _name_1 = action.getName();
        String _pascalize = Strings.pascalize(_name_1);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)"UriBuilder extends MickeyUriBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = action.getName();
        String _pascalize_1 = Strings.pascalize(_name_2);
        _builder.append((Object)_pascalize_1, "\t");
        _builder.append((Object)"UriBuilder(");
        ContentUri _uri_1 = action.getUri();
        String _methodArgsSig = this.toMethodArgsSig(_uri_1);
        _builder.append((Object)_methodArgsSig, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(BASE_CONTENT_URI.buildUpon());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"getUriBuilder()");
        _builder.newLine();
        ContentUri _uri_2 = action.getUri();
        EList<ContentUriSegment> _segments = _uri_2.getSegments();
        Iterator iterator = _segments.iterator();
        while (iterator.hasNext()) {
            ContentUriSegment seg = (ContentUriSegment)iterator.next();
            if (seg instanceof ContentUriParamSegment) {
                boolean _notEquals;
                ColumnSource _param = ((ContentUriParamSegment)seg).getParam();
                ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
                boolean bl2 = _notEquals = !Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
                if (_notEquals) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)".appendPath(String.valueOf(");
                    ColumnSource _param_1 = ((ContentUriParamSegment)seg).getParam();
                    String _name_3 = _param_1.getName();
                    String _camelize = Strings.camelize(_name_3);
                    _builder.append((Object)_camelize, "\t\t");
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)".appendPath(");
                    ColumnSource _param_2 = ((ContentUriParamSegment)seg).getParam();
                    String _name_4 = _param_2.getName();
                    String _camelize_1 = Strings.camelize(_name_4);
                    _builder.append((Object)_camelize_1, "\t\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)".appendPath(\"");
                String _name_5 = seg.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList<ContentUriQueryParam> _params_2 = action.getParams();
        for (ContentUriQueryParam queryParam : _params_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_6 = action.getName();
            String _pascalize_2 = Strings.pascalize(_name_6);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)"UriBuilder set");
            ColumnSource _column_1 = queryParam.getColumn();
            String _name_7 = _column_1.getName();
            String _pascalize_3 = Strings.pascalize(_name_7);
            _builder.append((Object)_pascalize_3, "\t");
            _builder.append((Object)"Param(");
            ColumnSource _column_2 = queryParam.getColumn();
            ColumnType _inferredColumnType_1 = ModelUtil.getInferredColumnType(_column_2);
            String _javaTypeName = ModelUtil.toJavaTypeName(_inferredColumnType_1);
            _builder.append((Object)_javaTypeName, "\t");
            _builder.append((Object)" value) {");
            _builder.newLineIfNotEmpty();
            ColumnSource _column_3 = queryParam.getColumn();
            ColumnType _inferredColumnType_2 = ModelUtil.getInferredColumnType(_column_3);
            boolean _equals = Objects.equal((Object)((Object)_inferredColumnType_2), (Object)((Object)ColumnType.TEXT));
            if (_equals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"getUriBuilder().appendQueryParameter(");
                TableDefinition _type = action.getType();
                String _name_8 = _type.getName();
                String _pascalize_4 = Strings.pascalize(_name_8);
                _builder.append((Object)_pascalize_4, "\t\t");
                _builder.append((Object)".");
                ColumnSource _column_4 = queryParam.getColumn();
                String _name_9 = _column_4.getName();
                String _underscore = Strings.underscore(_name_9);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "\t\t");
                _builder.append((Object)", value);");
                _builder.newLineIfNotEmpty();
            } else {
                ColumnSource _column_5 = queryParam.getColumn();
                ColumnType _inferredColumnType_3 = ModelUtil.getInferredColumnType(_column_5);
                boolean _equals_1 = Objects.equal((Object)((Object)_inferredColumnType_3), (Object)((Object)ColumnType.BOOLEAN));
                if (_equals_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"getUriBuilder().appendQueryParameter(");
                    TableDefinition _type_1 = action.getType();
                    String _name_10 = _type_1.getName();
                    String _pascalize_5 = Strings.pascalize(_name_10);
                    _builder.append((Object)_pascalize_5, "\t\t");
                    _builder.append((Object)".");
                    ColumnSource _column_6 = queryParam.getColumn();
                    String _name_11 = _column_6.getName();
                    String _underscore_1 = Strings.underscore(_name_11);
                    String _upperCase_1 = _underscore_1.toUpperCase();
                    _builder.append((Object)_upperCase_1, "\t\t");
                    _builder.append((Object)", value ? \"1\" : \"0\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"getUriBuilder().appendQueryParameter(");
                    TableDefinition _type_2 = action.getType();
                    String _name_12 = _type_2.getName();
                    String _pascalize_6 = Strings.pascalize(_name_12);
                    _builder.append((Object)_pascalize_6, "\t\t");
                    _builder.append((Object)".");
                    ColumnSource _column_7 = queryParam.getColumn();
                    String _name_13 = _column_7.getName();
                    String _underscore_2 = Strings.underscore(_name_13);
                    String _upperCase_2 = _underscore_2.toUpperCase();
                    _builder.append((Object)_upperCase_2, "\t\t");
                    _builder.append((Object)", String.valueOf(value));");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Create a new URI for ");
        ContentUri _uri_3 = action.getUri();
        String _asString_1 = this.asString(_uri_3);
        _builder.append((Object)_asString_1, " ");
        _builder.newLineIfNotEmpty();
        EList<ContentUriQueryParam> _params_3 = action.getParams();
        boolean _isEmpty_1 = _params_3.isEmpty();
        boolean bl3 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append((Object)" ");
            _builder.append((Object)"* <b>Query Params:</b>");
            _builder.newLine();
            EList<ContentUriQueryParam> _params_4 = action.getParams();
            for (ContentUriQueryParam param_1 : _params_4) {
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                ColumnSource _column_8 = param_1.getColumn();
                String _name_14 = _column_8.getName();
                _builder.append((Object)_name_14, " ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static ");
        String _name_15 = action.getName();
        String _pascalize_7 = Strings.pascalize(_name_15);
        _builder.append((Object)_pascalize_7, "");
        _builder.append((Object)"UriBuilder new");
        String _name_16 = action.getName();
        String _pascalize_8 = Strings.pascalize(_name_16);
        _builder.append((Object)_pascalize_8, "");
        _builder.append((Object)"UriBuilder(");
        ContentUri _uri_4 = action.getUri();
        String _methodArgsSig_1 = this.toMethodArgsSig(_uri_4);
        _builder.append((Object)_methodArgsSig_1, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return new ");
        String _name_17 = action.getName();
        String _pascalize_9 = Strings.pascalize(_name_17);
        _builder.append((Object)_pascalize_9, "\t");
        _builder.append((Object)"UriBuilder(");
        ContentUri _uri_5 = action.getUri();
        String _methodArgs = this.toMethodArgs(_uri_5);
        _builder.append((Object)_methodArgs, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String asString(ContentUri uri) {
        StringBuilder builder = new StringBuilder();
        EList<ContentUriSegment> _segments = uri.getSegments();
        for (ContentUriSegment seg : _segments) {
            builder.append("/");
            if (seg instanceof ContentUriParamSegment) {
                ContentUriParamSegment param = (ContentUriParamSegment)seg;
                StringBuilder _append = builder.append("{");
                ColumnSource _param = param.getParam();
                String _name = _param.getName();
                StringBuilder _append_1 = _append.append(_name);
                _append_1.append("}");
                continue;
            }
            String _name_1 = seg.getName();
            builder.append(_name_1);
        }
        return builder.toString();
    }

    public Iterable<ActionStatement> findActionsForDefinition(MickeyDatabaseModel model, final String defName) {
        Functions.Function1<ActionStatement, Boolean> _function = new Functions.Function1<ActionStatement, Boolean>(){

            public Boolean apply(ActionStatement action) {
                TableDefinition _type = action.getType();
                String _name = _type.getName();
                return _name.equals(defName);
            }
        };
        return IterableExtensions.filter(model.actions, (Functions.Function1)_function);
    }

    public String toMethodArgsSig(ContentUri uri) {
        EList<ContentUriSegment> _segments = uri.getSegments();
        Iterable _filter = Iterables.filter(_segments, ContentUriParamSegment.class);
        Functions.Function1<ContentUriParamSegment, CharSequence> _function = new Functions.Function1<ContentUriParamSegment, CharSequence>(){

            public CharSequence apply(ContentUriParamSegment seg) {
                boolean _notEquals;
                ColumnSource _param = seg.getParam();
                ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
                boolean bl = _notEquals = !Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
                if (_notEquals) {
                    ColumnSource _param_1 = seg.getParam();
                    String _name = _param_1.getName();
                    String _camelize = Strings.camelize(_name);
                    return "long " + _camelize;
                }
                ColumnSource _param_2 = seg.getParam();
                String _name_1 = _param_2.getName();
                String _camelize_1 = Strings.camelize(_name_1);
                return "String " + _camelize_1;
            }
        };
        return IterableExtensions.join((Iterable)_filter, (CharSequence)", ", (Functions.Function1)_function);
    }

    public String toMethodArgs(ContentUri uri) {
        EList<ContentUriSegment> _segments = uri.getSegments();
        Iterable _filter = Iterables.filter(_segments, ContentUriParamSegment.class);
        Functions.Function1<ContentUriParamSegment, CharSequence> _function = new Functions.Function1<ContentUriParamSegment, CharSequence>(){

            public CharSequence apply(ContentUriParamSegment seg) {
                boolean _notEquals;
                ColumnSource _param = seg.getParam();
                ColumnType _inferredColumnType = ModelUtil.getInferredColumnType(_param);
                boolean bl = _notEquals = !Objects.equal((Object)((Object)_inferredColumnType), (Object)((Object)ColumnType.TEXT));
                if (_notEquals) {
                    ColumnSource _param_1 = seg.getParam();
                    String _name = _param_1.getName();
                    return Strings.camelize(_name);
                }
                ColumnSource _param_2 = seg.getParam();
                String _name_1 = _param_2.getName();
                return Strings.camelize(_name_1);
            }
        };
        return IterableExtensions.join((Iterable)_filter, (CharSequence)", ", (Functions.Function1)_function);
    }

    public boolean hasMethodArgs(ContentUri uri) {
        EList<ContentUriSegment> _segments = uri.getSegments();
        Iterable _filter = Iterables.filter(_segments, ContentUriParamSegment.class);
        int _size = IterableExtensions.size((Iterable)_filter);
        return _size > 0;
    }

    public CharSequence generateContractItem(MickeyDatabaseModel model, SqliteDatabaseSnapshot snapshot, TableDefinition stmt, ContentUris content) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* <p>Column definitions and helper methods to work with the ");
        String _name = stmt.getName();
        String _pascalize = Strings.pascalize(_name);
        _builder.append((Object)_pascalize, " ");
        _builder.append((Object)".</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public static class ");
        String _name_1 = stmt.getName();
        String _pascalize_1 = Strings.pascalize(_name_1);
        _builder.append((Object)_pascalize_1, "");
        _builder.append((Object)" implements ");
        String _name_2 = stmt.getName();
        String _pascalize_2 = Strings.pascalize(_name_2);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"Columns");
        boolean _hasAndroidPrimaryKey = this.hasAndroidPrimaryKey(stmt);
        if (_hasAndroidPrimaryKey) {
            _builder.append((Object)", BaseColumns");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static final Uri CONTENT_URI = ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"BASE_CONTENT_URI.buildUpon().appendPath(\"");
        String _name_3 = stmt.getName();
        _builder.append((Object)_name_3, "\t\t\t");
        _builder.append((Object)"\").build();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>The content type for a cursor that contains many ");
        String _name_4 = stmt.getName();
        String _pascalize_3 = Strings.pascalize(_name_4);
        _builder.append((Object)_pascalize_3, "\t ");
        _builder.append((Object)" rows.</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static final String CONTENT_TYPE =");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"\"vnd.android.cursor.dir/vnd.");
        String _databaseName = model.getDatabaseName();
        String _lowerCase = _databaseName.toLowerCase();
        _builder.append((Object)_lowerCase, "            ");
        _builder.append((Object)".");
        String _name_5 = stmt.getName();
        _builder.append((Object)_name_5, "            ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>The content type for a cursor that contains a single ");
        String _name_6 = stmt.getName();
        String _pascalize_4 = Strings.pascalize(_name_6);
        _builder.append((Object)_pascalize_4, "\t ");
        _builder.append((Object)" row.</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final String ITEM_CONTENT_TYPE =");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"\"vnd.android.cursor.item/vnd.");
        String _databaseName_1 = model.getDatabaseName();
        String _lowerCase_1 = _databaseName_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "\t\t");
        _builder.append((Object)".");
        String _name_7 = stmt.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Builds a Uri with appended id for a row in ");
        String _name_8 = stmt.getName();
        String _pascalize_5 = Strings.pascalize(_name_8);
        _builder.append((Object)_pascalize_5, "\t ");
        _builder.append((Object)", ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* eg:- ");
        String _name_9 = stmt.getName();
        String _lowerCase_2 = _name_9.toLowerCase();
        _builder.append((Object)_lowerCase_2, "\t ");
        _builder.append((Object)"/123.</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static Uri buildUriWithId(long id) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return CONTENT_URI.buildUpon().appendPath(String.valueOf(id)).build();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name_10 = stmt.getName();
        Iterable<ActionStatement> actions = this.findActionsForDefinition(model, _name_10);
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal(actions, null);
        if (_notEquals) {
            for (ActionStatement action : actions) {
                _builder.append((Object)"\t");
                CharSequence _createActionUriBuilder = this.createActionUriBuilder(action);
                _builder.append((Object)_createActionUriBuilder, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
            }
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public static int delete() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Mickey.getContentResolver().delete(");
        String _name_11 = stmt.getName();
        String _pascalize_6 = Strings.pascalize(_name_11);
        _builder.append((Object)_pascalize_6, "\t\t");
        _builder.append((Object)".CONTENT_URI, null, null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static int delete(String where, String[] selectionArgs) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Mickey.getContentResolver().delete(");
        String _name_12 = stmt.getName();
        String _pascalize_7 = Strings.pascalize(_name_12);
        _builder.append((Object)_pascalize_7, "\t\t");
        _builder.append((Object)".CONTENT_URI, where, selectionArgs);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Create a new Builder for ");
        String _name_13 = stmt.getName();
        String _pascalize_8 = Strings.pascalize(_name_13);
        _builder.append((Object)_pascalize_8, "\t ");
        _builder.append((Object)"</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static Builder newBuilder() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new Builder();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Create a new Builder for ");
        String _name_14 = stmt.getName();
        String _pascalize_9 = Strings.pascalize(_name_14);
        _builder.append((Object)_pascalize_9, "\t ");
        _builder.append((Object)"</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static Builder newBuilder(Uri contentUri) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new Builder(contentUri);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Build and execute insert or update statements for ");
        String _name_15 = stmt.getName();
        String _pascalize_10 = Strings.pascalize(_name_15);
        _builder.append((Object)_pascalize_10, "\t ");
        _builder.append((Object)".</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* <p>Use {@link ");
        String _name_16 = stmt.getName();
        String _pascalize_11 = Strings.pascalize(_name_16);
        _builder.append((Object)_pascalize_11, "\t ");
        _builder.append((Object)"#newBuilder()} to create new builder</p>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static class Builder extends AbstractValuesBuilder {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private Builder(Uri contentUri) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super(Mickey.getApplicationContext(), contentUri);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private Builder() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"super(Mickey.getApplicationContext(), ");
        String _name_17 = stmt.getName();
        String _pascalize_12 = Strings.pascalize(_name_17);
        _builder.append((Object)_pascalize_12, "\t\t\t");
        _builder.append((Object)".CONTENT_URI);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateBuilderSetters = this.generateBuilderSetters(stmt);
        _builder.append((Object)_generateBuilderSetters, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static final Set<Uri> VIEW_URIS;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"HashSet<Uri> viewUris =  new HashSet<Uri>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        HashSet<CreateViewStatement> _allViewsReferencingTable = ModelUtil.getAllViewsReferencingTable(snapshot, stmt);
        Functions.Function1<CreateViewStatement, String> _function = new Functions.Function1<CreateViewStatement, String>(){

            public String apply(CreateViewStatement x) {
                return x.getName();
            }
        };
        List views = IterableExtensions.sortBy(_allViewsReferencingTable, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        HashSet<CreateViewStatement> _allViewsInConfigInitReferencingTable = ModelUtil.getAllViewsInConfigInitReferencingTable(model, stmt);
        Functions.Function1<CreateViewStatement, String> _function_1 = new Functions.Function1<CreateViewStatement, String>(){

            public String apply(CreateViewStatement x) {
                return x.getName();
            }
        };
        List initViews = IterableExtensions.sortBy(_allViewsInConfigInitReferencingTable, (Functions.Function1)_function_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        for (CreateViewStatement ref : views) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"viewUris.add(");
            String _name_18 = ref.getName();
            String _pascalize_13 = Strings.pascalize(_name_18);
            _builder.append((Object)_pascalize_13, "\t\t");
            _builder.append((Object)".CONTENT_URI);");
            _builder.newLineIfNotEmpty();
        }
        for (CreateViewStatement ref_1 : initViews) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"viewUris.add(");
            String _name_19 = ref_1.getName();
            String _pascalize_14 = Strings.pascalize(_name_19);
            _builder.append((Object)_pascalize_14, "\t\t");
            _builder.append((Object)".CONTENT_URI);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"VIEW_URIS = Collections.unmodifiableSet(viewUris);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateBuilderSetters(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public Builder set");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"(");
            ColumnType _type = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" value) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"mValues.put(");
            String _name_1 = stmt.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)".");
            String _name_2 = col.getName();
            String _underscore = Strings.underscore(_name_2);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
            _builder.append((Object)", value);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateBuilderSetters(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public Builder set");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"(");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" value) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"mValues.put(");
            String _name_1 = stmt.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)".");
            String _name_2 = col.getName();
            String _underscore = Strings.underscore(_name_2);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
            _builder.append((Object)", value);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected String _getName(CreateTableStatement stmt) {
        return stmt.getName();
    }

    protected String _getName(CreateViewStatement stmt) {
        return stmt.getName();
    }

    protected boolean _hasAndroidPrimaryKey(CreateTableStatement stmt) {
        return ModelUtil.hasAndroidPrimaryKey(stmt);
    }

    protected boolean _hasAndroidPrimaryKey(CreateViewStatement stmt) {
        return ModelUtil.hasAndroidPrimaryKey(stmt);
    }

    public CharSequence createMethodArgsFromColumns(CreateTableStatement tbl) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = tbl.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (ColumnSource item : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            ColumnDef col = (ColumnDef)item;
            ColumnType _type = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" ");
            String _name = col.getName();
            String _camelize = Strings.camelize(_name);
            _builder.append((Object)_camelize, "");
        }
        return _builder;
    }

    public CharSequence generateInterfaceMemberForResultColumn(ColumnSource expr) {
        String _name_2;
        boolean _equals_1;
        boolean _not_1;
        String _name_1;
        boolean _equals;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean _and_1 = false;
        String _name = expr.getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
        _and_1 = !_notEquals ? false : (_not = !(_equals = (_name_1 = expr.getName()).equals("")));
        _and = !_and_1 ? false : (_not_1 = !(_equals_1 = (_name_2 = expr.getName()).equals("_id")));
        if (_and) {
            _builder.append((Object)"String ");
            String _name_3 = expr.getName();
            String _underscore = Strings.underscore(_name_3);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = \"");
            String _name_4 = expr.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateBuilderSetters(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateBuilderSetters((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateBuilderSetters((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public String getName(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._getName((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._getName((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public boolean hasAndroidPrimaryKey(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._hasAndroidPrimaryKey((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._hasAndroidPrimaryKey((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }
}

