/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb.generator;

import com.google.common.base.Objects;
import com.justeat.mickeydb.ModelUtil;
import com.justeat.mickeydb.Strings;
import com.justeat.mickeydb.mickeyLang.ColumnDef;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnType;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.ResultColumn;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ActiveRecordGenerator {
    public CharSequence generate(String packageName, String databaseName, TableDefinition stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Generated by Mickey DB");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import android.content.ContentResolver;");
        _builder.newLine();
        _builder.append((Object)"import android.database.Cursor;");
        _builder.newLine();
        _builder.append((Object)"import android.os.Bundle;");
        _builder.newLine();
        _builder.append((Object)"import android.os.Parcel;");
        _builder.newLine();
        _builder.append((Object)"import android.os.Parcelable;");
        _builder.newLine();
        _builder.append((Object)"import android.net.Uri;");
        _builder.newLine();
        _builder.append((Object)"import ");
        _builder.append((Object)packageName, "");
        _builder.append((Object)".");
        String _pascalize = Strings.pascalize(databaseName);
        _builder.append((Object)_pascalize, "");
        _builder.append((Object)"Contract.");
        String _name = stmt.getName();
        String _pascalize_1 = Strings.pascalize(_name);
        _builder.append((Object)_pascalize_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        _builder.append((Object)packageName, "");
        _builder.append((Object)".");
        String _pascalize_2 = Strings.pascalize(databaseName);
        _builder.append((Object)_pascalize_2, "");
        _builder.append((Object)"Contract.");
        String _name_1 = stmt.getName();
        String _pascalize_3 = Strings.pascalize(_name_1);
        _builder.append((Object)_pascalize_3, "");
        _builder.append((Object)".Builder;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.justeat.mickeydb.util.Closeables;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.ActiveRecord;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.ActiveRecordFactory;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.Mickey;");
        _builder.newLine();
        _builder.append((Object)"import com.justeat.mickeydb.AbstractValuesBuilder;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_2 = stmt.getName();
        String _pascalize_4 = Strings.pascalize(_name_2);
        _builder.append((Object)_pascalize_4, "");
        _builder.append((Object)"Record extends ActiveRecord implements Parcelable {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static ActiveRecordFactory<");
        String _name_3 = stmt.getName();
        String _pascalize_5 = Strings.pascalize(_name_3);
        _builder.append((Object)_pascalize_5, "\t");
        _builder.append((Object)"Record> sFactory = new ActiveRecordFactory<");
        String _name_4 = stmt.getName();
        String _pascalize_6 = Strings.pascalize(_name_4);
        _builder.append((Object)_pascalize_6, "\t");
        _builder.append((Object)"Record>() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _name_5 = stmt.getName();
        String _pascalize_7 = Strings.pascalize(_name_5);
        _builder.append((Object)_pascalize_7, "\t\t");
        _builder.append((Object)"Record create(Cursor c) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return fromCursor(c);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public String[] getProjection() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return PROJECTION;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public Uri getContentUri() {");
        _builder.newLine();
        _builder.append((Object)"\t\t    ");
        _builder.append((Object)"return ");
        String _name_6 = stmt.getName();
        String _pascalize_8 = Strings.pascalize(_name_6);
        _builder.append((Object)_pascalize_8, "\t\t    ");
        _builder.append((Object)".CONTENT_URI;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public static ActiveRecordFactory<");
        String _name_7 = stmt.getName();
        String _pascalize_9 = Strings.pascalize(_name_7);
        _builder.append((Object)_pascalize_9, "");
        _builder.append((Object)"Record> getFactory() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return sFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static final Parcelable.Creator<");
        String _name_8 = stmt.getName();
        String _pascalize_10 = Strings.pascalize(_name_8);
        _builder.append((Object)_pascalize_10, "    ");
        _builder.append((Object)"Record> CREATOR ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"= new Parcelable.Creator<");
        String _name_9 = stmt.getName();
        String _pascalize_11 = Strings.pascalize(_name_9);
        _builder.append((Object)_pascalize_11, "    \t");
        _builder.append((Object)"Record>() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"public ");
        String _name_10 = stmt.getName();
        String _pascalize_12 = Strings.pascalize(_name_10);
        _builder.append((Object)_pascalize_12, "        ");
        _builder.append((Object)"Record createFromParcel(Parcel in) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"return new ");
        String _name_11 = stmt.getName();
        String _pascalize_13 = Strings.pascalize(_name_11);
        _builder.append((Object)_pascalize_13, "            ");
        _builder.append((Object)"Record(in);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public ");
        String _name_12 = stmt.getName();
        String _pascalize_14 = Strings.pascalize(_name_12);
        _builder.append((Object)_pascalize_14, "        ");
        _builder.append((Object)"Record[] newArray(int size) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)"return new ");
        String _name_13 = stmt.getName();
        String _pascalize_15 = Strings.pascalize(_name_13);
        _builder.append((Object)_pascalize_15, "            ");
        _builder.append((Object)"Record[size];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static String[] PROJECTION = {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        CharSequence _generateProjectionArrayMembers = this.generateProjectionArrayMembers(stmt);
        _builder.append((Object)_generateProjectionArrayMembers, "    \t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public interface Indices {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        CharSequence _generateProjectionIndicesMembers = this.generateProjectionIndicesMembers(stmt);
        _builder.append((Object)_generateProjectionIndicesMembers, "    \t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateFields = this.generateFields(stmt);
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"protected String[] _getProjection() {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"return PROJECTION;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _generateAccessors = this.generateAccessors(stmt);
        _builder.append((Object)_generateAccessors, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public ");
        String _name_14 = stmt.getName();
        String _pascalize_16 = Strings.pascalize(_name_14);
        _builder.append((Object)_pascalize_16, "    ");
        _builder.append((Object)"Record() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"super(");
        String _name_15 = stmt.getName();
        String _pascalize_17 = Strings.pascalize(_name_15);
        _builder.append((Object)_pascalize_17, "    \t");
        _builder.append((Object)".CONTENT_URI);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _name_16 = stmt.getName();
        String _pascalize_18 = Strings.pascalize(_name_16);
        _builder.append((Object)_pascalize_18, "\t");
        _builder.append((Object)"Record(Parcel in) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"super(");
        String _name_17 = stmt.getName();
        String _pascalize_19 = Strings.pascalize(_name_17);
        _builder.append((Object)_pascalize_19, "    \t");
        _builder.append((Object)".CONTENT_URI);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setId(in.readLong());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateParcelDeserializationStatements = this.generateParcelDeserializationStatements(stmt);
        _builder.append((Object)_generateParcelDeserializationStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int describeContents() {");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"return 0;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void writeToParcel(Parcel dest, int flags) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dest.writeLong(getId());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateParcelSerializationStatements = this.generateParcelSerializationStatements(stmt);
        _builder.append((Object)_generateParcelSerializationStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected AbstractValuesBuilder createBuilder() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Builder builder = ");
        String _name_18 = stmt.getName();
        String _pascalize_20 = Strings.pascalize(_name_18);
        _builder.append((Object)_pascalize_20, "\t\t");
        _builder.append((Object)".newBuilder();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateBuilderStatements = this.generateBuilderStatements(stmt);
        _builder.append((Object)_generateBuilderStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return builder;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void makeDirty(boolean dirty){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateMakeDirtyStatements = this.generateMakeDirtyStatements(stmt);
        _builder.append((Object)_generateMakeDirtyStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void setPropertiesFromCursor(Cursor c) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setId(c.getLong(Indices._ID));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _generateSetFromCursorStatements = this.generateSetFromCursorStatements(stmt);
        _builder.append((Object)_generateSetFromCursorStatements, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_19 = stmt.getName();
        String _pascalize_21 = Strings.pascalize(_name_19);
        _builder.append((Object)_pascalize_21, "\t");
        _builder.append((Object)"Record fromCursor(Cursor c) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t    ");
        String _name_20 = stmt.getName();
        String _pascalize_22 = Strings.pascalize(_name_20);
        _builder.append((Object)_pascalize_22, "\t    ");
        _builder.append((Object)"Record item = new ");
        String _name_21 = stmt.getName();
        String _pascalize_23 = Strings.pascalize(_name_21);
        _builder.append((Object)_pascalize_23, "\t    ");
        _builder.append((Object)"Record();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t    ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"item.setPropertiesFromCursor(c);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"item.makeDirty(false);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"return item;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_22 = stmt.getName();
        String _pascalize_24 = Strings.pascalize(_name_22);
        _builder.append((Object)_pascalize_24, "\t");
        _builder.append((Object)"Record fromBundle(Bundle bundle, String key) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"bundle.setClassLoader(");
        String _name_23 = stmt.getName();
        String _pascalize_25 = Strings.pascalize(_name_23);
        _builder.append((Object)_pascalize_25, "\t\t");
        _builder.append((Object)"Record.class.getClassLoader());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return bundle.getParcelable(key);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_24 = stmt.getName();
        String _pascalize_26 = Strings.pascalize(_name_24);
        _builder.append((Object)_pascalize_26, "\t");
        _builder.append((Object)"Record get(long id) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"Cursor c = null;");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"ContentResolver resolver = Mickey.getContentResolver();");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"c = resolver.query(");
        String _name_25 = stmt.getName();
        String _pascalize_27 = Strings.pascalize(_name_25);
        _builder.append((Object)_pascalize_27, "\t        ");
        _builder.append((Object)".CONTENT_URI.buildUpon()");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".appendPath(String.valueOf(id)).build(), PROJECTION, null, null, null);");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"if(!c.moveToFirst()) {");
        _builder.newLine();
        _builder.append((Object)"\t            ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"return fromCursor(c);");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"} finally {");
        _builder.newLine();
        _builder.append((Object)"\t        ");
        _builder.append((Object)"Closeables.closeSilently(c);");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetFromCursorStatements(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            ColumnType _type = col.getType();
            boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"set");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)"(c.getInt(Indices.");
                String _name_1 = col.getName();
                String _underscore = Strings.underscore(_name_1);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "");
                _builder.append((Object)") > 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ColumnType _type_1 = col.getType();
            boolean _equals_1 = Objects.equal((Object)((Object)_type_1), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"set");
                String _name_2 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_2);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)"(c.getBlob(Indices.");
                String _name_3 = col.getName();
                String _underscore_1 = Strings.underscore(_name_3);
                String _upperCase_1 = _underscore_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"set");
            String _name_4 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_4);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)"(c.get");
            ColumnType _type_2 = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type_2);
            String _pascalize_3 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"(Indices.");
            String _name_5 = col.getName();
            String _underscore_2 = Strings.underscore(_name_5);
            String _upperCase_2 = _underscore_2.toUpperCase();
            _builder.append((Object)_upperCase_2, "");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateSetFromCursorStatements(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"set");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)"(c.getInt(Indices.");
                String _name_1 = col.getName();
                String _underscore = Strings.underscore(_name_1);
                String _upperCase = _underscore.toUpperCase();
                _builder.append((Object)_upperCase, "");
                _builder.append((Object)") > 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _equals_1 = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"set");
                String _name_2 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_2);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)"(c.getBlob(Indices.");
                String _name_3 = col.getName();
                String _underscore_1 = Strings.underscore(_name_3);
                String _upperCase_1 = _underscore_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"set");
            String _name_4 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_4);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)"(c.get");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            String _pascalize_3 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"(Indices.");
            String _name_5 = col.getName();
            String _underscore_2 = Strings.underscore(_name_5);
            String _upperCase_2 = _underscore_2.toUpperCase();
            _builder.append((Object)_upperCase_2, "");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateMakeDirtyStatements(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource col : _filter) {
            _builder.append((Object)"m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"Dirty = dirty;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateMakeDirtyStatements(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource col : _filter) {
            _builder.append((Object)"m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"Dirty = dirty;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateBuilderStatements(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource col : _filter) {
            _builder.append((Object)"if(m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"Dirty) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"builder.set");
            String _name_1 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)"(m");
            String _name_2 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateBuilderStatements(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource col : _filter) {
            _builder.append((Object)"if(m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"Dirty) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"builder.set");
            String _name_1 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)"(m");
            String _name_2 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateParcelSerializationStatements(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            ColumnType _type = col.getType();
            boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"dest.writeInt(m");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)" ? 1 : 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ColumnType _type_1 = col.getType();
            boolean _equals_1 = Objects.equal((Object)((Object)_type_1), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"dest.writeByteArray(m");
                String _name_1 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_1);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"dest.write");
            ColumnType _type_2 = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type_2);
            String _pascalize_2 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)"(m");
            String _name_2 = col.getName();
            String _pascalize_3 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"dest.writeBooleanArray(new boolean[] {");
        _builder.newLine();
        EList<ColumnSource> _columnDefs_1 = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_columnDefs_1, (Functions.Function1)_function_1);
        boolean _hasElements = false;
        for (ColumnSource col_1 : _filter_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_3 = col_1.getName();
            String _pascalize_4 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_4, "\t");
            _builder.append((Object)"Dirty");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"});");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateParcelSerializationStatements(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"dest.writeInt(m");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)" ? 1 : 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _equals_1 = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"dest.writeByteArray(m");
                String _name_1 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_1);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"dest.write");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            String _pascalize_2 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)"(m");
            String _name_2 = col.getName();
            String _pascalize_3 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"dest.writeBooleanArray(new boolean[] {");
        _builder.newLine();
        Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(cols, (Functions.Function1)_function_1);
        boolean _hasElements = false;
        for (ColumnSource col_1 : _filter_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_3 = col_1.getName();
            String _pascalize_4 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_4, "\t");
            _builder.append((Object)"Dirty");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"});");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateParcelDeserializationStatements(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        int counter = -1;
        _builder.newLineIfNotEmpty();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            ColumnType _type = col.getType();
            boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"m");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)" = (in.readInt() > 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ColumnType _type_1 = col.getType();
            boolean _equals_1 = Objects.equal((Object)((Object)_type_1), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"m");
                String _name_1 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_1);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)" = in.createByteArray();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"m");
            String _name_2 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)" = in.read");
            ColumnType _type_2 = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type_2);
            String _pascalize_3 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"boolean[] dirtyFlags = new boolean[");
        EList<ColumnSource> _columnDefs_1 = stmt.getColumnDefs();
        int _size = _columnDefs_1.size();
        int _minus = _size - 1;
        _builder.append((Object)_minus, "");
        _builder.append((Object)"];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"in.readBooleanArray(dirtyFlags);");
        _builder.newLine();
        EList<ColumnSource> _columnDefs_2 = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_columnDefs_2, (Functions.Function1)_function_1);
        for (ColumnSource col_1 : _filter_1) {
            _builder.append((Object)"m");
            String _name_3 = col_1.getName();
            String _pascalize_4 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_4, "");
            _builder.append((Object)"Dirty = dirtyFlags[");
            _builder.append((Object)(++counter), "");
            _builder.append((Object)"];");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateParcelDeserializationStatements(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        int counter = -1;
        _builder.newLineIfNotEmpty();
        ArrayList<ColumnSource> cols = ModelUtil.getViewResultColumns(stmt);
        _builder.newLineIfNotEmpty();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(cols, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BOOLEAN));
            if (_equals) {
                _builder.append((Object)"m");
                String _name = col.getName();
                String _pascalize = Strings.pascalize(_name);
                _builder.append((Object)_pascalize, "");
                _builder.append((Object)" = (in.readInt() > 0);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _equals_1 = Objects.equal((Object)((Object)type), (Object)((Object)ColumnType.BLOB));
            if (_equals_1) {
                _builder.append((Object)"m");
                String _name_1 = col.getName();
                String _pascalize_1 = Strings.pascalize(_name_1);
                _builder.append((Object)_pascalize_1, "");
                _builder.append((Object)" = in.createByteArray();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"m");
            String _name_2 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_2, "");
            _builder.append((Object)" = in.read");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            String _pascalize_3 = Strings.pascalize(_javaTypeName);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"boolean[] dirtyFlags = new boolean[");
        int _size = cols.size();
        int _minus = _size - 1;
        _builder.append((Object)_minus, "");
        _builder.append((Object)"];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"in.readBooleanArray(dirtyFlags);");
        _builder.newLine();
        Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(cols, (Functions.Function1)_function_1);
        for (ColumnSource col_1 : _filter_1) {
            _builder.append((Object)"m");
            String _name_3 = col_1.getName();
            String _pascalize_4 = Strings.pascalize(_name_3);
            _builder.append((Object)_pascalize_4, "");
            _builder.append((Object)"Dirty = dirtyFlags[");
            _builder.append((Object)(++counter), "");
            _builder.append((Object)"];");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected String _getName(CreateTableStatement statement) {
        return statement.getName();
    }

    protected String _getName(CreateViewStatement statement) {
        return statement.getName();
    }

    protected CharSequence _generateProjectionArrayMembers(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        boolean _hasElements = false;
        for (ColumnSource col : _columnDefs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _name = stmt.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)".");
            String _name_1 = col.getName();
            String _underscore = Strings.underscore(_name_1);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateProjectionArrayMembers(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(stmt);
        boolean _hasElements = false;
        for (ColumnSource col : _viewResultColumns) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _name = stmt.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)".");
            String _name_1 = col.getName();
            String _underscore = Strings.underscore(_name_1);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateProjectionIndicesMembers(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        int counter = -1;
        _builder.newLineIfNotEmpty();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        for (ColumnSource col : _columnDefs) {
            _builder.append((Object)"int ");
            String _name = col.getName();
            String _underscore = Strings.underscore(_name);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = ");
            _builder.append((Object)(++counter), "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateProjectionIndicesMembers(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        int counter = -1;
        _builder.newLineIfNotEmpty();
        ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(stmt);
        for (ColumnSource col : _viewResultColumns) {
            _builder.append((Object)"int ");
            String _name = col.getName();
            String _underscore = Strings.underscore(_name);
            String _upperCase = _underscore.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = ");
            _builder.append((Object)(++counter), "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateFields(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private ");
            ColumnType _type = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private boolean m");
            String _name_1 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "");
            _builder.append((Object)"Dirty;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateFields(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(stmt);
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_viewResultColumns, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private ");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" m");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private boolean m");
            String _name_1 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_1);
            _builder.append((Object)_pascalize_1, "");
            _builder.append((Object)"Dirty;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateAccessors(CreateTableStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_columnDefs, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ColumnDef col = (ColumnDef)item;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public void set");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"(");
            ColumnType _type = col.getType();
            String _javaTypeName = ModelUtil.toJavaTypeName(_type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" ");
            String _name_1 = col.getName();
            String _camelize = Strings.camelize(_name_1);
            _builder.append((Object)_camelize, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_2 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)" = ");
            String _name_3 = col.getName();
            String _camelize_1 = Strings.camelize(_name_3);
            _builder.append((Object)_camelize_1, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_4 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_4);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)"Dirty = true;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"public ");
            ColumnType _type_1 = col.getType();
            String _javaTypeName_1 = ModelUtil.toJavaTypeName(_type_1);
            _builder.append((Object)_javaTypeName_1, "");
            _builder.append((Object)" get");
            String _name_5 = col.getName();
            String _pascalize_3 = Strings.pascalize(_name_5);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return m");
            String _name_6 = col.getName();
            String _pascalize_4 = Strings.pascalize(_name_6);
            _builder.append((Object)_pascalize_4, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateAccessors(CreateViewStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(stmt);
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                boolean _equals = _name.equals("_id");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter(_viewResultColumns, (Functions.Function1)_function);
        for (ColumnSource item : _filter) {
            ResultColumn col = (ResultColumn)item;
            _builder.newLineIfNotEmpty();
            ColumnType type = ModelUtil.getInferredColumnType(col);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public void set");
            String _name = col.getName();
            String _pascalize = Strings.pascalize(_name);
            _builder.append((Object)_pascalize, "");
            _builder.append((Object)"(");
            String _javaTypeName = ModelUtil.toJavaTypeName(type);
            _builder.append((Object)_javaTypeName, "");
            _builder.append((Object)" ");
            String _name_1 = col.getName();
            String _camelize = Strings.camelize(_name_1);
            _builder.append((Object)_camelize, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_2 = col.getName();
            String _pascalize_1 = Strings.pascalize(_name_2);
            _builder.append((Object)_pascalize_1, "\t");
            _builder.append((Object)" = ");
            String _name_3 = col.getName();
            String _camelize_1 = Strings.camelize(_name_3);
            _builder.append((Object)_camelize_1, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"m");
            String _name_4 = col.getName();
            String _pascalize_2 = Strings.pascalize(_name_4);
            _builder.append((Object)_pascalize_2, "\t");
            _builder.append((Object)"Dirty = true;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"public ");
            String _javaTypeName_1 = ModelUtil.toJavaTypeName(type);
            _builder.append((Object)_javaTypeName_1, "");
            _builder.append((Object)" get");
            String _name_5 = col.getName();
            String _pascalize_3 = Strings.pascalize(_name_5);
            _builder.append((Object)_pascalize_3, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return m");
            String _name_6 = col.getName();
            String _pascalize_4 = Strings.pascalize(_name_6);
            _builder.append((Object)_pascalize_4, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateSetFromCursorStatements(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateSetFromCursorStatements((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateSetFromCursorStatements((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateMakeDirtyStatements(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateMakeDirtyStatements((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateMakeDirtyStatements((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateBuilderStatements(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateBuilderStatements((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateBuilderStatements((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateParcelSerializationStatements(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateParcelSerializationStatements((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateParcelSerializationStatements((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateParcelDeserializationStatements(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateParcelDeserializationStatements((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateParcelDeserializationStatements((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public String getName(TableDefinition statement) {
        if (statement instanceof CreateTableStatement) {
            return this._getName((CreateTableStatement)statement);
        }
        if (statement instanceof CreateViewStatement) {
            return this._getName((CreateViewStatement)statement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(statement).toString());
    }

    public CharSequence generateProjectionArrayMembers(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateProjectionArrayMembers((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateProjectionArrayMembers((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateProjectionIndicesMembers(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateProjectionIndicesMembers((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateProjectionIndicesMembers((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateFields(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateFields((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateFields((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public CharSequence generateAccessors(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return this._generateAccessors((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return this._generateAccessors((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }
}

