/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.AlterTableRenameStatement;
import com.justeat.mickeydb.mickeyLang.CastExpression;
import com.justeat.mickeydb.mickeyLang.ColumnDef;
import com.justeat.mickeydb.mickeyLang.ColumnSource;
import com.justeat.mickeydb.mickeyLang.ColumnSourceRef;
import com.justeat.mickeydb.mickeyLang.ColumnType;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.DDLStatement;
import com.justeat.mickeydb.mickeyLang.DMLStatement;
import com.justeat.mickeydb.mickeyLang.DeleteStatement;
import com.justeat.mickeydb.mickeyLang.ExprConcat;
import com.justeat.mickeydb.mickeyLang.Expression;
import com.justeat.mickeydb.mickeyLang.Function;
import com.justeat.mickeydb.mickeyLang.InsertStatement;
import com.justeat.mickeydb.mickeyLang.JoinSource;
import com.justeat.mickeydb.mickeyLang.JoinStatement;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MickeyLangPackage;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import com.justeat.mickeydb.mickeyLang.ResultColumn;
import com.justeat.mickeydb.mickeyLang.SelectCore;
import com.justeat.mickeydb.mickeyLang.SelectCoreExpression;
import com.justeat.mickeydb.mickeyLang.SelectExpression;
import com.justeat.mickeydb.mickeyLang.SelectList;
import com.justeat.mickeydb.mickeyLang.SelectSource;
import com.justeat.mickeydb.mickeyLang.SelectStatement;
import com.justeat.mickeydb.mickeyLang.SingleSource;
import com.justeat.mickeydb.mickeyLang.SingleSourceTable;
import com.justeat.mickeydb.mickeyLang.SqliteDataType;
import com.justeat.mickeydb.mickeyLang.TableDefinition;
import com.justeat.mickeydb.mickeyLang.UpdateStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ModelUtil {
    public static <T extends EObject> T getAncestorOfType(EObject obj, Class<T> ancestorType) {
        EObject temp = obj;
        while (!Objects.equal((Object)temp.eContainer(), null)) {
            EObject _eContainer = temp.eContainer();
            Class<?> _class = (temp = _eContainer).getClass();
            boolean _isAssignableFrom = ancestorType.isAssignableFrom(_class);
            if (!_isAssignableFrom) continue;
            return (T)temp;
        }
        return null;
    }

    public static void forEachPreviousStatement(DDLStatement stmt, Functions.Function1<DDLStatement, Boolean> delegate) {
        DDLStatement current = stmt;
        MigrationBlock migration = null;
        while (true) {
            if (!Objects.equal((Object)EcoreUtil2.getPreviousSibling((EObject)current), null)) {
                EObject _previousSibling = EcoreUtil2.getPreviousSibling((EObject)current);
                Boolean _apply = (Boolean)delegate.apply((Object)(current = _previousSibling));
                boolean _not = _apply == false;
                if (!_not) continue;
                return;
            }
            EObject _eContainer = current.eContainer();
            EObject previousContainer = EcoreUtil2.getPreviousSibling((EObject)_eContainer);
            boolean _and = false;
            boolean _notEquals = !Objects.equal((Object)previousContainer, null);
            _and = !_notEquals ? false : previousContainer instanceof MigrationBlock;
            if (_and) {
                boolean _not;
                migration = (MigrationBlock)previousContainer;
                EList<DDLStatement> _statements = migration.getStatements();
                DDLStatement _last = (DDLStatement)IterableExtensions.last(_statements);
                current = _last;
                boolean _equals = Objects.equal((Object)current, null);
                if (_equals) {
                    return;
                }
                Boolean _apply = (Boolean)delegate.apply((Object)current);
                boolean bl = _not = _apply == false;
                if (_not) {
                    return;
                }
            } else {
                migration = null;
            }
            if (Objects.equal((Object)migration, null)) break;
        }
    }

    public static ArrayList<EObject> getAllReferenceableSingleSources(SelectCoreExpression expr) {
        ArrayList items = Lists.newArrayList();
        if (expr instanceof SelectCore) {
            SelectCoreExpression _left = ((SelectCore)expr).getLeft();
            ArrayList<EObject> _allReferenceableSingleSources = ModelUtil.getAllReferenceableSingleSources(_left);
            items.addAll(_allReferenceableSingleSources);
            SelectCoreExpression _right = ((SelectCore)expr).getRight();
            ArrayList<EObject> _allReferenceableSingleSources_1 = ModelUtil.getAllReferenceableSingleSources(_right);
            items.addAll(_allReferenceableSingleSources_1);
        } else if (expr instanceof SelectExpression) {
            ArrayList<SingleSource> _findAllSingleSources = ModelUtil.findAllSingleSources((SelectExpression)expr);
            items.addAll(_findAllSingleSources);
        }
        return items;
    }

    public static ArrayList<SingleSource> findAllSingleSources(SelectExpression expr) {
        ArrayList items = Lists.newArrayList();
        JoinSource _source = expr.getSource();
        SingleSource _source_1 = _source.getSource();
        items.add(_source_1);
        JoinSource _source_2 = expr.getSource();
        EList<JoinStatement> _joinStatements = _source_2.getJoinStatements();
        for (JoinStatement join : _joinStatements) {
            SingleSource _singleSource = join.getSingleSource();
            items.add(_singleSource);
        }
        return items;
    }

    public static ColumnType toColumnType(SqliteDataType dt) {
        if (dt != null) {
            switch (dt) {
                case BLOB: {
                    return ColumnType.BLOB;
                }
                case INTEGER: {
                    return ColumnType.INTEGER;
                }
                case REAL: {
                    return ColumnType.REAL;
                }
                case TEXT: {
                    return ColumnType.TEXT;
                }
                case NONE: {
                    return ColumnType.TEXT;
                }
                case NUMERIC: {
                    return ColumnType.TEXT;
                }
            }
        }
        return ColumnType.TEXT;
    }

    public static String toJavaTypeName(ColumnType type) {
        if (type != null) {
            switch (type) {
                case TEXT: {
                    return "String";
                }
                case INTEGER: {
                    return "long";
                }
                case REAL: {
                    return "double";
                }
                case BLOB: {
                    return "byte[]";
                }
                case BOOLEAN: {
                    return "boolean";
                }
            }
        }
        return "!!ERROR!!";
    }

    public static ColumnType getInferredColumnType(ResultColumn col) {
        Expression expr = col.getExpression();
        return ModelUtil.getInferredColumnType(expr);
    }

    public static ColumnType getInferredColumnType(ColumnSource col) {
        boolean _matched = false;
        if (!_matched && col instanceof ColumnDef) {
            _matched = true;
            return ((ColumnDef)col).getType();
        }
        if (!_matched && col instanceof ResultColumn) {
            _matched = true;
            Expression _expression = ((ResultColumn)col).getExpression();
            return ModelUtil.getInferredColumnType(_expression);
        }
        return ColumnType.TEXT;
    }

    public static ColumnType getInferredColumnType(Expression expr) {
        boolean _matched = false;
        if (!_matched && expr instanceof CastExpression) {
            _matched = true;
            SqliteDataType _type = ((CastExpression)expr).getType();
            return ModelUtil.toColumnType(_type);
        }
        if (!_matched && expr instanceof ColumnSourceRef) {
            _matched = true;
            ColumnSource _column = ((ColumnSourceRef)expr).getColumn();
            if (_column instanceof ResultColumn) {
                SelectSource _source = ((ColumnSourceRef)expr).getSource();
                boolean _equals = Objects.equal((Object)_source, null);
                if (_equals) {
                    return ColumnType.TEXT;
                }
                ColumnSource _column_1 = ((ColumnSourceRef)expr).getColumn();
                Expression _expression = ((ResultColumn)_column_1).getExpression();
                return ModelUtil.getInferredColumnType(_expression);
            }
            ColumnSource _column_2 = ((ColumnSourceRef)expr).getColumn();
            return ((ColumnDef)_column_2).getType();
        }
        if (!_matched && expr instanceof ExprConcat) {
            _matched = true;
            return ColumnType.TEXT;
        }
        if (!_matched && expr instanceof Function) {
            _matched = true;
            boolean _or = false;
            boolean _or_1 = false;
            boolean _or_2 = false;
            boolean _or_3 = false;
            boolean _or_4 = false;
            String _name = ((Function)expr).getName();
            boolean _equalsIgnoreCase = _name.equalsIgnoreCase("count");
            if (_equalsIgnoreCase) {
                _or_4 = true;
            } else {
                boolean _equalsIgnoreCase_1;
                String _name_1 = ((Function)expr).getName();
                _or_4 = _equalsIgnoreCase_1 = _name_1.equalsIgnoreCase("length");
            }
            if (_or_4) {
                _or_3 = true;
            } else {
                boolean _equalsIgnoreCase_2;
                String _name_2 = ((Function)expr).getName();
                _or_3 = _equalsIgnoreCase_2 = _name_2.equalsIgnoreCase("random");
            }
            if (_or_3) {
                _or_2 = true;
            } else {
                boolean _equalsIgnoreCase_3;
                String _name_3 = ((Function)expr).getName();
                _or_2 = _equalsIgnoreCase_3 = _name_3.equalsIgnoreCase("last_insert_rowid");
            }
            if (_or_2) {
                _or_1 = true;
            } else {
                boolean _equalsIgnoreCase_4;
                String _name_4 = ((Function)expr).getName();
                _or_1 = _equalsIgnoreCase_4 = _name_4.equalsIgnoreCase("changes");
            }
            if (_or_1) {
                _or = true;
            } else {
                boolean _equalsIgnoreCase_5;
                String _name_5 = ((Function)expr).getName();
                _or = _equalsIgnoreCase_5 = _name_5.equalsIgnoreCase("total_changes");
            }
            if (_or) {
                return ColumnType.INTEGER;
            }
            boolean _or_5 = false;
            boolean _or_6 = false;
            boolean _or_7 = false;
            boolean _or_8 = false;
            boolean _or_9 = false;
            String _name_6 = ((Function)expr).getName();
            boolean _equalsIgnoreCase_6 = _name_6.equalsIgnoreCase("abs");
            if (_equalsIgnoreCase_6) {
                _or_9 = true;
            } else {
                boolean _equalsIgnoreCase_7;
                String _name_7 = ((Function)expr).getName();
                _or_9 = _equalsIgnoreCase_7 = _name_7.equalsIgnoreCase("avg");
            }
            if (_or_9) {
                _or_8 = true;
            } else {
                boolean _equalsIgnoreCase_8;
                String _name_8 = ((Function)expr).getName();
                _or_8 = _equalsIgnoreCase_8 = _name_8.equalsIgnoreCase("round");
            }
            if (_or_8) {
                _or_7 = true;
            } else {
                boolean _equalsIgnoreCase_9;
                String _name_9 = ((Function)expr).getName();
                _or_7 = _equalsIgnoreCase_9 = _name_9.equalsIgnoreCase("sum");
            }
            if (_or_7) {
                _or_6 = true;
            } else {
                boolean _equalsIgnoreCase_10;
                String _name_10 = ((Function)expr).getName();
                _or_6 = _equalsIgnoreCase_10 = _name_10.equalsIgnoreCase("total");
            }
            if (_or_6) {
                _or_5 = true;
            } else {
                boolean _equalsIgnoreCase_11;
                String _name_11 = ((Function)expr).getName();
                _or_5 = _equalsIgnoreCase_11 = _name_11.equalsIgnoreCase("likelihood");
            }
            if (_or_5) {
                return ColumnType.REAL;
            }
            boolean _or_10 = false;
            String _name_12 = ((Function)expr).getName();
            boolean _equalsIgnoreCase_12 = _name_12.equalsIgnoreCase("randomblob");
            if (_equalsIgnoreCase_12) {
                _or_10 = true;
            } else {
                boolean _equalsIgnoreCase_13;
                String _name_13 = ((Function)expr).getName();
                _or_10 = _equalsIgnoreCase_13 = _name_13.equalsIgnoreCase("zeroblob");
            }
            if (_or_10) {
                return ColumnType.BLOB;
            }
            return ColumnType.TEXT;
        }
        return ColumnType.TEXT;
    }

    public static ArrayList<ColumnSource> getViewResultColumns(CreateViewStatement stmt) {
        ArrayList<ColumnSource> result = new ArrayList<ColumnSource>();
        SelectStatement _selectStatement = stmt.getSelectStatement();
        SelectCoreExpression coreExpr = _selectStatement.getCore();
        if (coreExpr instanceof SelectCore) {
            boolean _notEquals;
            SelectCore core = (SelectCore)coreExpr;
            SelectCoreExpression _right = core.getRight();
            SelectList selectList = ((SelectExpression)_right).getSelectList();
            boolean bl = _notEquals = !Objects.equal((Object)selectList, null);
            if (_notEquals) {
                EList<ColumnSource> _resultColumns = selectList.getResultColumns();
                Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

                    public Boolean apply(ColumnSource it) {
                        String _name_1;
                        boolean _equals;
                        boolean _not;
                        boolean _notEquals;
                        boolean _and = false;
                        String _name = it.getName();
                        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
                        _and = !_notEquals ? false : (_not = !(_equals = (_name_1 = it.getName()).equals("")));
                        return _and;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_resultColumns, (Functions.Function1)_function);
                Iterables.addAll(result, (Iterable)_filter);
            }
        } else {
            boolean _notEquals_1;
            SelectList selectList_1 = ((SelectExpression)coreExpr).getSelectList();
            boolean bl = _notEquals_1 = !Objects.equal((Object)selectList_1, null);
            if (_notEquals_1) {
                EList<ColumnSource> _resultColumns_1 = selectList_1.getResultColumns();
                Functions.Function1<ColumnSource, Boolean> _function_1 = new Functions.Function1<ColumnSource, Boolean>(){

                    public Boolean apply(ColumnSource it) {
                        String _name_1;
                        boolean _equals;
                        boolean _not;
                        boolean _notEquals;
                        boolean _and = false;
                        String _name = it.getName();
                        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
                        _and = !_notEquals ? false : (_not = !(_equals = (_name_1 = it.getName()).equals("")));
                        return _and;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter(_resultColumns_1, (Functions.Function1)_function_1);
                Iterables.addAll(result, (Iterable)_filter_1);
            }
        }
        return result;
    }

    public static HashSet<CreateViewStatement> getAllViewsReferencingTable(SqliteDatabaseSnapshot snapshot, TableDefinition tableDef) {
        HashSet<CreateViewStatement> matches = new HashSet<CreateViewStatement>();
        ArrayList<CreateViewStatement> _views = snapshot.getViews();
        for (CreateViewStatement view : _views) {
            boolean _isDefinitionReferencedByView = ModelUtil.isDefinitionReferencedByView(tableDef, view);
            if (!_isDefinitionReferencedByView) continue;
            matches.add(view);
        }
        return matches;
    }

    public static HashSet<CreateViewStatement> getAllViewsInConfigInitReferencingTable(MickeyDatabaseModel model, TableDefinition tableDef) {
        HashSet<CreateViewStatement> matches = new HashSet<CreateViewStatement>();
        for (CreateViewStatement view : model.initViews) {
            boolean _isDefinitionReferencedByView = ModelUtil.isDefinitionReferencedByView(tableDef, view);
            if (!_isDefinitionReferencedByView) continue;
            matches.add(view);
        }
        return matches;
    }

    public static boolean isDefinitionReferencedByView(final TableDefinition tableDef, CreateViewStatement view) {
        TreeIterator _eAllContents = view.eAllContents();
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject obj) {
                if (obj instanceof SingleSourceTable) {
                    boolean _not;
                    SingleSourceTable sourceTable = (SingleSourceTable)obj;
                    TableDefinition _tableReference = sourceTable.getTableReference();
                    boolean bl = _not = !(_tableReference instanceof CreateViewStatement);
                    if (_not) {
                        String _name_1;
                        TableDefinition _tableReference_1 = sourceTable.getTableReference();
                        String _name = _tableReference_1.getName();
                        boolean _equals = _name.equals(_name_1 = tableDef.getName());
                        if (_equals) {
                            return true;
                        }
                    } else {
                        TableDefinition _tableReference_2 = sourceTable.getTableReference();
                        return ModelUtil.isDefinitionReferencedByView(tableDef, (CreateViewStatement)_tableReference_2);
                    }
                }
                return false;
            }
        };
        return IteratorExtensions.exists((Iterator)_eAllContents, (Functions.Function1)_function);
    }

    protected static boolean _hasAndroidPrimaryKey(CreateTableStatement stmt) {
        EList<ColumnSource> _columnDefs = stmt.getColumnDefs();
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                String _name = it.getName();
                return _name.equals("_id");
            }
        };
        return IterableExtensions.exists(_columnDefs, (Functions.Function1)_function);
    }

    protected static boolean _hasAndroidPrimaryKey(CreateViewStatement stmt) {
        ArrayList<ColumnSource> _viewResultColumns = ModelUtil.getViewResultColumns(stmt);
        Functions.Function1<ColumnSource, Boolean> _function = new Functions.Function1<ColumnSource, Boolean>(){

            public Boolean apply(ColumnSource it) {
                boolean _not;
                boolean _and = false;
                String _name = it.getName();
                boolean _isEmpty = Strings.isEmpty((String)_name);
                boolean bl = _not = !_isEmpty;
                if (!_not) {
                    _and = false;
                } else {
                    boolean _equals;
                    String _name_1 = it.getName();
                    _and = _equals = _name_1.equals("_id");
                }
                return _and;
            }
        };
        return IterableExtensions.exists(_viewResultColumns, (Functions.Function1)_function);
    }

    public static LinkedList<TableDefinition> getHistory(TableDefinition ref) {
        LinkedList<TableDefinition> refs = new LinkedList<TableDefinition>();
        TableDefinition current = ref;
        while (current instanceof AlterTableRenameStatement) {
            TableDefinition _table;
            refs.add(current);
            current = _table = ((AlterTableRenameStatement)current).getTable();
        }
        refs.add(current);
        return refs;
    }

    public static MickeyFile getModel(EObject ele) {
        EObject _eContainer;
        EObject e = ele;
        while (!((e = (_eContainer = e.eContainer())) instanceof MickeyFile)) {
        }
        return (MickeyFile)e;
    }

    public static Iterable<MigrationBlock> previousMigrations(EObject ele) {
        MigrationBlock _from;
        MigrationBlock migration = ModelUtil.getContainerOfType(ele, MigrationBlock.class);
        ArrayList<MigrationBlock> migrations = new ArrayList<MigrationBlock>();
        do {
            migrations.add(migration);
        } while (!Objects.equal((Object)(migration = (_from = migration.getFrom())), null));
        return migrations;
    }

    public static <T> T getContainerOfType(EObject element, Class<T> type) {
        EObject ele = element;
        do {
            EObject _eContainer;
            boolean _equals;
            if (!(_equals = Objects.equal((Object)(ele = (_eContainer = ele.eContainer())), null))) continue;
            return null;
        } while (!type.isAssignableFrom(ele.getClass()));
        return (T)ele;
    }

    public static String getFeatureNodeText(EObject obj, EReference reference) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)obj, (EStructuralFeature)reference);
        INode _get = (INode)nodes.get(0);
        return NodeModelUtils.getTokenText((INode)_get);
    }

    public static Object getAllColumnsForTableName(ArrayList<EObject> allContents, String tableName) {
        return null;
    }

    public static String getTargetTableName(DMLStatement statement) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && statement instanceof UpdateStatement) {
            _matched = true;
            _switchResult = ModelUtil.getFeatureNodeText(statement, MickeyLangPackage.Literals.UPDATE_STATEMENT__TABLE);
        }
        if (!_matched && statement instanceof InsertStatement) {
            _matched = true;
            _switchResult = ModelUtil.getFeatureNodeText(statement, MickeyLangPackage.Literals.INSERT_STATEMENT__TABLE);
        }
        if (!_matched && statement instanceof DeleteStatement) {
            _matched = true;
            _switchResult = ModelUtil.getFeatureNodeText(statement, MickeyLangPackage.Literals.DELETE_STATEMENT__TABLE);
        }
        return _switchResult;
    }

    public static boolean hasAndroidPrimaryKey(TableDefinition stmt) {
        if (stmt instanceof CreateTableStatement) {
            return ModelUtil._hasAndroidPrimaryKey((CreateTableStatement)stmt);
        }
        if (stmt instanceof CreateViewStatement) {
            return ModelUtil._hasAndroidPrimaryKey((CreateViewStatement)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }
}

