/*
 * Decompiled with CFR 0.152.
 */
package com.justeat.mickeydb;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.justeat.mickeydb.MickeyDatabaseModel;
import com.justeat.mickeydb.MickeyModel;
import com.justeat.mickeydb.generator.SqliteDatabaseSnapshot;
import com.justeat.mickeydb.mickeyLang.ActionStatement;
import com.justeat.mickeydb.mickeyLang.CreateTableStatement;
import com.justeat.mickeydb.mickeyLang.CreateTriggerStatement;
import com.justeat.mickeydb.mickeyLang.CreateViewStatement;
import com.justeat.mickeydb.mickeyLang.MickeyBlock;
import com.justeat.mickeydb.mickeyLang.MickeyFile;
import com.justeat.mickeydb.mickeyLang.MickeyFunction;
import com.justeat.mickeydb.mickeyLang.MigrationBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MickeyAssembler {
    @Inject
    private Provider<SqliteDatabaseSnapshot.Builder> mDbSnapshotBuilderProvider;

    public MickeyModel assemble(Resource resource) {
        ResourceSet _resourceSet = resource.getResourceSet();
        EList _resources = _resourceSet.getResources();
        Functions.Function1<Resource, MickeyFile> _function = new Functions.Function1<Resource, MickeyFile>(){

            public MickeyFile apply(Resource it) {
                TreeIterator _allContents = it.getAllContents();
                EObject _head = (EObject)IteratorExtensions.head((Iterator)_allContents);
                return (MickeyFile)_head;
            }
        };
        List _map = ListExtensions.map((List)_resources, (Functions.Function1)_function);
        return this.assemble(_map, null);
    }

    public MickeyModel assemble(Resource resource, MigrationBlock upToMigration) {
        ResourceSet _resourceSet = resource.getResourceSet();
        EList _resources = _resourceSet.getResources();
        Functions.Function1<Resource, MickeyFile> _function = new Functions.Function1<Resource, MickeyFile>(){

            public MickeyFile apply(Resource it) {
                TreeIterator _allContents = it.getAllContents();
                EObject _head = (EObject)IteratorExtensions.head((Iterator)_allContents);
                return (MickeyFile)_head;
            }
        };
        List _map = ListExtensions.map((List)_resources, (Functions.Function1)_function);
        return this.assemble(_map, upToMigration);
    }

    public MickeyModel assemble(List<MickeyFile> files) {
        return this.assemble(files, null);
    }

    public MickeyModel assemble(List<MickeyFile> files, final MigrationBlock upToMigration) {
        final MickeyModel mickeyModel = new MickeyModel();
        Consumer<MickeyFile> _function = new Consumer<MickeyFile>(){

            @Override
            public void accept(MickeyFile file) {
                MickeyAssembler.this.registerFile(mickeyModel, file);
            }
        };
        files.forEach(_function);
        Collection<MickeyDatabaseModel> _values = mickeyModel.databases.values();
        Consumer<MickeyDatabaseModel> _function_1 = new Consumer<MickeyDatabaseModel>(){

            @Override
            public void accept(MickeyDatabaseModel db) {
                MickeyAssembler.this.sortMigrations(db, upToMigration);
                Functions.Function1<CreateTableStatement, String> _function = new Functions.Function1<CreateTableStatement, String>(){

                    public String apply(CreateTableStatement x) {
                        return x.getName();
                    }
                };
                ListExtensions.sortInplaceBy(db.initTables, (Functions.Function1)_function);
                Functions.Function1<CreateViewStatement, String> _function_1 = new Functions.Function1<CreateViewStatement, String>(){

                    public String apply(CreateViewStatement x) {
                        return x.getName();
                    }
                };
                ListExtensions.sortInplaceBy(db.initViews, (Functions.Function1)_function_1);
                SqliteDatabaseSnapshot.Builder _get = (SqliteDatabaseSnapshot.Builder)MickeyAssembler.this.mDbSnapshotBuilderProvider.get();
                SqliteDatabaseSnapshot snapshot = _get.build(db);
                db.setSnapshot(snapshot);
                SqliteDatabaseSnapshot _snapshot = db.getSnapshot();
                ArrayList<CreateTableStatement> _tables = _snapshot.getTables();
                Functions.Function1<CreateTableStatement, String> _function_2 = new Functions.Function1<CreateTableStatement, String>(){

                    public String apply(CreateTableStatement x) {
                        return x.getName();
                    }
                };
                ListExtensions.sortInplaceBy(_tables, (Functions.Function1)_function_2);
                SqliteDatabaseSnapshot _snapshot_1 = db.getSnapshot();
                ArrayList<CreateViewStatement> _views = _snapshot_1.getViews();
                Functions.Function1<CreateViewStatement, String> _function_3 = new Functions.Function1<CreateViewStatement, String>(){

                    public String apply(CreateViewStatement x) {
                        return x.getName();
                    }
                };
                ListExtensions.sortInplaceBy(_views, (Functions.Function1)_function_3);
                SqliteDatabaseSnapshot _snapshot_2 = db.getSnapshot();
                ArrayList<CreateTriggerStatement> _triggers = _snapshot_2.getTriggers();
                Functions.Function1<CreateTriggerStatement, String> _function_4 = new Functions.Function1<CreateTriggerStatement, String>(){

                    public String apply(CreateTriggerStatement x) {
                        return x.getName();
                    }
                };
                ListExtensions.sortInplaceBy(_triggers, (Functions.Function1)_function_4);
            }
        };
        _values.forEach(_function_1);
        return mickeyModel;
    }

    private void sortMigrations(MickeyDatabaseModel db, MigrationBlock upToMigration) {
        Functions.Function1<MigrationBlock, Boolean> _function;
        Collection<MigrationBlock> _values = db.migrationsByName.values();
        MigrationBlock migration = (MigrationBlock)IterableExtensions.findFirst(_values, (Functions.Function1)(_function = new Functions.Function1<MigrationBlock, Boolean>(){

            public Boolean apply(MigrationBlock it) {
                MigrationBlock _from = it.getFrom();
                return Objects.equal((Object)_from, null);
            }
        }));
        boolean _equals = Objects.equal((Object)migration, null);
        if (_equals) {
            return;
        }
        while (!Objects.equal((Object)migration, null)) {
            MigrationBlock _get;
            boolean _notEquals;
            db.migrations.add(migration);
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)upToMigration, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = upToMigration.getName();
                String _name_1 = migration.getName();
                _and = _equals_1 = _name.equals(_name_1);
            }
            if (_and) {
                return;
            }
            String _name_2 = migration.getName();
            migration = _get = db.migrationsByFromName.get(_name_2);
        }
    }

    private MickeyDatabaseModel registerFile(MickeyModel model, MickeyFile file) {
        String _databaseName = file.getDatabaseName();
        MickeyDatabaseModel result = model.databases.get(_databaseName);
        boolean _equals = Objects.equal((Object)result, null);
        if (_equals) {
            MickeyDatabaseModel _mickeyDatabaseModel;
            String _databaseName_1 = file.getDatabaseName();
            result = _mickeyDatabaseModel = new MickeyDatabaseModel(_databaseName_1);
            String _databaseName_2 = file.getDatabaseName();
            model.databases.put(_databaseName_2, result);
        }
        final MickeyDatabaseModel db = result;
        EList<MickeyBlock> _blocks = file.getBlocks();
        Iterable _filter = Iterables.filter(_blocks, ActionStatement.class);
        Iterables.addAll(db.actions, (Iterable)_filter);
        EList<MickeyBlock> _blocks_1 = file.getBlocks();
        Iterable _filter_1 = Iterables.filter(_blocks_1, MickeyFunction.class);
        Iterables.addAll(db.functions, (Iterable)_filter_1);
        EList<MickeyBlock> _blocks_2 = file.getBlocks();
        Iterable _filter_2 = Iterables.filter(_blocks_2, CreateTableStatement.class);
        Iterables.addAll(db.initTables, (Iterable)_filter_2);
        EList<MickeyBlock> _blocks_3 = file.getBlocks();
        Iterable _filter_3 = Iterables.filter(_blocks_3, CreateViewStatement.class);
        Iterables.addAll(db.initViews, (Iterable)_filter_3);
        EList<MickeyBlock> _blocks_4 = file.getBlocks();
        Iterable migrations = Iterables.filter(_blocks_4, MigrationBlock.class);
        Consumer<MigrationBlock> _function = new Consumer<MigrationBlock>(){

            @Override
            public void accept(MigrationBlock it) {
                String _name = it.getName();
                db.migrationsByName.put(_name, it);
            }
        };
        migrations.forEach(_function);
        Consumer<MigrationBlock> _function_1 = new Consumer<MigrationBlock>(){

            @Override
            public void accept(MigrationBlock it) {
                boolean _notEquals;
                MigrationBlock _from = it.getFrom();
                boolean bl = _notEquals = !Objects.equal((Object)_from, null);
                if (_notEquals) {
                    MigrationBlock _from_1 = it.getFrom();
                    String _name = _from_1.getName();
                    db.migrationsByFromName.put(_name, it);
                }
            }
        };
        migrations.forEach(_function_1);
        return db;
    }
}

