/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.idea.findusages;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.idea.findusages.IReferenceSearcher;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.util.PropertyUtil;

@Singleton
public class JvmElementAwareReferenceSearcher
implements IReferenceSearcher {
    @Inject
    @Extension
    private OperatorMapping _operatorMapping;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;

    @Override
    public void processQuery(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        Set<String> words = this.collectWords(element);
        boolean _isEmpty = words.isEmpty();
        if (_isEmpty) {
            return;
        }
        Language _language = element.getLanguage();
        boolean caseSensitive = _language.isCaseSensitive();
        for (String word : words) {
            SearchRequestCollector _optimizer = queryParameters.getOptimizer();
            SearchScope _effectiveSearchScope = queryParameters.getEffectiveSearchScope();
            _optimizer.searchWord(word, _effectiveSearchScope, caseSensitive, element);
        }
    }

    protected Set<String> collectWords(PsiElement element) {
        Procedures.Procedure1<String> _function;
        HashSet _xblockexpression = null;
        final HashSet words = CollectionLiterals.newHashSet((Object[])new String[0]);
        Procedures.Procedure1<String> acceptor = _function = new Procedures.Procedure1<String>(){

            public void apply(String word) {
                JvmElementAwareReferenceSearcher.this.accept(words, word);
            }
        };
        if (element instanceof PsiEObject) {
            EObject _eObject = ((PsiEObject)element).getEObject();
            Set _jvmElements = this._iJvmModelAssociations.getJvmElements(_eObject);
            for (EObject jvmElement : _jvmElements) {
                this.collectWords(jvmElement, (Procedures.Procedure1<? super String>)acceptor);
            }
        }
        _xblockexpression = words;
        return _xblockexpression;
    }

    protected void accept(Set<String> words, String word) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)word, null);
        if (_notEquals) {
            words.add(word);
        }
    }

    protected void _collectWords(EObject jvmElement, Procedures.Procedure1<? super String> acceptor) {
    }

    protected void _collectWords(Void jvmElement, Procedures.Procedure1<? super String> acceptor) {
    }

    protected void _collectWords(JvmIdentifiableElement jvmElement, Procedures.Procedure1<? super String> acceptor) {
        String _simpleName = jvmElement.getSimpleName();
        acceptor.apply((Object)_simpleName);
    }

    protected void _collectWords(JvmFeature jvmElement, Procedures.Procedure1<? super String> acceptor) {
        boolean _notEquals;
        String _simpleName = jvmElement.getSimpleName();
        acceptor.apply((Object)_simpleName);
        String _simpleName_1 = jvmElement.getSimpleName();
        QualifiedName _create = QualifiedName.create((String)_simpleName_1);
        QualifiedName simpleOperator = this._operatorMapping.getOperator(_create);
        boolean bl = _notEquals = !Objects.equal((Object)simpleOperator, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String _string = simpleOperator.toString();
            acceptor.apply((Object)_string);
            QualifiedName compoundOperator = this._operatorMapping.getCompoundOperator(simpleOperator);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)compoundOperator, null);
            if (_notEquals_1) {
                String _string_1 = compoundOperator.toString();
                acceptor.apply((Object)_string_1);
            }
        } else {
            String _propertyName = PropertyUtil.getPropertyName((JvmFeature)jvmElement);
            acceptor.apply((Object)_propertyName);
        }
    }

    protected void collectWords(EObject jvmElement, Procedures.Procedure1<? super String> acceptor) {
        if (jvmElement instanceof JvmFeature && acceptor != null) {
            this._collectWords((JvmFeature)jvmElement, acceptor);
            return;
        }
        if (jvmElement instanceof JvmIdentifiableElement && acceptor != null) {
            this._collectWords((JvmIdentifiableElement)jvmElement, acceptor);
            return;
        }
        if (jvmElement != null && acceptor != null) {
            this._collectWords(jvmElement, acceptor);
            return;
        }
        if (jvmElement == null && acceptor != null) {
            this._collectWords((Void)null, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(jvmElement, acceptor).toString());
    }
}

