/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.formatting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ide.editor.bracketmatching.BracePair;
import org.eclipse.xtext.idea.formatting.BlockExtension;
import org.eclipse.xtext.idea.formatting.ChildAttributesProvider;
import org.eclipse.xtext.idea.formatting.SyntheticXtextBlock;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class DefaultChildAttributesProvider
implements ChildAttributesProvider {
    @Inject
    @Extension
    private BlockExtension _blockExtension;

    @Override
    public ChildAttributes getChildAttributes(Block block, int newChildIndex) {
        Indent _noneIndent;
        Indent _elvis = null;
        Indent _childIndent = this.getChildIndent(block, newChildIndex);
        _elvis = _childIndent != null ? _childIndent : (_noneIndent = Indent.getNoneIndent());
        Indent indent = _elvis;
        return new ChildAttributes(indent, null);
    }

    protected Indent getChildIndent(Block block, int newChildIndex) {
        boolean _greaterEqualsThan;
        List children = block.getSubBlocks();
        boolean _isEmpty = children.isEmpty();
        if (_isEmpty) {
            return null;
        }
        int _size = children.size();
        boolean bl = _greaterEqualsThan = newChildIndex >= _size;
        if (_greaterEqualsThan) {
            int _size_1 = children.size();
            return this.getAfterChildIndent(block, _size_1);
        }
        Indent indent = this.getBeforeChildIndent(block, newChildIndex);
        boolean _equals = Objects.equal((Object)indent, null);
        if (_equals) {
            return this.getAfterChildIndent(block, newChildIndex);
        }
        return indent;
    }

    protected Indent getBeforeChildIndent(Block block, int newChildIndex) {
        boolean _greaterEqualsThan;
        List children = block.getSubBlocks();
        boolean _isEmpty = children.isEmpty();
        if (_isEmpty) {
            return null;
        }
        int _size = children.size();
        boolean bl = _greaterEqualsThan = newChildIndex >= _size;
        if (_greaterEqualsThan) {
            return null;
        }
        Block child = (Block)children.get(newChildIndex);
        boolean _isLeaf = child.isLeaf();
        if (_isLeaf) {
            return this.getBeforeChildIndent(child);
        }
        return this.getChildIndent(child, 0);
    }

    protected Indent getAfterChildIndent(Block block, int newChildIndex) {
        if (newChildIndex == 0) {
            return null;
        }
        List children = block.getSubBlocks();
        boolean _isEmpty = children.isEmpty();
        if (_isEmpty) {
            return null;
        }
        Block childBefore = (Block)children.get(newChildIndex - 1);
        boolean _isLeaf = childBefore.isLeaf();
        if (_isLeaf) {
            return this.getAfterChildIndent(childBefore);
        }
        List _subBlocks = childBefore.getSubBlocks();
        int size = _subBlocks.size();
        return this.getChildIndent(childBefore, size);
    }

    protected Indent getAfterChildIndent(Block block) {
        boolean _notEquals;
        boolean _equals = Objects.equal((Object)block, null);
        if (_equals) {
            return null;
        }
        EObject _grammarElement = this._blockExtension.getGrammarElement(block);
        Indent grammarElementIndent = this.getIndentAfter(_grammarElement);
        boolean bl = _notEquals = !Objects.equal((Object)grammarElementIndent, null);
        if (_notEquals) {
            return grammarElementIndent;
        }
        if (block instanceof SyntheticXtextBlock) {
            return ((SyntheticXtextBlock)block).getIndent();
        }
        boolean _isOpening = this._blockExtension.isOpening(block);
        if (_isOpening) {
            BracePair _bracePairForOpeningBrace = this._blockExtension.getBracePairForOpeningBrace(block);
            return this._blockExtension.getIndent(_bracePairForOpeningBrace, false);
        }
        return null;
    }

    protected Indent getIndentAfter(EObject grammarElement) {
        return null;
    }

    protected Indent getBeforeChildIndent(Block block) {
        boolean _notEquals;
        boolean _equals = Objects.equal((Object)block, null);
        if (_equals) {
            return null;
        }
        EObject _grammarElement = this._blockExtension.getGrammarElement(block);
        Indent grammarElementIndent = this.getIndentBefore(_grammarElement);
        boolean bl = _notEquals = !Objects.equal((Object)grammarElementIndent, null);
        if (_notEquals) {
            return grammarElementIndent;
        }
        if (block instanceof SyntheticXtextBlock) {
            return ((SyntheticXtextBlock)block).getIndent();
        }
        boolean _isClosing = this._blockExtension.isClosing(block);
        if (_isClosing) {
            BracePair _bracePairForClosingBrace = this._blockExtension.getBracePairForClosingBrace(block);
            return this._blockExtension.getIndent(_bracePairForClosingBrace, false);
        }
        return null;
    }

    protected Indent getIndentBefore(EObject grammarElement) {
        return null;
    }
}

