/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.facet;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.GridBagConstraints;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eclipse.xtext.idea.facet.GeneratorConfigurationState;
import org.eclipse.xtext.idea.util.IdeaWidgetFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GeneratorFacetForm {
    @Extension
    private IdeaWidgetFactory _ideaWidgetFactory = new IdeaWidgetFactory();
    protected JCheckBox activated;
    protected TextFieldWithBrowseButton directory;
    protected TextFieldWithBrowseButton testDirectory;
    protected JCheckBox createDirectory;
    protected JCheckBox overwriteFiles;
    protected JCheckBox deleteGenerated;
    private Module module;
    private FacetValidatorsManager validatorsManager;
    private JComponent rootPanel;

    public GeneratorFacetForm(Module module) {
        this(module, null);
    }

    public GeneratorFacetForm(Module module, FacetValidatorsManager validatorsManager) {
        this.module = module;
        this.validatorsManager = validatorsManager;
    }

    protected JComponent createComponent() {
        Functions.Function1<IdeaWidgetFactory.TwoColumnPanel, IdeaWidgetFactory.TwoColumnPanel> _function = new Functions.Function1<IdeaWidgetFactory.TwoColumnPanel, IdeaWidgetFactory.TwoColumnPanel>(){

            public IdeaWidgetFactory.TwoColumnPanel apply(@Extension IdeaWidgetFactory.TwoColumnPanel it) {
                IdeaWidgetFactory.TwoColumnPanel _xblockexpression = null;
                Functions.Function1<GridBagConstraints, JComponent> _function = new Functions.Function1<GridBagConstraints, JComponent>(){

                    public JComponent apply(GridBagConstraints it) {
                        return GeneratorFacetForm.this._ideaWidgetFactory.separator("General");
                    }
                };
                it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function);
                GeneratorFacetForm.this.createGeneralSection(it);
                Functions.Function1<GridBagConstraints, JComponent> _function_1 = new Functions.Function1<GridBagConstraints, JComponent>(){

                    public JComponent apply(GridBagConstraints it) {
                        return GeneratorFacetForm.this._ideaWidgetFactory.label(" ");
                    }
                };
                it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_1);
                Functions.Function1<GridBagConstraints, JComponent> _function_2 = new Functions.Function1<GridBagConstraints, JComponent>(){

                    public JComponent apply(GridBagConstraints it) {
                        return GeneratorFacetForm.this._ideaWidgetFactory.separator("Output Folder");
                    }
                };
                it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_2);
                GeneratorFacetForm.this.createOutputSection(it);
                Functions.Function1<GridBagConstraints, JComponent> _function_3 = new Functions.Function1<GridBagConstraints, JComponent>(){

                    public JComponent apply(GridBagConstraints it) {
                        JLabel _xblockexpression = null;
                        GeneratorFacetForm.this._ideaWidgetFactory.expand(it, 3);
                        _xblockexpression = GeneratorFacetForm.this._ideaWidgetFactory.label("");
                        return _xblockexpression;
                    }
                };
                _xblockexpression = it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_3);
                return _xblockexpression;
            }
        };
        return this._ideaWidgetFactory.twoColumnPanel((Functions.Function1<? super IdeaWidgetFactory.TwoColumnPanel, ? extends IdeaWidgetFactory.TwoColumnPanel>)_function);
    }

    public void createOutputSection(@Extension IdeaWidgetFactory.TwoColumnPanel it) {
        Functions.Function1<GridBagConstraints, JComponent> _function = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                return GeneratorFacetForm.this._ideaWidgetFactory.label("Directory:");
            }
        };
        Functions.Function1<GridBagConstraints, JComponent> _function_1 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                TextFieldWithBrowseButton _browseField;
                TextFieldWithBrowseButton _xblockexpression = null;
                it.weightx = 1.0;
                Project _project = GeneratorFacetForm.this.module.getProject();
                _xblockexpression = GeneratorFacetForm.this.directory = (_browseField = GeneratorFacetForm.this._ideaWidgetFactory.browseField(_project));
                return _xblockexpression;
            }
        };
        it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_1);
        Functions.Function1<GridBagConstraints, JComponent> _function_2 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                return GeneratorFacetForm.this._ideaWidgetFactory.label("Test Directory:");
            }
        };
        Functions.Function1<GridBagConstraints, JComponent> _function_3 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                TextFieldWithBrowseButton _browseField;
                Project _project = GeneratorFacetForm.this.module.getProject();
                GeneratorFacetForm.this.testDirectory = _browseField = GeneratorFacetForm.this._ideaWidgetFactory.browseField(_project);
                return GeneratorFacetForm.this.testDirectory;
            }
        };
        it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_2, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_3);
        Functions.Function1<GridBagConstraints, JComponent> _function_4 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                JCheckBox _checkBox;
                GeneratorFacetForm.this.createDirectory = _checkBox = GeneratorFacetForm.this._ideaWidgetFactory.checkBox("Create directory if it doesn't exist");
                return GeneratorFacetForm.this.createDirectory;
            }
        };
        it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_4);
        Functions.Function1<GridBagConstraints, JComponent> _function_5 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                JCheckBox _checkBox;
                GeneratorFacetForm.this.overwriteFiles = _checkBox = GeneratorFacetForm.this._ideaWidgetFactory.checkBox("Overwrite existing files");
                return GeneratorFacetForm.this.overwriteFiles;
            }
        };
        it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_5);
        Functions.Function1<GridBagConstraints, JComponent> _function_6 = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                JCheckBox _checkBox;
                GeneratorFacetForm.this.deleteGenerated = _checkBox = GeneratorFacetForm.this._ideaWidgetFactory.checkBox("Delete generated files");
                return GeneratorFacetForm.this.deleteGenerated;
            }
        };
        it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function_6);
        this.registerDirectoryValidator(this.directory, "The output directory should belong to the module.");
        this.registerDirectoryValidator(this.testDirectory, "The output test directory should belong to the module.");
    }

    protected void registerDirectoryValidator(final TextFieldWithBrowseButton directory, final String errorMessage) {
        if (this.validatorsManager == null) {
            return;
        }
        FacetEditorValidator _function = new FacetEditorValidator(){

            public ValidationResult check() {
                boolean _not;
                boolean _isUnderModule = GeneratorFacetForm.this.isUnderModule(directory);
                boolean bl = _not = !_isUnderModule;
                if (_not) {
                    return new ValidationResult(errorMessage);
                }
                return ValidationResult.OK;
            }
        };
        this.validatorsManager.registerValidator(_function, new JComponent[]{directory});
    }

    protected boolean isUnderModule(TextFieldWithBrowseButton directory) {
        boolean _not;
        String path = directory.getText();
        boolean _isAbsolute = FileUtil.isAbsolute((String)path);
        boolean bl = _not = !_isAbsolute;
        if (_not) {
            return true;
        }
        ModuleRootManager _instance = ModuleRootManager.getInstance((Module)this.module);
        VirtualFile[] _contentRoots = _instance.getContentRoots();
        VirtualFile root = (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentRoots)));
        boolean _and = false;
        if (root == null) {
            _and = false;
        } else {
            boolean _isAncestor;
            String _path = root.getPath();
            _and = _isAncestor = FileUtil.isAncestor((String)_path, (String)path, (boolean)false);
        }
        return _and;
    }

    public IdeaWidgetFactory.TwoColumnPanel createGeneralSection(@Extension IdeaWidgetFactory.TwoColumnPanel it) {
        Functions.Function1<GridBagConstraints, JComponent> _function = new Functions.Function1<GridBagConstraints, JComponent>(){

            public JComponent apply(GridBagConstraints it) {
                JCheckBox _checkBox;
                GeneratorFacetForm.this.activated = _checkBox = GeneratorFacetForm.this._ideaWidgetFactory.checkBox("Compiler is activated");
                return GeneratorFacetForm.this.activated;
            }
        };
        return it.row(it, (Functions.Function1<? super GridBagConstraints, ? extends JComponent>)_function);
    }

    public void setData(GeneratorConfigurationState data) {
        boolean _isCreateDirectory = data.isCreateDirectory();
        this.createDirectory.setSelected(_isCreateDirectory);
        boolean _isOverwriteExisting = data.isOverwriteExisting();
        this.overwriteFiles.setSelected(_isOverwriteExisting);
        boolean _isDeleteGenerated = data.isDeleteGenerated();
        this.deleteGenerated.setSelected(_isDeleteGenerated);
        boolean _isActivated = data.isActivated();
        this.activated.setSelected(_isActivated);
        String _outputDirectory = data.getOutputDirectory();
        this.directory.setText(_outputDirectory);
        String _testOutputDirectory = data.getTestOutputDirectory();
        this.testDirectory.setText(_testOutputDirectory);
    }

    public void getData(GeneratorConfigurationState data) {
        boolean _isSelected = this.createDirectory.isSelected();
        data.setCreateDirectory(_isSelected);
        boolean _isSelected_1 = this.overwriteFiles.isSelected();
        data.setOverwriteExisting(_isSelected_1);
        boolean _isSelected_2 = this.deleteGenerated.isSelected();
        data.setDeleteGenerated(_isSelected_2);
        boolean _isSelected_3 = this.activated.isSelected();
        data.setActivated(_isSelected_3);
        String _text = this.directory.getText();
        data.setOutputDirectory(_text);
        String _text_1 = this.testDirectory.getText();
        data.setTestOutputDirectory(_text_1);
    }

    public boolean isModified(GeneratorConfigurationState data) {
        boolean _tripleNotEquals_5;
        boolean _tripleNotEquals_4;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _isSelected = this.createDirectory.isSelected();
        boolean _isCreateDirectory = data.isCreateDirectory();
        boolean bl = _tripleNotEquals = Boolean.valueOf(_isSelected) != Boolean.valueOf(_isCreateDirectory);
        if (_tripleNotEquals) {
            return true;
        }
        boolean _isSelected_1 = this.overwriteFiles.isSelected();
        boolean _isOverwriteExisting = data.isOverwriteExisting();
        boolean bl2 = _tripleNotEquals_1 = Boolean.valueOf(_isSelected_1) != Boolean.valueOf(_isOverwriteExisting);
        if (_tripleNotEquals_1) {
            return true;
        }
        boolean _isSelected_2 = this.deleteGenerated.isSelected();
        boolean _isDeleteGenerated = data.isDeleteGenerated();
        boolean bl3 = _tripleNotEquals_2 = Boolean.valueOf(_isSelected_2) != Boolean.valueOf(_isDeleteGenerated);
        if (_tripleNotEquals_2) {
            return true;
        }
        boolean _isSelected_3 = this.activated.isSelected();
        boolean _isActivated = data.isActivated();
        boolean bl4 = _tripleNotEquals_3 = Boolean.valueOf(_isSelected_3) != Boolean.valueOf(_isActivated);
        if (_tripleNotEquals_3) {
            return true;
        }
        boolean _xifexpression = false;
        String _text = this.directory.getText();
        boolean bl5 = _tripleNotEquals_4 = _text != null;
        if (_tripleNotEquals_4) {
            String _outputDirectory;
            String _text_1 = this.directory.getText();
            boolean _equals = _text_1.equals(_outputDirectory = data.getOutputDirectory());
            _xifexpression = !_equals;
        } else {
            String _outputDirectory_1 = data.getOutputDirectory();
            boolean bl6 = _xifexpression = _outputDirectory_1 != null;
        }
        if (_xifexpression) {
            return true;
        }
        boolean _xifexpression_1 = false;
        String _text_2 = this.testDirectory.getText();
        boolean bl7 = _tripleNotEquals_5 = _text_2 != null;
        if (_tripleNotEquals_5) {
            String _testOutputDirectory;
            String _text_3 = this.testDirectory.getText();
            boolean _equals_1 = _text_3.equals(_testOutputDirectory = data.getTestOutputDirectory());
            _xifexpression_1 = !_equals_1;
        } else {
            String _testOutputDirectory_1 = data.getTestOutputDirectory();
            boolean bl8 = _xifexpression_1 = _testOutputDirectory_1 != null;
        }
        return _xifexpression_1;
    }

    public JComponent getRootComponent() {
        if (this.rootPanel == null) {
            JComponent _createComponent;
            this.rootPanel = _createComponent = this.createComponent();
            this.postCreateComponent();
        }
        return this.rootPanel;
    }

    public void postCreateComponent() {
        this.deleteGenerated.setVisible(false);
    }

    public Module getModule() {
        return this.module;
    }
}

