/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.debug;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.idea.debug.DebugProcessExtensions;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.idea.trace.IIdeaTrace;
import org.eclipse.xtext.idea.trace.ILocationInVirtualFile;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.idea.trace.VirtualFileInProject;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;

public class TraceBasedPositionManagerFactory
extends PositionManagerFactory {
    private IXtextLanguage language;

    public TraceBasedPositionManagerFactory(IXtextLanguage language) {
        this.language = language;
    }

    public PositionManager createPositionManager(DebugProcess process) {
        TraceBasedPositionManager manager = new TraceBasedPositionManager(process, this.language);
        this.language.injectMembers(manager);
        return manager;
    }

    public static class TraceBasedPositionManager
    implements PositionManager {
        private final DebugProcess process;
        private final IXtextLanguage language;
        @Inject
        @Extension
        private DebugProcessExtensions _debugProcessExtensions;
        @Inject
        private ITraceForVirtualFileProvider traceForVirtualFileProvider;

        public TraceBasedPositionManager(DebugProcess process, IXtextLanguage language) {
            this.process = process;
            this.language = language;
        }

        public ClassPrepareRequest createPrepareRequest(final ClassPrepareRequestor requestor, final SourcePosition source) throws NoDataException {
            Computable<Set<String>> _function;
            boolean _notEquals;
            PsiFile _file = source.getFile();
            Language _language = _file.getLanguage();
            boolean bl = _notEquals = !Objects.equal((Object)_language, (Object)this.language);
            if (_notEquals) {
                throw NoDataException.INSTANCE;
            }
            Application _application = ApplicationManager.getApplication();
            final Set names = (Set)_application.runReadAction((Computable)(_function = new Computable<Set<String>>(){

                public Set<String> compute() {
                    try {
                        PsiElement _elementAt = source.getElementAt();
                        VirtualFileInProject sourceResource = VirtualFileInProject.forPsiElement(_elementAt);
                        if (sourceResource == null) {
                            throw NoDataException.INSTANCE;
                        }
                        IIdeaTrace trace = (IIdeaTrace)TraceBasedPositionManager.this.traceForVirtualFileProvider.getTraceToTarget(sourceResource);
                        if (trace == null) {
                            throw NoDataException.INSTANCE;
                        }
                        Iterable _allAssociatedLocations = trace.getAllAssociatedLocations();
                        Functions.Function1<ILocationInVirtualFile, String> _function = new Functions.Function1<ILocationInVirtualFile, String>(){

                            public String apply(ILocationInVirtualFile it) {
                                SourceRelativeURI _srcRelativeResourceURI = it.getSrcRelativeResourceURI();
                                URI _uRI = _srcRelativeResourceURI.getURI();
                                return _uRI.lastSegment();
                            }
                        };
                        Iterable _map = IterableExtensions.map((Iterable)_allAssociatedLocations, (Functions.Function1)_function);
                        return IterableExtensions.toSet((Iterable)_map);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }));
            boolean _isEmpty = names.isEmpty();
            if (_isEmpty) {
                throw NoDataException.INSTANCE;
            }
            RequestManager _requestsManager = this.process.getRequestsManager();
            ClassPrepareRequestor _function_1 = new ClassPrepareRequestor(){

                public void processClassPrepare(DebugProcess process, ReferenceType refType) {
                    try {
                        String _sourceName = refType.sourceName();
                        boolean _contains = names.contains(_sourceName);
                        if (_contains) {
                            requestor.processClassPrepare(process, refType);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof AbsentInformationException) {
                            AbsentInformationException ignore = (AbsentInformationException)_t;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            };
            return _requestsManager.createClassPrepareRequest(_function_1, "*");
        }

        public List<ReferenceType> getAllClasses(SourcePosition source) throws NoDataException {
            boolean _notEquals;
            PsiFile _file = source.getFile();
            Language _language = _file.getLanguage();
            boolean bl = _notEquals = !Objects.equal((Object)_language, (Object)this.language);
            if (_notEquals) {
                throw NoDataException.INSTANCE;
            }
            Map<URI, AbstractTraceRegion> traces = this._debugProcessExtensions.getTracesForSource(this.process, source);
            ArrayList allClasses = CollectionLiterals.newArrayList((Object[])new ReferenceType[0]);
            final int line = source.getLine();
            Set<Map.Entry<URI, AbstractTraceRegion>> _entrySet = traces.entrySet();
            for (Map.Entry<URI, AbstractTraceRegion> uri2trace : _entrySet) {
                Functions.Function1<AbstractTraceRegion, Boolean> _function;
                AbstractTraceRegion _value = uri2trace.getValue();
                TreeIterator _treeIterator = _value.treeIterator();
                AbstractTraceRegion region = (AbstractTraceRegion)IteratorExtensions.findFirst((Iterator)_treeIterator, (Functions.Function1)(_function = new Functions.Function1<AbstractTraceRegion, Boolean>(){

                    public Boolean apply(AbstractTraceRegion it) {
                        List _associatedLocations = it.getAssociatedLocations();
                        ILocationData _head = (ILocationData)IterableExtensions.head((Iterable)_associatedLocations);
                        int _lineNumber = 0;
                        if (_head != null) {
                            _lineNumber = _head.getLineNumber();
                        }
                        return _lineNumber == line;
                    }
                }));
                boolean _notEquals_1 = !Objects.equal((Object)region, null);
                if (!_notEquals_1) continue;
                URI _key = uri2trace.getKey();
                PsiFile psiFile = this._debugProcessExtensions.getPsiFile(this.process, _key);
                PositionManagerImpl _javaPositionManger = this._debugProcessExtensions.getJavaPositionManger(this.process);
                int _myLineNumber = region.getMyLineNumber();
                int _plus = _myLineNumber + 1;
                SourcePosition _createFromLine = SourcePosition.createFromLine((PsiFile)psiFile, (int)_plus);
                List classes = _javaPositionManger.getAllClasses(_createFromLine);
                allClasses.addAll(classes);
            }
            return allClasses;
        }

        public SourcePosition getSourcePosition(Location location) throws NoDataException {
            int _lineNumber = location.lineNumber();
            int line = _lineNumber - 1;
            PsiFile psiFile = this._debugProcessExtensions.getPsiFile(this.process, location);
            boolean _equals = Objects.equal((Object)psiFile, null);
            if (_equals) {
                throw NoDataException.INSTANCE;
            }
            SourcePosition _createFromLine = SourcePosition.createFromLine((PsiFile)psiFile, (int)line);
            AbstractTraceRegion trace = this._debugProcessExtensions.getTraceForJava(_createFromLine);
            boolean _equals_1 = Objects.equal((Object)trace, null);
            if (_equals_1) {
                throw NoDataException.INSTANCE;
            }
            URI sourceURI = this._debugProcessExtensions.findOriginalDeclaration(this.process, location);
            SourcePosition fallBack = null;
            SourcePosition secondaryFallBack = null;
            TreeIterator iter = trace.treeIterator();
            while (iter.hasNext()) {
                SourcePosition _createFromLine_1;
                int _myEndLineNumber_1;
                boolean _tripleEquals_2;
                boolean _tripleEquals;
                AbstractTraceRegion n = (AbstractTraceRegion)iter.next();
                int _myLineNumber = n.getMyLineNumber();
                boolean bl = _tripleEquals = _myLineNumber == line;
                if (_tripleEquals) {
                    SourcePosition _createFromOffset;
                    int _endLineNumber;
                    int _lineNumber_1;
                    boolean _equals_2;
                    int _myEndLineNumber;
                    boolean _tripleEquals_1;
                    ILocationData mergedAssociatedLocation = n.getMergedAssociatedLocation();
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _isUseForDebugging = n.isUseForDebugging();
                    _and_1 = !_isUseForDebugging ? false : (_tripleEquals_1 = (_myEndLineNumber = n.getMyEndLineNumber()) == line);
                    _and = !_and_1 ? false : (_equals_2 = (_lineNumber_1 = mergedAssociatedLocation.getLineNumber()) == (_endLineNumber = mergedAssociatedLocation.getEndLineNumber()));
                    if (_and) {
                        PsiFile psi = this._debugProcessExtensions.getPsiFile(this.process, sourceURI);
                        int _offset = mergedAssociatedLocation.getOffset();
                        return SourcePosition.createFromOffset((PsiFile)psi, (int)_offset);
                    }
                    PsiFile psi_1 = this._debugProcessExtensions.getPsiFile(this.process, sourceURI);
                    int _offset_1 = mergedAssociatedLocation.getOffset();
                    fallBack = _createFromOffset = SourcePosition.createFromOffset((PsiFile)psi_1, (int)_offset_1);
                }
                if (!(_tripleEquals_2 = (_myEndLineNumber_1 = n.getMyEndLineNumber()) == line)) continue;
                ILocationData mergedAssociatedLocation_1 = n.getMergedAssociatedLocation();
                PsiFile psi_2 = this._debugProcessExtensions.getPsiFile(this.process, sourceURI);
                int _endLineNumber_1 = mergedAssociatedLocation_1.getEndLineNumber();
                secondaryFallBack = _createFromLine_1 = SourcePosition.createFromLine((PsiFile)psi_2, (int)_endLineNumber_1);
            }
            return (SourcePosition)ObjectExtensions.operator_elvis(fallBack, secondaryFallBack);
        }

        public List<Location> locationsOfLine(final ReferenceType type, final SourcePosition position) throws NoDataException {
            boolean _notEquals;
            PsiFile _file = position.getFile();
            Language _language = _file.getLanguage();
            boolean bl = _notEquals = !Objects.equal((Object)_language, (Object)this.language);
            if (_notEquals) {
                throw NoDataException.INSTANCE;
            }
            Application _application = ApplicationManager.getApplication();
            Computable<List<Location>> _function = new Computable<List<Location>>(){

                public List<Location> compute() {
                    try {
                        PsiElement psi = position.getElementAt();
                        Project _project = psi.getProject();
                        PsiDocumentManager _instance = PsiDocumentManager.getInstance((Project)_project);
                        PsiFile _containingFile = psi.getContainingFile();
                        Document document = _instance.getDocument(_containingFile);
                        int _line = position.getLine();
                        TextRange range = DocumentUtil.getLineTextRange((Document)document, (int)_line);
                        VirtualFileInProject sourceResource = VirtualFileInProject.forPsiElement(psi);
                        if (sourceResource == null) {
                            throw NoDataException.INSTANCE;
                        }
                        IIdeaTrace traceToTarget = (IIdeaTrace)TraceBasedPositionManager.this.traceForVirtualFileProvider.getTraceToTarget(sourceResource);
                        if (traceToTarget == null) {
                            throw NoDataException.INSTANCE;
                        }
                        ArrayList result = CollectionLiterals.newArrayList((Object[])new Location[0]);
                        int _startOffset = range.getStartOffset();
                        int _length = range.getLength();
                        TextRegion _textRegion = new TextRegion(_startOffset, _length);
                        Iterable _allAssociatedLocations = traceToTarget.getAllAssociatedLocations((ITextRegion)_textRegion);
                        Functions.Function1<ILocationInVirtualFile, Integer> _function = new Functions.Function1<ILocationInVirtualFile, Integer>(){

                            public Integer apply(ILocationInVirtualFile it) {
                                ITextRegionWithLineInformation _textRegion = it.getTextRegion();
                                return _textRegion.getLineNumber();
                            }
                        };
                        List _sortBy = IterableExtensions.sortBy((Iterable)_allAssociatedLocations, (Functions.Function1)_function);
                        for (ILocationInVirtualFile location : _sortBy) {
                            ITextRegionWithLineInformation _textRegion_3;
                            int _lineNumber_1;
                            int _plus;
                            List<Location> locationsOfLine;
                            boolean _isEmpty;
                            boolean _not;
                            ITextRegionWithLineInformation _textRegion_2;
                            int _endLineNumber;
                            ITextRegionWithLineInformation _textRegion_1;
                            int _lineNumber;
                            boolean _equals_1;
                            SourceRelativeURI _srcRelativeResourceURI;
                            URI _uRI;
                            String _lastSegment;
                            String _string;
                            boolean _and = false;
                            String _sourceName = type.sourceName();
                            boolean _equals = Objects.equal((Object)_sourceName, (Object)(_string = (_lastSegment = (_uRI = (_srcRelativeResourceURI = location.getSrcRelativeResourceURI()).getURI()).lastSegment()).toString()));
                            _and = !_equals ? false : (_equals_1 = (_lineNumber = (_textRegion_1 = location.getTextRegion()).getLineNumber()) == (_endLineNumber = (_textRegion_2 = location.getTextRegion()).getEndLineNumber()));
                            if (!_and || !(_not = !(_isEmpty = (locationsOfLine = type.locationsOfLine(_plus = (_lineNumber_1 = (_textRegion_3 = location.getTextRegion()).getLineNumber()) + 1)).isEmpty()))) continue;
                            result.addAll(locationsOfLine);
                            return result;
                        }
                        throw NoDataException.INSTANCE;
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            return (List)_application.runReadAction((Computable)_function);
        }
    }
}

