/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.completion;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElementComputer;
import org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.idea.completion.CompletionExtensions;
import org.eclipse.xtext.idea.editorActions.TokenSetProvider;
import org.eclipse.xtext.idea.lang.AbstractXtextLanguage;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public abstract class AbstractCompletionContributor
extends CompletionContributor {
    @Inject(optional=true)
    private Provider<ContentAssistContextFactory> delegates;
    @Inject
    @Extension
    protected CompletionExtensions _completionExtensions;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    @Extension
    protected TokenSetProvider _tokenSetProvider;
    @Inject(optional=true)
    private IContentAssistParser contentAssistParser;
    @Inject(optional=true)
    private FollowElementComputer followElementComputer;
    private ExecutorService pool = Executors.newFixedThreadPool(3);
    private final Map<CompletionType, Multimap<TokenSet, CompletionProvider<CompletionParameters>>> myContributors = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final Map<CompletionType, Map<TokenSet, Multimap<AbstractElement, CompletionProvider<CompletionParameters>>>> myFollowElementBasedContributors = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public AbstractCompletionContributor(AbstractXtextLanguage lang) {
        lang.injectMembers((Object)this);
    }

    protected void extend(CompletionType type, CompletionProvider<CompletionParameters> contrib) {
        TokenSet _defaultTokens = this._tokenSetProvider.getDefaultTokens();
        this.extend(type, new TokenSet[]{_defaultTokens}, contrib);
    }

    protected void extend(CompletionType type, TokenSet[] tokenSets, CompletionProvider<CompletionParameters> contrib) {
        boolean _not;
        boolean _containsKey = this.myContributors.containsKey(type);
        boolean bl = _not = !_containsKey;
        if (_not) {
            ArrayListMultimap _create = ArrayListMultimap.create();
            this.myContributors.put(type, (Multimap<TokenSet, CompletionProvider<CompletionParameters>>)_create);
        }
        for (TokenSet tokenSet : tokenSets) {
            Multimap<TokenSet, CompletionProvider<CompletionParameters>> _get = this.myContributors.get(type);
            _get.put((Object)tokenSet, contrib);
        }
    }

    protected void extend(CompletionType type, EStructuralFeature feature, CompletionProvider<CompletionParameters> contrib) {
        TokenSet _defaultTokens = this._tokenSetProvider.getDefaultTokens();
        this.extend(type, new TokenSet[]{_defaultTokens}, feature, contrib);
    }

    protected void extend(final CompletionType type, final TokenSet[] tokenSets, EStructuralFeature feature, final CompletionProvider<CompletionParameters> contrib) {
        if (this.followElementComputer == null) {
            throw new IllegalStateException("followElementComputer is not injected, probably IDE project is missing");
        }
        Grammar _grammar = this.grammarAccess.getGrammar();
        IFollowElementAcceptor _function = new IFollowElementAcceptor(){

            public void accept(AbstractElement it) {
                AbstractCompletionContributor.this.extend(type, tokenSets, it, (CompletionProvider<CompletionParameters>)contrib);
            }
        };
        this.followElementComputer.collectAbstractElements(_grammar, feature, _function);
    }

    protected void extend(CompletionType type, AbstractElement followElement, CompletionProvider<CompletionParameters> contrib) {
        TokenSet _defaultTokens = this._tokenSetProvider.getDefaultTokens();
        this.extend(type, new TokenSet[]{_defaultTokens}, followElement, contrib);
    }

    protected void extend(CompletionType type, TokenSet[] tokenSets, AbstractElement followElement, CompletionProvider<CompletionParameters> contrib) {
        boolean _not;
        boolean _containsKey = this.myFollowElementBasedContributors.containsKey(type);
        boolean bl = _not = !_containsKey;
        if (_not) {
            HashMap _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this.myFollowElementBasedContributors.put(type, _newHashMap);
        }
        Map<TokenSet, Multimap<AbstractElement, CompletionProvider<CompletionParameters>>> map = this.myFollowElementBasedContributors.get(type);
        for (TokenSet tokenSet : tokenSets) {
            boolean _not_1;
            boolean _containsKey_1 = map.containsKey(tokenSet);
            boolean bl2 = _not_1 = !_containsKey_1;
            if (_not_1) {
                ArrayListMultimap _create = ArrayListMultimap.create();
                map.put(tokenSet, (Multimap<AbstractElement, CompletionProvider<CompletionParameters>>)_create);
            }
            Multimap<AbstractElement, CompletionProvider<CompletionParameters>> providers = map.get(tokenSet);
            providers.put((Object)followElement, contrib);
        }
    }

    public void fillCompletionVariants(final CompletionParameters parameters, CompletionResultSet result) {
        Procedures.Procedure1<CompletionResult> _function;
        CompletionSorter _completionSorter = this.getCompletionSorter(parameters, result);
        final CompletionResultSet sortedResult = result.withRelevanceSorter(_completionSorter);
        Procedures.Procedure1<CompletionResult> filteredConsumer = _function = new Procedures.Procedure1<CompletionResult>(){

            public void apply(CompletionResult it) {
                LookupElement _lookupElement = it.getLookupElement();
                boolean _isValidProposal = AbstractCompletionContributor.this.isValidProposal(_lookupElement, parameters);
                if (_isValidProposal) {
                    LookupElement _lookupElement_1 = it.getLookupElement();
                    sortedResult.addElement(_lookupElement_1);
                }
            }
        };
        CompletionService _completionService = CompletionService.getCompletionService();
        CompletionResultSet filteredResult = _completionService.createResultSet(parameters, (Consumer)new Consumer<CompletionResult>((Procedures.Procedure1)filteredConsumer){
            final /* synthetic */ Procedures.Procedure1 val$filteredConsumer;
            {
                this.val$filteredConsumer = procedure1;
            }

            public void consume(CompletionResult t) {
                this.val$filteredConsumer.apply((Object)t);
            }
        }, (CompletionContributor)this);
        this.createMatcherBasedProposals(parameters, filteredResult);
        this.createReferenceBasedProposals(parameters, filteredResult);
        this.createTokenSetBasedProposals(parameters, filteredResult);
        this.createFollowElementBasedProposals(parameters, filteredResult);
        this.createParserBasedProposals(parameters, filteredResult);
        result.stopHere();
    }

    protected void createTokenSetBasedProposals(CompletionParameters parameters, CompletionResultSet result) {
        CompletionType _completionType;
        boolean _containsKey;
        boolean _not;
        boolean _or = false;
        boolean _isEmpty = this.myContributors.isEmpty();
        _or = _isEmpty ? true : (_not = !(_containsKey = this.myContributors.containsKey(_completionType = parameters.getCompletionType())));
        if (_or) {
            return;
        }
        Editor _editor = parameters.getEditor();
        int _offset = parameters.getOffset();
        TokenSet tokenSet = this._tokenSetProvider.getTokenSet((EditorEx)_editor, _offset);
        CompletionType _completionType_1 = parameters.getCompletionType();
        Multimap<TokenSet, CompletionProvider<CompletionParameters>> _get = this.myContributors.get(_completionType_1);
        Collection providers = _get.get((Object)tokenSet);
        boolean _equals = Objects.equal((Object)providers, null);
        if (_equals) {
            return;
        }
        HashSet calledProviders = CollectionLiterals.newHashSet((Object[])new CompletionProvider[0]);
        ProcessingContext context = new ProcessingContext();
        for (CompletionProvider provider : providers) {
            boolean _add = calledProviders.add(provider);
            if (!_add) continue;
            provider.addCompletionVariants(parameters, context, result);
            boolean _isStopped = result.isStopped();
            if (!_isStopped) continue;
            return;
        }
    }

    protected void createFollowElementBasedProposals(CompletionParameters parameters, CompletionResultSet result) {
        CompletionType _completionType;
        boolean _containsKey;
        boolean _not;
        boolean _or = false;
        boolean _isEmpty = this.myFollowElementBasedContributors.isEmpty();
        _or = _isEmpty ? true : (_not = !(_containsKey = this.myFollowElementBasedContributors.containsKey(_completionType = parameters.getCompletionType())));
        if (_or) {
            return;
        }
        Editor _editor = parameters.getEditor();
        int _offset = parameters.getOffset();
        TokenSet tokenSet = this._tokenSetProvider.getTokenSet((EditorEx)_editor, _offset);
        CompletionType _completionType_1 = parameters.getCompletionType();
        Map<TokenSet, Multimap<AbstractElement, CompletionProvider<CompletionParameters>>> _get = this.myFollowElementBasedContributors.get(_completionType_1);
        Multimap<AbstractElement, CompletionProvider<CompletionParameters>> element2provider = _get.get(tokenSet);
        boolean _equals = Objects.equal(element2provider, null);
        if (_equals) {
            return;
        }
        Set<AbstractElement> followElements = this.computeFollowElements(parameters);
        HashSet calledProviders = CollectionLiterals.newHashSet((Object[])new CompletionProvider[0]);
        Set _keySet = element2provider.keySet();
        for (AbstractElement followElement : _keySet) {
            ProcessingContext context = new ProcessingContext();
            boolean _contains = followElements.contains(followElement);
            if (!_contains) continue;
            Collection providers = element2provider.get((Object)followElement);
            for (CompletionProvider provider : providers) {
                boolean _add = calledProviders.add(provider);
                if (!_add) continue;
                provider.addCompletionVariants(parameters, context, result);
                boolean _isStopped = result.isStopped();
                if (!_isStopped) continue;
                return;
            }
        }
    }

    protected Set<AbstractElement> computeFollowElements(CompletionParameters parameters) {
        Editor _editor = parameters.getEditor();
        Document _document = _editor.getDocument();
        PsiElement _position = parameters.getPosition();
        ASTNode _node = _position.getNode();
        int _startOffset = _node.getStartOffset();
        TextRange _textRange = new TextRange(0, _startOffset);
        String text = _document.getText(_textRange);
        Collection followElements = this.contentAssistParser.getFollowElements(text, false);
        HashSet allElements = CollectionLiterals.newHashSet((Object[])new AbstractElement[0]);
        this.followElementComputer.computeFollowElements(followElements, (Collection)allElements);
        return allElements;
    }

    protected CompletionSorter getCompletionSorter(CompletionParameters parameters, CompletionResultSet result) {
        PrefixMatcher _prefixMatcher = result.getPrefixMatcher();
        CompletionSorter _defaultSorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)_prefixMatcher);
        DispreferKeywordsWeigher _dispreferKeywordsWeigher = new DispreferKeywordsWeigher();
        return _defaultSorter.weighBefore("liftShorter", new LookupElementWeigher[]{_dispreferKeywordsWeigher});
    }

    protected boolean isValidProposal(LookupElement proposal, CompletionParameters parameters) {
        return true;
    }

    protected void createMatcherBasedProposals(CompletionParameters parameters, CompletionResultSet result) {
        super.fillCompletionVariants(parameters, result);
    }

    protected boolean createReferenceBasedProposals(CompletionParameters parameters, CompletionResultSet result) {
        return LegacyCompletionContributor.completeReference((CompletionParameters)parameters, (CompletionResultSet)result);
    }

    protected void createParserBasedProposals(final CompletionParameters parameters, final CompletionResultSet result) {
        boolean _not;
        int _offset;
        Editor _editor = parameters.getEditor();
        TokenSet tokenSet = this._tokenSetProvider.getTokenSet((EditorEx)_editor, _offset = parameters.getOffset());
        boolean _supportParserBasedProposals = this.supportParserBasedProposals(tokenSet);
        boolean bl = _not = !_supportParserBasedProposals;
        if (_not) {
            return;
        }
        ContentAssistContextFactory delegate = this.getParserBasedDelegate();
        boolean _equals = Objects.equal((Object)delegate, null);
        if (_equals) {
            return;
        }
        String _text = this.getText(parameters);
        TextRegion _selection = this.getSelection(parameters);
        int _offset_1 = parameters.getOffset();
        XtextResource _resource = this.getResource(parameters);
        ContentAssistContext[] contexts = delegate.create(_text, (ITextRegion)_selection, _offset_1, _resource);
        Procedures.Procedure1<ContentAssistContext> _function = new Procedures.Procedure1<ContentAssistContext>(){

            public void apply(final ContentAssistContext c) {
                ImmutableList _firstSetGrammarElements = c.getFirstSetGrammarElements();
                Procedures.Procedure1<AbstractElement> _function = new Procedures.Procedure1<AbstractElement>(){

                    public void apply(AbstractElement e) {
                        AbstractCompletionContributor.this.createProposal(e, c, parameters, result);
                    }
                };
                IterableExtensions.forEach((Iterable)_firstSetGrammarElements, (Procedures.Procedure1)_function);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)contexts)), (Procedures.Procedure1)_function);
    }

    protected boolean supportParserBasedProposals(TokenSet tokenSet) {
        TokenSet _defaultTokens = this._tokenSetProvider.getDefaultTokens();
        return Objects.equal((Object)tokenSet, (Object)_defaultTokens);
    }

    protected ContentAssistContextFactory getParserBasedDelegate() {
        ContentAssistContextFactory _xblockexpression = null;
        boolean _equals = Objects.equal(this.delegates, null);
        if (_equals) {
            return null;
        }
        ContentAssistContextFactory _get = (ContentAssistContextFactory)this.delegates.get();
        Procedures.Procedure1<ContentAssistContextFactory> _function = new Procedures.Procedure1<ContentAssistContextFactory>(){

            public void apply(ContentAssistContextFactory it) {
                it.setPool(AbstractCompletionContributor.this.pool);
            }
        };
        _xblockexpression = (ContentAssistContextFactory)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected String getText(final CompletionParameters parameters) {
        Computable<String> _function = new Computable<String>(){

            public String compute() {
                PsiFile _originalFile = parameters.getOriginalFile();
                return _originalFile.getText();
            }
        };
        return this.runReadAction(_function);
    }

    protected TextRegion getSelection(CompletionParameters parameters) {
        TextRegion _xblockexpression = null;
        OffsetMap offsets = this.getOffsets(parameters);
        int startOffset = offsets.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = offsets.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        _xblockexpression = new TextRegion(startOffset, endOffset - startOffset);
        return _xblockexpression;
    }

    protected OffsetMap getOffsets(final CompletionParameters parameters) {
        Computable<OffsetMap> _function = new Computable<OffsetMap>(){

            public OffsetMap compute() {
                PsiElement _position = parameters.getPosition();
                CompletionContext _userData = (CompletionContext)_position.getUserData(CompletionContext.COMPLETION_CONTEXT_KEY);
                return _userData.getOffsetMap();
            }
        };
        return this.runReadAction(_function);
    }

    protected XtextResource getResource(final CompletionParameters parameters) {
        Computable<XtextResource> _function = new Computable<XtextResource>(){

            public XtextResource compute() {
                PsiFile _originalFile = parameters.getOriginalFile();
                return ((BaseXtextFile)_originalFile).getResource();
            }
        };
        return this.runReadAction(_function);
    }

    protected <T> T runReadAction(Computable<T> computable) {
        Application _application = ApplicationManager.getApplication();
        return (T)_application.runReadAction(computable);
    }

    protected void createProposal(AbstractElement grammarElement, ContentAssistContext context, CompletionParameters parameters, CompletionResultSet result) {
        boolean _matched = false;
        if (!_matched && grammarElement instanceof Keyword) {
            _matched = true;
            this.createKeyWordProposal((Keyword)grammarElement, context, parameters, result);
        }
    }

    protected void createKeyWordProposal(Keyword keyword, ContentAssistContext context, CompletionParameters parameters, CompletionResultSet result) {
        boolean _isKeywordWorthyToPropose = this.isKeywordWorthyToPropose(keyword);
        if (_isKeywordWorthyToPropose) {
            KeywordLookupElement _keywordLookupElement = new KeywordLookupElement(keyword);
            this._completionExtensions.operator_add(result, _keywordLookupElement);
        }
    }

    protected boolean isKeywordWorthyToPropose(Keyword keyword) {
        return true;
    }

    public static class DispreferKeywordsWeigher
    extends LookupElementWeigher {
        public DispreferKeywordsWeigher() {
            super("dispreferKeywords");
        }

        public Boolean weigh(LookupElement element) {
            return element instanceof KeywordLookupElement;
        }
    }

    @Data
    public static class KeywordLookupElement
    extends LookupElement {
        private final Keyword keyword;

        public String getLookupString() {
            return this.keyword.getValue();
        }

        public KeywordLookupElement(Keyword keyword) {
            this.keyword = keyword;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyword == null ? 0 : this.keyword.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            KeywordLookupElement other = (KeywordLookupElement)((Object)obj);
            return !(this.keyword == null ? other.keyword != null : !this.keyword.equals(other.keyword));
        }

        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Keyword getKeyword() {
            return this.keyword;
        }
    }
}

