/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.build;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.intellij.facet.Facet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.idea.extensions.RootModelExtensions;
import org.eclipse.xtext.idea.facet.AbstractFacetConfiguration;
import org.eclipse.xtext.idea.facet.FacetProvider;
import org.eclipse.xtext.idea.facet.GeneratorConfigurationState;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IdeaOutputConfigurationProvider
implements IContextualOutputConfigurationProvider,
IContextualOutputConfigurationProvider2 {
    @Inject
    private FacetProvider facetProvider;
    @Inject
    private IOutputConfigurationProvider defaultOutput;

    public Set<OutputConfiguration> getOutputConfigurations(Resource context) {
        ResourceSet _resourceSet = context.getResourceSet();
        return this.getOutputConfigurations(_resourceSet);
    }

    public Set<OutputConfiguration> getOutputConfigurations(ResourceSet context) {
        Object module = ((XtextResourceSet)context).getClasspathURIContext();
        if (module instanceof Module) {
            return this.getOutputConfigurations((Module)module);
        }
        return this.defaultOutput.getOutputConfigurations();
    }

    public Set<OutputConfiguration> getOutputConfigurations(Module module) {
        boolean _notEquals;
        Facet<? extends AbstractFacetConfiguration> facet = this.facetProvider.getFacet(module);
        boolean bl = _notEquals = !Objects.equal(facet, null);
        if (_notEquals) {
            AbstractFacetConfiguration _configuration = (AbstractFacetConfiguration)facet.getConfiguration();
            GeneratorConfigurationState generatorConf = _configuration.getState();
            OutputConfiguration defOut = new OutputConfiguration("DEFAULT_OUTPUT");
            String _outputDirectory = generatorConf.getOutputDirectory();
            String _moduleRelativePath = this.toModuleRelativePath(_outputDirectory, module);
            defOut.setOutputDirectory(_moduleRelativePath);
            boolean _isCreateDirectory = generatorConf.isCreateDirectory();
            defOut.setCreateOutputDirectory(_isCreateDirectory);
            boolean _isDeleteGenerated = generatorConf.isDeleteGenerated();
            defOut.setCanClearOutputDirectory(_isDeleteGenerated);
            boolean _isOverwriteExisting = generatorConf.isOverwriteExisting();
            defOut.setOverrideExistingResources(_isOverwriteExisting);
            defOut.setUseOutputPerSourceFolder(true);
            Iterable<SourceFolder> allSrcFolders = RootModelExtensions.getExistingSourceFolders(module);
            for (SourceFolder srcFolder : allSrcFolders) {
                String _relativePath = RootModelExtensions.getRelativePath(srcFolder);
                OutputConfiguration.SourceMapping mapping = new OutputConfiguration.SourceMapping(_relativePath);
                boolean _isTestSource = srcFolder.isTestSource();
                if (_isTestSource) {
                    String _testOutputDirectory = generatorConf.getTestOutputDirectory();
                    String _moduleRelativePath_1 = this.toModuleRelativePath(_testOutputDirectory, module);
                    mapping.setOutputDirectory(_moduleRelativePath_1);
                } else {
                    String _outputDirectory_1 = generatorConf.getOutputDirectory();
                    String _moduleRelativePath_2 = this.toModuleRelativePath(_outputDirectory_1, module);
                    mapping.setOutputDirectory(_moduleRelativePath_2);
                }
                Set _sourceMappings = defOut.getSourceMappings();
                _sourceMappings.add(mapping);
            }
            return Sets.newHashSet((Object[])new OutputConfiguration[]{defOut});
        }
        return this.defaultOutput.getOutputConfigurations();
    }

    public String toModuleRelativePath(final String path, final Module module) {
        boolean _isAbsolute = FileUtil.isAbsolute((String)path);
        if (_isAbsolute) {
            Application _application = ApplicationManager.getApplication();
            Computable<String> _function = new Computable<String>(){

                public String compute() {
                    ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
                    VirtualFile[] _contentRoots = _instance.getContentRoots();
                    VirtualFile root = (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentRoots)));
                    String _path = root.getPath();
                    String relativePath = FileUtil.getRelativePath((String)_path, (String)path, (char)File.separatorChar);
                    return relativePath;
                }
            };
            return (String)_application.runReadAction((Computable)_function);
        }
        return path;
    }
}

