package files;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfMetaModel;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.dt.views.ValidationView;
import org.eclipse.epsilon.evl.dt.views.ValidationViewFixer;
import org.eclipse.epsilon.evl.execute.FixInstance;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
//import org.eclipse.epsilon.evl.dt.views.ValidationViewFixer;
//import org.eclipse.epsilon.evl.emf.validation.*;
import org.eclipse.ui.PlatformUI;

public class Validation {
	
	public static void main(String[] args) throws URISyntaxException, Exception {
		new Validation().execute();
	}
	
	public Validation() {
	}

	
	public void execute()   {
		try{
		
			EvlModule module = new EvlModule();			
			module.parse(getFile("WeavingValidation.evl"));
			if (!module.getParseProblems().isEmpty()) {
		      System.out.println("Syntax errors found. Exiting.");
		      return;
		    }
			
			// register the metamodel of the weaving model (trace model)
			getEPackage("src/files/GeneralTrace.ecore");
			
			//getting the source and target metamodels and the weaving model among them
			for (IModel model : getModels()) {
				module.getContext().getModelRepository().addModel(model);
			}
			

			
						ValidationView validationView = (ValidationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.epsilon.evl.dt.views.ValidationView");
						ValidationViewFixer fixer = new ValidationViewFixer();
						validationView.fix(module, fixer);
				
			
				// ... and execute
	   	// module.setUnsatisfiedConstraintFixer(new ValidationViewFixer());
			
			

			
			module.execute();

		//fix unsatisfied problems
		//Collection<UnsatisfiedConstraint> unsatisfied = module.getContext().getUnsatisfiedConstraints();
		
		/*	if (unsatisfied.size() > 0) {
			System.out.println(unsatisfied.size() + " constraint(s) have not been satisfied");
			for (UnsatisfiedConstraint uc : unsatisfied) {
				System.err.print(uc.getConstraint().getName()+":");
				System.err.println(uc.getMessage());
				for(FixInstance f:uc.getFixes()){try {
					f.perform();
				} catch (EolRuntimeException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}}
				for(FixInstance f:uc.getFixes()){
					try {
						f.getFix().execute(uc.getInstance(), module.getContext());
					} catch (EolRuntimeException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				}
			}*/
		

		
		module.getContext().getModelRepository().dispose();
		
		
	} catch (URISyntaxException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}

}
	
	
	private List<IModel> getModels() throws EolModelLoadingException, MalformedURLException, URISyntaxException {
		List<IModel> models = new ArrayList<IModel>();
		
		//the weaving model (trace model)
		IModel model =createEmfModel("GeneralTrace", "src/files/TraceSMMtoTMM.model", "src/files/GeneralTrace.ecore", true, true);
		models.add(model);

		// the source metamodel
		IModel srcmodel = createEmfMetaModel("Source","src/files/SourceMM.ecore", true, false);
		//srcmodel.getAliases().add("Source");
		models.add(srcmodel);
		
		//the target metamodel
		IModel trgmodel =createEmfMetaModel("Target","src/files/TargetMM.ecore", true, false);
		//trgmodel.getAliases().add("Target");
		models.add(trgmodel);
		
		
		
		return models;
	}

	private EmfModel createEmfModel(String name, String model, 
			String metamodelUri, boolean readOnLoad, boolean storeOnDisposal) 
					throws EolModelLoadingException, URISyntaxException {
		EmfModel emfModel = new EmfModel();
		StringProperties properties = new StringProperties();
		properties.put(EmfModel.PROPERTY_NAME, name);
		properties.put(EmfModel.PROPERTY_FILE_BASED_METAMODEL_URI,
				metamodelUri);
		properties.put(EmfModel.PROPERTY_MODEL_URI, 
				new File(model).toURI().toString());
		properties.put(EmfModel.PROPERTY_READONLOAD, readOnLoad + "");
		properties.put(EmfModel.PROPERTY_STOREONDISPOSAL, 
				storeOnDisposal + "");
		emfModel.load(properties, (IRelativePathResolver) null);
		return emfModel;
	}
	
	private String getEPackage(String urlOfYourMetamodel) throws MalformedURLException, URISyntaxException
	{
		//URL url = FileLocator.find(new File(urlOfYourMetamodel).toString());
		java.net.URI javaURI = new File(urlOfYourMetamodel).toURI();
		org.eclipse.emf.common.util.URI uriOfYourModel = org.eclipse.emf.common.util.URI.createURI(javaURI.toString());
		
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(
			    "ecore", new EcoreResourceFactoryImpl());
		
			ResourceSet rs = new ResourceSetImpl();
			// enable extended metadata
			final ExtendedMetaData extendedMetaData = new BasicExtendedMetaData(rs.getPackageRegistry());
			rs.getLoadOptions().put(XMLResource.OPTION_EXTENDED_META_DATA,
			    extendedMetaData);
			
			
			
			Resource r = rs.getResource(uriOfYourModel, true);
			EObject eObject = r.getContents().get(0);
			if (eObject instanceof EPackage) {
			    EPackage p = (EPackage)eObject;
			    rs.getPackageRegistry().put(p.getNsURI(), p);
			    rs.getPackageRegistry().putIfAbsent(p.getNsURI(), p);
			   EPackage.Registry.INSTANCE.put(p.getNsURI(), p);
			    
			 boolean test= EPackage.Registry.INSTANCE.containsKey(p.getNsURI());
			System.out.print(test+"\t");
			 System.out.println("registery: "+p.getNsURI());
			
			    
			    
			    return p.getNsURI();
			    }
			return null;
	}
	
	private EmfMetaModel createEmfMetaModel(String name, String address,
			boolean readOnLoad, boolean storeOnDisposal) 
					throws EolModelLoadingException, URISyntaxException, MalformedURLException {
		String metamodelUri = getEPackage(address);

		EmfMetaModel emfMetaModel = new EmfMetaModel(name,metamodelUri);
		emfMetaModel.setReadOnLoad(readOnLoad);
		emfMetaModel.setStoredOnDisposal(storeOnDisposal);
		
		emfMetaModel.load();
		emfMetaModel.getResource().getResourceSet().getPackageRegistry().put(EcorePackage.eINSTANCE.getNsURI(), EcorePackage.eINSTANCE);
		return emfMetaModel;
	}

private File getFile(String fileName) throws URISyntaxException {
		
		URI binUri = this.getClass().
				getResource(fileName).toURI();
		URI uri = null;
		
		if (binUri.toString().indexOf("bin") > -1) {
			uri = new URI(binUri.toString().replaceAll("bin", "src"));
		}
		else {
			uri = binUri;
		}
		
		return new File(uri);
	}

}
