/*******************************************************************************
 * Copyright (c) 2008, 2010 VMware Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   VMware Inc. - initial contribution
 *******************************************************************************/

package org.eclipse.virgo.snaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.eclipse.gemini.web.core.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * TODO Document SnapsTag
 * <p />
 * 
 * <strong>Concurrent Semantics</strong><br />
 * 
 * TODO Document concurrent semantics of SnapsTag
 * 
 */
public final class SnapsTag extends BodyTagSupport {
	
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 4715961747733658692L;

    private static final String SNAP_SERVICE_CLASS = "org.eclipse.virgo.snaps.core.internal.Snap";

    public static final String SNAPS_ATTRIBUTE_NAME = "snaps";

    private volatile String attributeName = SNAPS_ATTRIBUTE_NAME;
    
    public static final String SNAPS_TREE_NAME = "snapstree";
    
    private volatile String treeName =  SNAPS_TREE_NAME;

    public void setVar(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getVar() {
        return this.attributeName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int doStartTag() throws JspException {
        BundleContext bundleContext = (BundleContext) this.pageContext.getServletContext().getAttribute(WebContainer.ATTRIBUTE_BUNDLE_CONTEXT);
        long hostId = bundleContext.getBundle().getBundleId();
        try {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(SNAP_SERVICE_CLASS, "(snap.host.id=" + hostId + ")");

            List<Snap> snaps = new ArrayList<Snap>();

            if (serviceReferences != null) {
                Arrays.sort(serviceReferences);
                for (ServiceReference serviceReference : serviceReferences) {
                    snaps.add(createSnap(serviceReference));
                }
            }
            this.pageContext.setAttribute(this.attributeName, snaps);
            
            
            
            // put HOST snap as RootElement
            Map<String, Object> rootProperties = new HashMap<String, Object>();
            rootProperties.put(Snap.CONTEXT_PATH_PROPERTY_KEY, "/");
            rootProperties.put(Snap.NAME_PROPERTY_KEY, "ROOT");
            Snap rootSnap = new Snap(rootProperties);
            
            //snapsTree.setData(rootSnap);
            // put them into TreeMap sorted by ContextPath
            TreeMap<String, Snap> treeMap = new TreeMap<String, Snap>();
            for(Snap snap:snaps) {
            	treeMap.put(snap.getContextPath(), snap);
            }
            
            // to make the snaps as Tree data struture
            SnapsTree snapsTree = new SnapsTree();
            SnapsNode rootNode = new SnapsNode(rootSnap);
            
            List<String> pathList = new ArrayList<String>();
            pathList.add(rootSnap.getContextPath());
            
            List<SnapsNode> nodeList = new ArrayList<SnapsNode>();
            nodeList.add(rootNode);
            
            Integer depthLevel = new Integer(0);
            
            // Initialize
            snapsTree.setRootElement(rootNode);
            snapsTree.setNodeList(nodeList);
            snapsTree.setPathList(pathList);
            snapsTree.setDepthLevel(depthLevel);
            
            Snap snap = null;
            
            for(Map.Entry<String, Snap> entry:treeMap.entrySet()) {
            	snap = entry.getValue();
            	SnapsNode thisNode = new SnapsNode(snap);
            	
            	
            	snapsTree = makeSnapsTree(snapsTree, thisNode);
            }
          
            logger.info(snapsTree.getRootElement().toString());
            
            this.pageContext.setAttribute(this.treeName, snapsTree);
            
        } catch (InvalidSyntaxException ise) {
            throw new JspException("Unexpected InvalidSyntaxException when querying service registry for Snaps", ise);
        }

        return EVAL_BODY_INCLUDE;
    }
    
    private SnapsTree makeSnapsTree(SnapsTree snapsTree, SnapsNode thisNode) {
    	
    	List<SnapsNode> nodeList = snapsTree.getNodeList();
    	List<String> pathList = snapsTree.getPathList();
    	Integer depthLevel = snapsTree.getDepthLevel();
    	
    	Snap snap = thisNode.getData();
    	
    	logger.info("snap.getContextPath():"+snap.getContextPath());
    	logger.info("pathList.get(pathList.size()-1)):"+pathList.get(pathList.size()-1));
    	logger.info("include:"+snap.getContextPath().contains(pathList.get(pathList.size()-1)));
    	
    	// TODO if there /a , /a/b/c ,/x/a/b/c 
    	if( snap.getContextPath().contains(pathList.get(pathList.size()-1))) {
    		
    		logger.info("nodeList>>"+nodeList.toString());
    		logger.info("pathList>>"+pathList.toString());
    		
    		SnapsNode parentNode = nodeList.get(nodeList.size()-1);
    		parentNode.addChild(thisNode);
    		
    		nodeList.add(thisNode);
    		pathList.add(snap.getContextPath());
    		
    		snapsTree.setNodeList(nodeList);
    		snapsTree.setPathList(pathList);
    		snapsTree.setDepthLevel(depthLevel++);
    		
    		logger.info(snapsTree.toString());
    		
    	} else {
    		
    		snapsTree.setDepthLevel(depthLevel--);
    		pathList.remove(pathList.size()-1);
    		snapsTree.setPathList(pathList);
    		nodeList.remove(nodeList.size()-1);
    		snapsTree.setNodeList(nodeList);
    		
    		logger.info(snapsTree.toString());
    		
    		makeSnapsTree(snapsTree, thisNode);
    		
    	}
    	    	
    	return snapsTree;
    }
    


    @Override
    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute(this.attributeName);
        return EVAL_PAGE;
    }

    private static Snap createSnap(ServiceReference serviceReference) {
        String[] propertyKeys = serviceReference.getPropertyKeys();
        Map<String, Object> attributes = new HashMap<String, Object>();
        for (String key : propertyKeys) {
            attributes.put(key, serviceReference.getProperty(key));
        }
        return new Snap(attributes);
    }
}
