package org.eclipse.virgo.snaps;

import java.util.ArrayList;
import java.util.List;

public class SnapsNode {

	
	private Snap data;
	private List<SnapsNode> children = new ArrayList<SnapsNode>();
	

	
	public SnapsNode(Snap snap) {
		this.data = snap;
	}
	
	public List<SnapsNode> getChildren() {
		if(this.children == null) {
			return new ArrayList<SnapsNode>();
		}
		return this.children;
	}
	
	public void addChild(SnapsNode node) {
		getChildren().add(node);
	}
	
	public Snap getData() {
		return this.data;
	}
	

	public String toString() {
		return "data="+data+"; children="+children; 
		
	}
}
