/*
 * Decompiled with CFR 0.152.
 */
package richeditortest.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SampleView
extends ViewPart {
    public static final String ID = "pruebaplugin.views.SampleView";
    boolean buttonVisible = false;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        final RichTextEditor editor = new RichTextEditor(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editor);
        final Text htmlOutput = new Text(parent, 2634);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).applyTo((Control)htmlOutput);
        editor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                htmlOutput.setText(editor.getText());
            }
        });
        editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                System.out.println("keycode: " + e.keyCode);
                System.out.println("character: " + e.character);
            }
        });
        this.createControlPanel(parent, editor);
    }

    public void setFocus() {
    }

    protected void createControlPanel(Composite parent, final RichTextEditor editor) {
        Composite controlPanel = new Composite(parent, 0);
        controlPanel.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)controlPanel);
        Label inputLabel = new Label(controlPanel, 0);
        inputLabel.setText("Text to set:");
        GridDataFactory.fillDefaults().applyTo((Control)inputLabel);
        final Text input = new Text(controlPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)input);
        input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    editor.setText(input.getText());
                }
            }
        });
        Button setButton = new Button(controlPanel, 8);
        setButton.setText("Set Text");
        GridDataFactory.defaultsFor((Control)setButton).applyTo((Control)setButton);
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.setText(input.getText());
            }
        });
        Composite buttonPanel = new Composite(controlPanel, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)buttonPanel);
        Button getButton = new Button(buttonPanel, 8);
        getButton.setText("Get text");
        getButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog.openInformation(null, (String)"Editor Input", (String)editor.getText());
            }
        });
        final Button enableButton = new Button(buttonPanel, 8);
        enableButton.setText("Disable");
        enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editable = editor.isEditable();
                editor.setEditable(!editable);
                enableButton.setText(editable ? "Enable" : "Disable");
            }
        });
        Button setFocusButton = new Button(buttonPanel, 8);
        setFocusButton.setText("Set Focus");
        setFocusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.setFocus();
            }
        });
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return new String[]{"One", "Two", "Three"};
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

