package testtoolbars;

import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

/**
 * An action bar advisor is responsible for creating, adding, and disposing of
 * the actions added to a workbench window. Each window will be populated with
 * new actions.
 */
public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

    // Actions - important to allocate these only in makeActions, and then use
    // them
    // in the fill methods. This ensures that the actions aren't recreated
    // when fillActionBars is called with FILL_PROXY.

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    @Override
    protected void fillCoolBar(ICoolBarManager coolBar) {
        IWorkbenchWindow window = getActionBarConfigurer().getWindowConfigurer()
                .getWindow();

        IToolBarManager fileToolBar = new ToolBarManager(SWT.FLAT);
        fileToolBar.add(ActionFactory.SAVE.create(window));
        fileToolBar.add(ActionFactory.SAVE_ALL.create(window));
        coolBar.add(fileToolBar);

        IToolBarManager editToolBar = new ToolBarManager(SWT.FLAT);
        editToolBar.add(ActionFactory.COPY.create(window));
        editToolBar.add(ActionFactory.CUT.create(window));
        coolBar.add(editToolBar);
    }

}
