/**
 * generated by Xtext 2.9.0
 */
package org.xtext.example.mydsl.generator;

import com.einsights.questionmodel.querymodel.FunctionNode;
import com.einsights.questionmodel.querymodel.NameNode;
import com.einsights.questionmodel.querymodel.Node;
import com.einsights.questionmodel.querymodel.RootNode;
import com.einsights.questionmodel.querymodel.SelectNode;
import com.einsights.schema.model.AggregationType;
import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.xtext.example.mydsl.einDsl.Aggregation;
import org.xtext.example.mydsl.einDsl.Dimension;
import org.xtext.example.mydsl.einDsl.GroupBy;
import org.xtext.example.mydsl.einDsl.MeasureList;
import org.xtext.example.mydsl.einDsl.TimeGroup;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class EinDslGenerator extends AbstractGenerator {
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    CharSequence _generateQuestionModel = this.generateQuestionModel(resource);
    fsa.generateFile("/DEFAULT_ARTIFACT", _generateQuestionModel);
  }
  
  public CharSequence generateQuestionModel(final Resource resource) {
    CharSequence _xblockexpression = null;
    {
      RootNode root = new RootNode();
      Node _selectNode = this.getSelectNode(resource);
      root.addChildren(_selectNode);
      Gson gson = new Gson();
      String json = gson.toJson(root);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(json, "");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public Node getSelectNode(final Resource resource) {
    TreeIterator<EObject> _allContents = resource.getAllContents();
    Iterator<MeasureList> _filter = Iterators.<MeasureList>filter(_allContents, MeasureList.class);
    final Function1<MeasureList, Class<MeasureList>> _function = new Function1<MeasureList, Class<MeasureList>>() {
      @Override
      public Class<MeasureList> apply(final MeasureList it) {
        return MeasureList.class;
      }
    };
    Iterator<Class<MeasureList>> _map = IteratorExtensions.<MeasureList, Class<MeasureList>>map(_filter, _function);
    Iterable<Class<MeasureList>> measureNames = IteratorExtensions.<Class<MeasureList>>toIterable(_map);
    TreeIterator<EObject> _allContents_1 = resource.getAllContents();
    Iterator<Aggregation> _filter_1 = Iterators.<Aggregation>filter(_allContents_1, Aggregation.class);
    final Function1<Aggregation, String> _function_1 = new Function1<Aggregation, String>() {
      @Override
      public String apply(final Aggregation it) {
        return it.getAgg();
      }
    };
    Iterator<String> _map_1 = IteratorExtensions.<Aggregation, String>map(_filter_1, _function_1);
    Iterable<String> aggregation = IteratorExtensions.<String>toIterable(_map_1);
    TreeIterator<EObject> _allContents_2 = resource.getAllContents();
    Iterator<GroupBy> _filter_2 = Iterators.<GroupBy>filter(_allContents_2, GroupBy.class);
    final Function1<GroupBy, EList<EObject>> _function_2 = new Function1<GroupBy, EList<EObject>>() {
      @Override
      public EList<EObject> apply(final GroupBy it) {
        return it.getGroup();
      }
    };
    Iterator<EList<EObject>> _map_2 = IteratorExtensions.<GroupBy, EList<EObject>>map(_filter_2, _function_2);
    Iterable<EList<EObject>> _iterable = IteratorExtensions.<EList<EObject>>toIterable(_map_2);
    final Function2<EList<EObject>, EList<EObject>, EList<EObject>> _function_3 = new Function2<EList<EObject>, EList<EObject>, EList<EObject>>() {
      @Override
      public EList<EObject> apply(final EList<EObject> a, final EList<EObject> b) {
        return a;
      }
    };
    EList<EObject> group = IterableExtensions.<EList<EObject>>reduce(_iterable, _function_3);
    SelectNode select = new SelectNode();
    NameNode nn = new NameNode("test");
    FunctionNode fn = new FunctionNode(AggregationType.SUM);
    for (final Class<MeasureList> meas : measureNames) {
      String _name = meas.getName();
      NameNode _nameNode = new NameNode(_name);
      nn = _nameNode;
    }
    for (final String agg : aggregation) {
      {
        AggregationType aggregationType = this.getAggregationFromString(agg);
        FunctionNode _functionNode = new FunctionNode(aggregationType);
        fn = _functionNode;
      }
    }
    fn.addChildren(nn);
    select.addChildren(fn);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(group);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      List<Node> _nonAggregatedNodes = this.getNonAggregatedNodes(group);
      for (final Node node : _nonAggregatedNodes) {
        select.addChildren(node);
      }
    }
    return select;
  }
  
  public AggregationType getAggregationFromString(final String operation) {
    Pair<String, String> _mappedTo = Pair.<String, String>of("average", "avg");
    Pair<String, String> _mappedTo_1 = Pair.<String, String>of("total", "sum");
    Pair<String, String> _mappedTo_2 = Pair.<String, String>of("count", "count");
    final HashMap<String, String> aggMap = CollectionLiterals.<String, String>newHashMap(_mappedTo, _mappedTo_1, _mappedTo_2);
    String opp = aggMap.get(operation);
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(opp);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      String _upperCase = opp.toUpperCase();
      return AggregationType.valueOf(_upperCase);
    }
    return null;
  }
  
  public List<Node> getNonAggregatedNodes(final EList<EObject> dimensions) {
    ArrayList<Node> list = CollectionLiterals.<Node>newArrayList();
    for (final EObject dim : dimensions) {
      {
        if ((dim instanceof Dimension)) {
          EList<String> _dimension = ((Dimension)dim).getDimension();
          String _get = _dimension.get(0);
          NameNode nn = new NameNode(_get);
          list.add(nn);
        }
        if ((dim instanceof TimeGroup)) {
          String _timeGroup = ((TimeGroup)dim).getTimeGroup();
          NameNode nn_1 = new NameNode(_timeGroup);
          list.add(nn_1);
        }
      }
    }
    return list;
  }
}
