/**
 * generated by Xtext 2.9.0
 */
package org.xtext.example.mydsl.tests;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xtext.example.mydsl.einDsl.Condtition;
import org.xtext.example.mydsl.einDsl.DayTimeGroup;
import org.xtext.example.mydsl.einDsl.Group;
import org.xtext.example.mydsl.einDsl.MeasureList;
import org.xtext.example.mydsl.einDsl.Model;
import org.xtext.example.mydsl.einDsl.QTypekeyWord;
import org.xtext.example.mydsl.einDsl.Query;
import org.xtext.example.mydsl.einDsl.TimeGroup;
import org.xtext.example.mydsl.tests.EinDslInjectorProvider;

@RunWith(XtextRunner.class)
@InjectWith(EinDslInjectorProvider.class)
@SuppressWarnings("all")
public class EinDslParsingTest {
  @Inject
  private ParseHelper<Model> parseHelper;
  
  @Test
  public void testMeasure() {
    try {
      final String query = "comm #";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("comm #");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasure() {
    try {
      final String query = "plot comm";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("comm");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureWithSpace() {
    try {
      final String query = "plot profit ";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureByDimension() {
    try {
      final String query = "plot profit by country";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String dimension = this.getDimension(groupBy);
      Assert.assertEquals(dimension, "country");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void testPlotTwoMeasuresByDimension() {
    try {
      final String query = "plot profit and comm by country";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit", "comm");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String dimension = this.getDimension(groupBy);
      Assert.assertEquals(dimension, "country");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMultiWordTwoMeasuresByDimension() {
    try {
      final String query = "plot profit Margin and comm by country";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit Margin", "comm");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String dimension = this.getDimension(groupBy);
      Assert.assertEquals(dimension, "country");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureByDimensionByTime() {
    try {
      final String query = "plot profit by country by month";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String dimension = this.getDimension(groupBy);
      String timeDimension = this.getTimeDimension(groupBy);
      Assert.assertEquals(timeDimension, "month");
      Assert.assertEquals(dimension, "country");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureByTime() {
    try {
      final String query = "plot profit by month";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String timeDimension = this.getTimeDimension(groupBy);
      Assert.assertEquals(timeDimension, "month");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureByMultiWordDimension() {
    try {
      final String query = "plot profit by sales area";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      EList<Group> groupBy = this.getGroupBy(result);
      String dimension = this.getDimension(groupBy);
      Assert.assertEquals(dimension, "sales area");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasureForTime() {
    try {
      final String query = "plot comm for ";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("comm");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMeasure1ForTime() {
    try {
      final String query = "plot profit for today";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("profit");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      Query _greetings = result.getGreetings();
      Condtition _condition = _greetings.getCondition();
      DayTimeGroup _dayTimeGroup = _condition.getDayTimeGroup();
      String _dayTimeGroup_1 = _dayTimeGroup.getDayTimeGroup();
      Assert.assertEquals("today", _dayTimeGroup_1);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Test
  public void testPlotMultiWordMeasureWithSpecialCharacterForTime() {
    try {
      final String query = "plot p|r:o[]{}!@#$%^&*()~ +,.?/34523523fes and policy @#$#@@ for today";
      final Model result = this.parseHelper.parse(query);
      List<String> expected = Arrays.<String>asList("p|r:o[]{}!@#$%^&*()~ +,.?/34523523fes", "policy @#$#@@");
      String _qkeyWord = this.getQkeyWord(result);
      Assert.assertEquals(_qkeyWord, "plot");
      List<String> _measureList = this.getMeasureList(result);
      Assert.assertEquals(expected, _measureList);
      Query _greetings = result.getGreetings();
      Condtition _condition = _greetings.getCondition();
      DayTimeGroup _dayTimeGroup = _condition.getDayTimeGroup();
      String _dayTimeGroup_1 = _dayTimeGroup.getDayTimeGroup();
      Assert.assertEquals("today", _dayTimeGroup_1);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public EList<Group> getGroupBy(final Model model) {
    Query _greetings = model.getGreetings();
    return _greetings.getGroupBy();
  }
  
  public String getDimension(final EList<Group> groups) {
    Group _get = groups.get(0);
    return _get.getDimGroup();
  }
  
  public String getTimeDimension(final EList<Group> groups) {
    Group _get = groups.get(0);
    EList<TimeGroup> _timeGroup = _get.getTimeGroup();
    TimeGroup _get_1 = _timeGroup.get(0);
    return _get_1.getTimeGroup();
  }
  
  public String getQkeyWord(final Model result) {
    Query _greetings = result.getGreetings();
    QTypekeyWord _key = _greetings.getKey();
    return _key.getQKeyword();
  }
  
  public List<String> getMeasureList(final Model result) {
    Query _greetings = result.getGreetings();
    MeasureList _measure = _greetings.getMeasure();
    EList<String> _names = _measure.getNames();
    return IterableExtensions.<String>toList(_names);
  }
}
