/*
 * generated by Xtext 2.9.0
 */
package org.xtext.example.mydsl.tests

import com.google.inject.Inject
import org.eclipse.xtext.junit4.InjectWith
import org.eclipse.xtext.junit4.XtextRunner
import org.eclipse.xtext.junit4.util.ParseHelper
import org.junit.Assert
import org.junit.Test
import org.junit.runner.RunWith
import org.xtext.example.mydsl.einDsl.Model
import java.util.Arrays
import org.eclipse.emf.common.util.EList
import org.xtext.example.mydsl.einDsl.Group
import com.einsights.suggestions.dsl.support.Util.*
import java.util.List

@RunWith(XtextRunner)
@InjectWith(EinDslInjectorProvider)
class EinDslParsingTest{

	@Inject
	ParseHelper<Model> parseHelper;


	@Test
	def void testMeasure() {

		val query="comm #"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("comm #")
		Assert.assertEquals(expected,result.getMeasureList)

	}

	@Test
	def void testPlotMeasure() {
		val query="plot comm"
  		val result = parseHelper.parse(query)

		var expected =Arrays.asList("comm")
		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

	}
	@Test
	def void testPlotMeasureWithSpace() {
		val query="plot profit "
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")
		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

	}

	@Test
	def void testPlotMeasureByDimension() {

		val query ="plot profit by country"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)



		var groupBy=getGroupBy(result)
		var dimension =getDimension(groupBy)
		Assert.assertEquals(dimension,"country")

	}

	//@Test
	def void testPlotTwoMeasuresByDimension() {
		val query="plot profit and comm by country"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit","comm")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

		var groupBy=result.getGroupBy
		var dimension =getDimension(groupBy)

		Assert.assertEquals(dimension,"country")

	}

	@Test
	def void testPlotMultiWordTwoMeasuresByDimension() {

		val query="plot profit Margin and comm by country"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit Margin","comm")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

		var groupBy=result.getGroupBy
		var dimension =getDimension(groupBy)
	    Assert.assertEquals(dimension,"country")

	}


	@Test
	def void testPlotMeasureByDimensionByTime() {

		val query ="plot profit by country by month"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

		var groupBy=result.getGroupBy
		var dimension =getDimension(groupBy)
		var timeDimension=getTimeDimension(groupBy)

		Assert.assertEquals(timeDimension,"month")
		Assert.assertEquals(dimension,"country")

	}

	@Test
	def void testPlotMeasureByTime() {

		val query ="plot profit by month"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

		var groupBy=result.getGroupBy
		var timeDimension=getTimeDimension(groupBy)

		Assert.assertEquals(timeDimension,"month")

	}


	@Test
	def void testPlotMeasureByMultiWordDimension() {

		val query ="plot profit by sales area"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)

		var groupBy=result.getGroupBy
		var dimension =getDimension(groupBy)
		Assert.assertEquals(dimension,"sales area")

	}

	@Test
	def void testPlotMeasureForTime() {

		val query ="plot comm for "
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("comm")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)


	}

	@Test
	def void testPlotMeasure1ForTime() {

		val query ="plot profit for today"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("profit")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)
		Assert.assertEquals("today",result.getGreetings.condition.getDayTimeGroup.getDayTimeGroup)


	}




	@Test
	def void testPlotMultiWordMeasureWithSpecialCharacterForTime() {

		val query ="plot p|r:o[]{}!@#$%^&*()~ +,.?/34523523fes and policy @#$#@@ for today"
		val result = parseHelper.parse(query)

		var expected =Arrays.asList("p|r:o[]{}!@#$%^&*()~ +,.?/34523523fes","policy @#$#@@")

		Assert.assertEquals(result.getQkeyWord,"plot")
		Assert.assertEquals(expected,result.getMeasureList)
		Assert.assertEquals("today",result.getGreetings.condition.getDayTimeGroup.getDayTimeGroup)


	}


	def EList<Group> getGroupBy(Model model){

	return  model.greetings.getGroupBy
}

	def String getDimension(EList<Group> groups){

		return groups.get(0).getDimGroup
	}

	def String getTimeDimension(EList<Group> groups){

		return groups.get(0).getTimeGroup.get(0).getTimeGroup
	}

	def String getQkeyWord(Model result){

		return result.greetings.key.getQKeyword

	}

	def List<String> getMeasureList(Model result){

		return result.greetings.measure.names.toList

	}


}
